/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.saucelabs;

import com.google.inject.Inject;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.saucelabs.LinkGenerator;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.codec.binary.Hex;

public class SaucelabsLinkGenerator
implements LinkGenerator {
    private EnvironmentVariables environmentVariables;

    public SaucelabsLinkGenerator() {
    }

    @Inject
    public SaucelabsLinkGenerator(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String linkFor(TestOutcome testOutcome) {
        if (this.saucelabsIsNotConfigured()) {
            return null;
        }
        if (this.noSessionIdIsFoundFor(testOutcome)) {
            return null;
        }
        if (this.accessKeyAvailable()) {
            return this.noLoginLinkFor(testOutcome.getSessionId());
        }
        return this.simpleLinkFor(testOutcome.getSessionId());
    }

    private boolean saucelabsIsNotConfigured() {
        return ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables) == null;
    }

    private boolean noSessionIdIsFoundFor(TestOutcome testOutcome) {
        return testOutcome.getSessionId() == null;
    }

    private String simpleLinkFor(String jobId) {
        return "http://saucelabs.com/jobs/" + jobId;
    }

    private String noLoginLinkFor(String jobId) {
        String accessKey = ThucydidesSystemProperty.SAUCELABS_ACCESS_KEY.from(this.environmentVariables);
        String username = ThucydidesSystemProperty.SAUCELABS_USER_ID.from(this.environmentVariables);
        String authCode = this.generateHMACFor(username + ":" + accessKey, jobId);
        return "https://saucelabs.com/jobs/" + jobId + "?auth=" + authCode;
    }

    private String generateHMACFor(String secretKey, String message) {
        try {
            byte[] keyBytes = secretKey.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec key = new SecretKeySpec(keyBytes, 0, keyBytes.length, "HmacMD5");
            Mac mac = Mac.getInstance("HmacMD5");
            mac.init(key);
            return new String(Hex.encodeHex((byte[])mac.doFinal(message.getBytes())));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Could not generate HMAC for some reason", e);
        }
    }

    private boolean accessKeyAvailable() {
        return ThucydidesSystemProperty.SAUCELABS_ACCESS_KEY.from(this.environmentVariables) != null;
    }
}

