/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RootDirectory {
    private final EnvironmentVariables environmentVariables;
    private final String rootDirectoryPath;
    private static final String FEATURES_ROOT_DIRECTORY = "features";
    private static final String STORIES_ROOT_DIRECTORY = "stories";
    private static final String DEFAULT_RESOURCE_DIRECTORY = "src/test/resources";
    private Set<String> configuredRelativeRootDirectories;
    private static final Pattern WINDOWS_PATH = Pattern.compile("([a-zA-Z]:)?(\\\\[a-zA-Z0-9_-]+)+\\\\?");

    public RootDirectory(EnvironmentVariables environmentVariables) {
        this(environmentVariables, RootDirectory.defaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()));
    }

    public RootDirectory(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this.environmentVariables = environmentVariables;
        this.rootDirectoryPath = rootDirectoryPath;
    }

    public Set<String> getRootDirectoryPaths() {
        try {
            if (ThucydidesSystemProperty.THUCYDIDES_TEST_REQUIREMENTS_BASEDIR.isDefinedIn(this.environmentVariables)) {
                return this.getRootDirectoryFromRequirementsBaseDir();
            }
            return this.firstDefinedOf(this.getRootDirectoryFromClasspath(), this.getFileSystemDefinedDirectory(), this.getRootDirectoryFromWorkingDirectory());
        }
        catch (IOException e) {
            return new HashSet<String>();
        }
    }

    private Set<String> firstDefinedOf(Set<String> ... paths) {
        for (Set<String> path : paths) {
            if (path.isEmpty()) continue;
            return path;
        }
        return Sets.newHashSet();
    }

    private Set<String> getRootDirectoryFromClasspath() throws IOException {
        ArrayList<URL> resourceRoots;
        try {
            Enumeration<URL> requirementResources = this.getDirectoriesFrom(this.rootDirectoryPath);
            resourceRoots = Collections.list(requirementResources);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return this.restoreSpacesIn(resourceRoots);
    }

    private Set<String> restoreSpacesIn(List<URL> resourceRoots) {
        HashSet urlsWithRestoredSpaces = Sets.newHashSet();
        for (URL resourceRoot : resourceRoots) {
            urlsWithRestoredSpaces.add(this.withRestoredSpaces(resourceRoot.getPath()));
        }
        return urlsWithRestoredSpaces;
    }

    private String withRestoredSpaces(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return StringUtils.replace((String)path, (String)"%20", (String)" ");
        }
    }

    private Set<String> getFileSystemDefinedDirectory() throws IOException {
        if (Paths.get(this.rootDirectoryPath, new String[0]).toAbsolutePath().toFile().exists()) {
            return Sets.newHashSet((Object[])new String[]{Paths.get(this.rootDirectoryPath, new String[0]).toAbsolutePath().toString()});
        }
        return Sets.newHashSet();
    }

    private Set<String> getRootDirectoryFromWorkingDirectory() throws IOException {
        String workingDirectory = System.getProperty("user.dir");
        String mavenBuildDir = System.getProperty("project.build.directory");
        String resultDir = "";
        resultDir = !StringUtils.isEmpty((CharSequence)mavenBuildDir) ? mavenBuildDir : workingDirectory;
        return this.getRootDirectoryFromParentDir(resultDir);
    }

    private Set<String> getRootDirectoryFromRequirementsBaseDir() {
        if (this.configuredRelativeRootDirectories == null) {
            this.configuredRelativeRootDirectories = this.getRootDirectoryFromParentDir(ThucydidesSystemProperty.THUCYDIDES_TEST_REQUIREMENTS_BASEDIR.from(this.environmentVariables, ""));
        }
        return this.configuredRelativeRootDirectories;
    }

    private Set<String> getRootDirectoryFromParentDir(String parentDir) {
        File resourceDirectory = RootDirectory.getResourceDirectory(this.environmentVariables).isPresent() ? new File(parentDir, (String)RootDirectory.getResourceDirectory(this.environmentVariables).get()) : new File(parentDir);
        File requirementsDirectory = this.absolutePath(this.rootDirectoryPath) ? new File(this.rootDirectoryPath) : new File(resourceDirectory, this.rootDirectoryPath);
        HashSet directoryPaths = Sets.newHashSet();
        if (requirementsDirectory.exists()) {
            directoryPaths.add(requirementsDirectory.getAbsolutePath());
        }
        if (new File(resourceDirectory, FEATURES_ROOT_DIRECTORY).exists()) {
            directoryPaths.add(new File(resourceDirectory, FEATURES_ROOT_DIRECTORY).getAbsolutePath());
        }
        if (new File(resourceDirectory, STORIES_ROOT_DIRECTORY).exists()) {
            directoryPaths.add(new File(resourceDirectory, FEATURES_ROOT_DIRECTORY).getAbsolutePath());
        }
        return directoryPaths;
    }

    private boolean absolutePath(String rootDirectoryPath) {
        return new File(rootDirectoryPath).isAbsolute() || rootDirectoryPath.startsWith("/");
    }

    private Enumeration<URL> getDirectoriesFrom(String root) throws IOException, URISyntaxException {
        String rootWithEscapedSpaces = root.replaceAll(" ", "%20");
        URI rootUri = this.isWindowsPath(rootWithEscapedSpaces) ? new File(root).toPath().toUri() : new URI(rootWithEscapedSpaces);
        return this.getClass().getClassLoader().getResources(rootUri.getPath());
    }

    private boolean isWindowsPath(String rootWithEscapedSpaces) {
        return WINDOWS_PATH.matcher(rootWithEscapedSpaces).find();
    }

    public static String defaultRootDirectoryPathFrom(EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.isDefinedIn(environmentVariables)) {
            return ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.from(environmentVariables);
        }
        Optional<String> resourceDirectory = RootDirectory.getResourceDirectory(environmentVariables);
        if (resourceDirectory.isPresent()) {
            String resourceDir = (String)resourceDirectory.get();
            if (new File(resourceDir, STORIES_ROOT_DIRECTORY).exists()) {
                return STORIES_ROOT_DIRECTORY;
            }
            if (new File(resourceDir, FEATURES_ROOT_DIRECTORY).exists()) {
                return FEATURES_ROOT_DIRECTORY;
            }
        }
        return STORIES_ROOT_DIRECTORY;
    }

    public static Optional<String> getResourceDirectory(EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.isDefinedIn(environmentVariables)) {
            return Optional.absent();
        }
        return Optional.of((Object)DEFAULT_RESOURCE_DIRECTORY);
    }
}

