/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import gherkin.formatter.Formatter;
import gherkin.formatter.model.Tag;
import gherkin.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.cucumber.CucumberFeatureListener;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.io.FileUtils;

public class CucumberParser {
    private final String locale;
    private final String encoding;

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<Narrative> loadFeatureNarrative(File narrativeFile) {
        CucumberFeatureListener gherkinStructure = new CucumberFeatureListener();
        Parser parser = new Parser((Formatter)gherkinStructure, true, "root", false, this.locale);
        try {
            String gherkinScenarios = this.filterOutCommentsFrom(FileUtils.readFileToString((File)narrativeFile, (String)this.encoding));
            parser.parse(gherkinScenarios, narrativeFile.getName(), Integer.valueOf(0));
            if (this.featureFileCouldNotBeReadFor(gherkinStructure)) {
                return Optional.absent();
            }
            String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(gherkinStructure));
            List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(gherkinStructure));
            String title = gherkinStructure.getFeature().getName();
            String text = gherkinStructure.getFeature().getDescription();
            String id = gherkinStructure.getFeature().getId();
            return Optional.of((Object)new Narrative((Optional<String>)Optional.fromNullable((Object)title), (Optional<String>)Optional.fromNullable((Object)id), (Optional<String>)Optional.fromNullable((Object)cardNumber), versionNumbers, "feature", text));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return Optional.absent();
        }
    }

    private boolean featureFileCouldNotBeReadFor(CucumberFeatureListener gherkinStructure) {
        return gherkinStructure.getFeature() == null;
    }

    private String filterOutCommentsFrom(String gherkin) {
        StringBuilder filteredGherkin = new StringBuilder();
        Scanner scanner = new Scanner(gherkin);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (line.trim().startsWith("#")) continue;
            filteredGherkin.append(line).append(System.lineSeparator());
        }
        scanner.close();
        return filteredGherkin.toString();
    }

    private List<Tag> tagsDefinedIn(CucumberFeatureListener gherkinStructure) {
        return gherkinStructure.getFeature() != null ? gherkinStructure.getFeature().getTags() : Lists.newArrayList();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList versionNumbers = Lists.newArrayList();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

