/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Optional;
import java.util.List;
import net.serenitybdd.core.pages.PagesAnnotatedField;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepsAnnotatedField;

public final class StepAnnotations {
    private StepAnnotations() {
    }

    public static void injectScenarioStepsInto(Object testCase, StepFactory stepFactory) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(testCase.getClass());
        StepAnnotations.instanciateScenarioStepFields(testCase, stepFactory, stepsFields);
    }

    public static void injectNestedScenarioStepsInto(Object scenarioSteps, StepFactory stepFactory, Class<?> scenarioStepsClass) {
        List<StepsAnnotatedField> stepsFields = StepsAnnotatedField.findOptionalAnnotatedFields(scenarioStepsClass);
        StepAnnotations.instanciateScenarioStepFields(scenarioSteps, stepFactory, stepsFields);
    }

    private static void instanciateScenarioStepFields(Object testCaseOrSteps, StepFactory stepFactory, List<StepsAnnotatedField> stepsFields) {
        for (StepsAnnotatedField stepsField : stepsFields) {
            StepAnnotations.instantiateAnyUnitiaializedSteps(testCaseOrSteps, stepFactory, stepsField);
        }
    }

    private static void instantiateAnyUnitiaializedSteps(Object testCaseOrSteps, StepFactory stepFactory, StepsAnnotatedField stepsField) {
        if (!stepsField.isInstantiated(testCaseOrSteps)) {
            Class<?> scenarioStepsClass = stepsField.getFieldClass();
            Object steps = StepAnnotations.useUniqueInstanceFor(stepsField) ? stepFactory.getNewStepLibraryFor(scenarioStepsClass) : stepFactory.getStepLibraryFor(scenarioStepsClass);
            stepsField.setValue(testCaseOrSteps, steps);
            StepAnnotations.injectNestedScenarioStepsInto(steps, stepFactory, scenarioStepsClass);
        }
    }

    private static boolean useUniqueInstanceFor(StepsAnnotatedField stepsField) {
        return stepsField.isUniqueInstance();
    }

    public static void injectAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        Optional<PagesAnnotatedField> pagesField = PagesAnnotatedField.findFirstAnnotatedField(testCase.getClass());
        if (pagesField.isPresent()) {
            pages.setDefaultBaseUrl(((PagesAnnotatedField)pagesField.get()).getDefaultBaseUrl());
            ((PagesAnnotatedField)pagesField.get()).setValue(testCase, pages);
        }
    }

    public static void injectOptionalAnnotatedPagesObjectInto(Object testCase, Pages pages) {
        Optional<PagesAnnotatedField> pagesField = PagesAnnotatedField.findOptionalAnnotatedField(testCase.getClass());
        if (pagesField.isPresent()) {
            pages.setDefaultBaseUrl(((PagesAnnotatedField)pagesField.get()).getDefaultBaseUrl());
            ((PagesAnnotatedField)pagesField.get()).setValue(testCase, pages);
        }
    }
}

