/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.beust.jcommander.internal.Maps;
import com.google.common.base.Optional;
import io.appium.java_client.AppiumDriver;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.webdriver.driverproviders.AppiumDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EdgeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.HtmlDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.InternetExplorerDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.PhantomJSDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ProvidedDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.SafariDriverProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.DriverStrategySelector;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.TimeoutStack;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.capabilities.SauceRemoteDriverCapabilities;
import net.thucydides.core.webdriver.redimension.RedimensionBrowser;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "firefox";
    public static final String REMOTE_DRIVER = "remote";
    private static final Logger LOGGER = LoggerFactory.getLogger(WebDriverFactory.class);
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;
    private final SauceRemoteDriverCapabilities sauceRemoteDriverCapabilities;
    private final CloseBrowser closeBrowser;
    private Map<SupportedWebDriver, DriverProvider> driverProvidersByDriverType;
    private final TimeoutStack timeoutStack;

    public WebDriverFactory() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(environmentVariables, (FixtureProviderService)Injectors.getInjector().getInstance(FixtureProviderService.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
        this.sauceRemoteDriverCapabilities = new SauceRemoteDriverCapabilities(environmentVariables);
        this.timeoutStack = new TimeoutStack();
        this.closeBrowser = (CloseBrowser)Injectors.getInjector().getInstance(CloseBrowser.class);
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        if (this.usesSauceLabs() && driverType != SupportedWebDriver.HTMLUNIT) {
            return RemoteWebDriver.class;
        }
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    private Map<SupportedWebDriver, DriverProvider> driverProviders() {
        if (this.driverProvidersByDriverType == null) {
            this.driverProvidersByDriverType = Maps.newHashMap();
            CapabilityEnhancer enhancer = new CapabilityEnhancer(this.environmentVariables, this.fixtureProviderService);
            this.driverProvidersByDriverType.put(SupportedWebDriver.APPIUM, new AppiumDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.REMOTE, new RemoteDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.FIREFOX, new FirefoxDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.HTMLUNIT, new HtmlDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.PHANTOMJS, new PhantomJSDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.CHROME, new ChromeDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.SAFARI, new SafariDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.IEXPLORER, new InternetExplorerDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.EDGE, new EdgeDriverProvider(this.environmentVariables, enhancer));
            this.driverProvidersByDriverType.put(SupportedWebDriver.PROVIDED, new ProvidedDriverProvider(this.environmentVariables, enhancer));
        }
        return this.driverProvidersByDriverType;
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        RedimensionBrowser redimensionBrowser = new RedimensionBrowser(this.environmentVariables, driverClass);
        try {
            SupportedWebDriver supportedDriverType = DriverStrategySelector.inEnvironment(this.environmentVariables).forDriverClass(driverClass);
            WebDriver driver = this.driverProviders().get((Object)supportedDriverType).newInstance();
            this.setImplicitTimeoutsIfSpecified(driver);
            redimensionBrowser.withDriver(driver);
            this.closeBrowser.closeWhenTheTestsAreFinished(driver);
            return driver;
        }
        catch (SerenityManagedException toPassThrough) {
            throw toPassThrough;
        }
        catch (Exception cause) {
            throw new UnsupportedDriverException("Could not instantiate new WebDriver instance of type " + driverClass + " (" + cause.getMessage(), cause);
        }
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.getPropertyName(), (Integer)0);
            driver.manage().timeouts().implicitlyWait((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables, String defaultDriver) {
        String driver = WebDriverFactory.getDriverFrom(environmentVariables);
        return driver != null ? driver : defaultDriver;
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.WEBDRIVER_DRIVER.from(environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.DRIVER.from(environmentVariables);
        }
        return driver;
    }

    public static String getBrowserStackDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.BROWSERSTACK_BROWSER.from(environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.BROWSERSTACK_BROWSERNAME.from(environmentVariables);
        }
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(environmentVariables);
        }
        return driver;
    }

    public static String getSaucelabsDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.SAUCELABS_BROWSERNAME.from(environmentVariables);
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(environmentVariables);
        }
        return driver;
    }

    public void setupFixtureServices() throws FixtureException {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.setup();
        }
    }

    public void shutdownFixtureServices() {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.shutdown();
        }
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock") && !driver.toString().contains("Mock for");
    }

    public void setTimeouts(WebDriver proxiedDriver, Duration implicitTimeout) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        this.timeoutStack.pushTimeoutFor(proxiedDriver, implicitTimeout);
        if (implicitTimeout != currentTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(implicitTimeout.in(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
    }

    public Duration currentTimeoutFor(WebDriver proxiedDriver) {
        Optional<Duration> storedTimeoutValue = this.timeoutStack.currentTimeoutValueFor(proxiedDriver);
        return (Duration)storedTimeoutValue.or((Object)this.getDefaultImplicitTimeout());
    }

    public Duration resetTimeouts(WebDriver proxiedDriver) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        if (!this.timeoutStack.containsTimeoutFor(proxiedDriver).booleanValue()) {
            return currentTimeout;
        }
        this.timeoutStack.popTimeoutFor(proxiedDriver);
        Duration previousTimeout = this.currentTimeoutFor(proxiedDriver);
        if (currentTimeout != previousTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(previousTimeout.in(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        }
        return previousTimeout;
    }

    public Duration getDefaultImplicitTimeout() {
        String configuredTimeoutValue = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.from(this.environmentVariables);
        return configuredTimeoutValue != null ? new Duration((long)Integer.parseInt(configuredTimeoutValue), TimeUnit.MILLISECONDS) : DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    public static boolean isAlive(WebDriver driver) {
        try {
            WebDriver local = driver;
            if (driver instanceof WebDriverFacade) {
                local = ((WebDriverFacade)driver).getDriverInstance();
            }
            if (!(local instanceof AppiumDriver)) {
                local.getCurrentUrl();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNotAlive(WebDriver driver) {
        return !WebDriverFactory.isAlive(driver);
    }
}

