/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.configuration;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.io.File;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.configuration.MavenOrGradleBuildPath;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.steps.FilePathParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.apache.commons.lang3.StringUtils;

public class SystemPropertiesConfiguration
implements Configuration {
    public static final String DEFAULT_WEBDRIVER_DRIVER = "firefox";
    public static final int DEFAULT_ELEMENT_TIMEOUT_SECONDS = 5;
    public static final Integer DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT = 5;
    public static final String PROJECT_BUILD_DIRECTORY = "project.build.directory";
    public static final String REFUSE_UNTRUSTED_CERTIFICATES = ThucydidesSystemProperty.REFUSE_UNTRUSTED_CERTIFICATES.getPropertyName();
    private File outputDirectory;
    private String defaultBaseUrl;
    private final EnvironmentVariables environmentVariables;
    private final FilePathParser filePathParser;

    @Inject
    public SystemPropertiesConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.filePathParser = new FilePathParser(environmentVariables);
    }

    @Override
    public Configuration copy() {
        return this.withEnvironmentVariables(this.environmentVariables);
    }

    @Override
    public Configuration withEnvironmentVariables(EnvironmentVariables environmentVariables) {
        SystemPropertiesConfiguration copy = new SystemPropertiesConfiguration(environmentVariables.copy());
        copy.outputDirectory = null;
        copy.defaultBaseUrl = this.defaultBaseUrl;
        return copy;
    }

    @Override
    public EnvironmentVariables getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public SupportedWebDriver getDriverType() {
        String driverType = WebDriverFactory.getDriverFrom(this.environmentVariables, DEFAULT_WEBDRIVER_DRIVER);
        return this.lookupSupportedDriverTypeFor(driverType);
    }

    public File loadOutputDirectoryFromSystemProperties() {
        String systemDefinedDirectory = MavenOrGradleBuildPath.specifiedIn(this.environmentVariables).getBuildDirectory();
        systemDefinedDirectory = this.filePathParser.getInstanciatedPath(systemDefinedDirectory);
        File newOutputDirectory = new File(systemDefinedDirectory);
        newOutputDirectory.mkdirs();
        return newOutputDirectory;
    }

    public void reloadOutputDirectory() {
        this.setOutputDirectory(this.loadOutputDirectoryFromSystemProperties());
    }

    @Override
    public int getStepDelay() {
        int stepDelay = 0;
        String stepDelayValue = ThucydidesSystemProperty.THUCYDIDES_STEP_DELAY.from(this.environmentVariables);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            stepDelay = Integer.parseInt(stepDelayValue);
        }
        return stepDelay;
    }

    @Override
    public int getElementTimeout() {
        int elementTimeout = 5;
        String stepDelayValue = ThucydidesSystemProperty.THUCYDIDES_TIMEOUT.from(this.environmentVariables);
        if (stepDelayValue != null && !stepDelayValue.isEmpty()) {
            elementTimeout = Integer.parseInt(stepDelayValue);
        }
        return elementTimeout;
    }

    @Override
    public boolean getUseUniqueBrowser() {
        return this.shouldUseAUniqueBrowser();
    }

    @Override
    public boolean shouldUseAUniqueBrowser() {
        return ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.booleanFrom(this.getEnvironmentVariables());
    }

    @Override
    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    @Override
    public File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = this.loadOutputDirectoryFromSystemProperties();
        }
        return this.outputDirectory;
    }

    @Override
    public double getEstimatedAverageStepCount() {
        return ThucydidesSystemProperty.THUCYDIDES_ESTIMATED_AVERAGE_STEP_COUNT.integerFrom(this.environmentVariables, DEFAULT_ESTIMATED_AVERAGE_STEP_COUNT);
    }

    @Override
    public boolean onlySaveFailingScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_ONLY_SAVE_FAILING_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public boolean takeVerboseScreenshots() {
        return this.getEnvironmentVariables().getPropertyAsBoolean(ThucydidesSystemProperty.THUCYDIDES_VERBOSE_SCREENSHOTS.getPropertyName(), false);
    }

    @Override
    public Optional<TakeScreenshots> getScreenshotLevel() {
        String takeScreenshotsLevel = ThucydidesSystemProperty.THUCYDIDES_TAKE_SCREENSHOTS.from(this.getEnvironmentVariables());
        if (StringUtils.isNotEmpty((CharSequence)takeScreenshotsLevel)) {
            return Optional.of((Object)((Object)TakeScreenshots.valueOf(takeScreenshotsLevel.toUpperCase())));
        }
        return Optional.absent();
    }

    @Override
    public void setIfUndefined(String property, String value) {
        if (this.getEnvironmentVariables().getProperty(property) == null) {
            this.getEnvironmentVariables().setProperty(property, value);
        }
    }

    @Override
    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    @Override
    public int getRestartFrequency() {
        return ThucydidesSystemProperty.THUCYDIDES_RESTART_BROWSER_FREQUENCY.integerFrom(this.environmentVariables);
    }

    @Override
    public int getCurrentTestCount() {
        return 0;
    }

    @Override
    public String getBaseUrl() {
        return this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_BASE_URL.getPropertyName(), this.defaultBaseUrl);
    }

    private SupportedWebDriver lookupSupportedDriverTypeFor(String driverType) {
        SupportedWebDriver driver = null;
        try {
            driver = SupportedWebDriver.getDriverTypeFor(driverType);
        }
        catch (IllegalArgumentException iae) {
            this.throwUnsupportedDriverExceptionFor(driverType);
        }
        return driver;
    }

    private void throwUnsupportedDriverExceptionFor(String driverType) {
        throw new UnsupportedDriverException(driverType + " is not a supported browser. Supported driver values are: " + SupportedWebDriver.listOfSupportedDrivers());
    }
}

