/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.statistics.service;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import net.thucydides.core.statistics.service.TagProvider;
import net.thucydides.core.statistics.service.TagProviderFilter;
import net.thucydides.core.statistics.service.TagProviderService;
import net.thucydides.core.statistics.service.TagProviderStrategy;

public class ClasspathTagProviderService
implements TagProviderService {
    private TagProviderFilter<TagProvider> filter = new TagProviderFilter();

    @Override
    public List<TagProvider> getTagProviders() {
        return this.getTagProviders(null);
    }

    @Override
    public List<TagProvider> getTagProviders(String testSource) {
        ArrayList newTagProviders = Lists.newArrayList();
        Iterable<? extends TagProvider> tagProviderServiceLoader = this.loadTagProvidersFromPath(testSource);
        for (TagProvider tagProvider : tagProviderServiceLoader) {
            newTagProviders.add(tagProvider);
        }
        return this.filter.removeOverriddenProviders(newTagProviders);
    }

    protected Iterable<? extends TagProvider> loadTagProvidersFromPath(String testSource) {
        ServiceLoader<TagProviderStrategy> tagProviderStrategies = ServiceLoader.load(TagProviderStrategy.class);
        Iterable<? extends TagProvider> tagProvidersWithHighPriority = this.tagProvidersWithHighPriority(tagProviderStrategies);
        if (tagProvidersWithHighPriority != null) {
            return tagProvidersWithHighPriority;
        }
        if (testSource == null) {
            return this.allKnownTagProviders(tagProviderStrategies);
        }
        return this.tagProvidersThatCanProcess(tagProviderStrategies, testSource);
    }

    private Iterable<? extends TagProvider> tagProvidersWithHighPriority(Iterable<TagProviderStrategy> tagProviderStrategies) {
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            if (!this.isHighPriority(strategy)) continue;
            return strategy.getTagProviders();
        }
        return null;
    }

    private boolean isHighPriority(TagProviderStrategy strategy) {
        try {
            return strategy.hasHighPriority();
        }
        catch (AbstractMethodError usingAnOldAPI) {
            return false;
        }
    }

    private Iterable<? extends TagProvider> tagProvidersThatCanProcess(Iterable<TagProviderStrategy> tagProviderStrategies, String testSource) {
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            if (!strategy.canHandleTestSource(testSource)) continue;
            return strategy.getTagProviders();
        }
        return Lists.newArrayList();
    }

    private Iterable<TagProvider> allKnownTagProviders(Iterable<TagProviderStrategy> tagProviderStrategies) {
        ArrayList tagProviders = Lists.newArrayList();
        for (TagProviderStrategy strategy : tagProviderStrategies) {
            tagProviders.addAll(Lists.newArrayList(strategy.getTagProviders()));
        }
        return tagProviders;
    }
}

