/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.photography.Darkroom;
import net.serenitybdd.core.photography.Photographer;
import net.serenitybdd.core.photography.ScreenshotPhoto;
import net.serenitybdd.core.photography.SoundEngineer;
import net.serenitybdd.core.photography.bluring.AnnotatedBluring;
import net.serenitybdd.core.rest.RestQuery;
import net.serenitybdd.core.time.SystemClock;
import net.serenitybdd.core.webdriver.configuration.RestartBrowserForEach;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.junit.SerenityJUnitTestCase;
import net.thucydides.core.model.DataTable;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.failures.FailureAnalysis;
import net.thucydides.core.model.screenshots.ScreenshotPermission;
import net.thucydides.core.model.stacktrace.FailureCause;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;
import net.thucydides.core.screenshots.ScreenshotException;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepFailureException;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.steps.StepPublisher;
import net.thucydides.core.steps.TestFailureCause;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.core.webdriver.WebdriverManager;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.SessionId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseStepListener
implements StepListener,
StepPublisher {
    private final List<TestOutcome> testOutcomes;
    private final Stack<TestStep> currentStepStack;
    private final Stack<TestStep> currentGroupStack;
    private StepEventBus eventBus;
    private final SystemClock clock;
    private ScreenshotPermission screenshots;
    private Class<?> testSuite;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseStepListener.class);
    private WebDriver driver;
    private File outputDirectory;
    private WebdriverProxyFactory proxyFactory;
    private Story testedStory;
    private Configuration configuration;
    private List<String> storywideIssues;
    private List<TestTag> storywideTags;
    private Darkroom darkroom;
    private Photographer photographer;
    private SoundEngineer soundEngineer = new SoundEngineer();
    private final CloseBrowser closeBrowsers;
    private boolean suiteStarted = false;
    Stack<Method> currentStepMethodStack = new Stack();
    FailureAnalysis failureAnalysis = new FailureAnalysis();
    int currentExample = 0;
    int lastFailingExample = 0;

    public void setEventBus(StepEventBus eventBus) {
        this.eventBus = eventBus;
    }

    public StepEventBus getEventBus() {
        if (this.eventBus == null) {
            this.eventBus = StepEventBus.getEventBus();
        }
        return this.eventBus;
    }

    private Darkroom getDarkroom() {
        if (this.darkroom == null) {
            this.darkroom = new Darkroom();
        }
        return this.darkroom;
    }

    public Optional<TestStep> cloneCurrentStep() {
        return this.currentStepExists() ? Optional.of((Object)this.getCurrentStep().clone()) : Optional.absent();
    }

    public void setAllStepsTo(TestResult result) {
        this.getCurrentTestOutcome().setAnnotatedResult(result);
        this.getCurrentTestOutcome().setAllStepsTo(result);
    }

    public void exceptionExpected(Class<? extends Throwable> expected) {
        if (this.getCurrentTestOutcome().getTestFailureCause() != null && this.getCurrentTestOutcome().getTestFailureCause().getErrorType().equals(expected.getName())) {
            this.getCurrentTestOutcome().resetFailingStepsCausedBy(expected);
        }
    }

    public StepMerger mergeLast(int maxStepsToMerge) {
        return new StepMerger(maxStepsToMerge);
    }

    public int getStepCount() {
        return this.getCurrentTestOutcome().getStepCount();
    }

    public int getRunningStepCount() {
        return this.getCurrentTestOutcome().getRunningStepCount();
    }

    public void updateOverallResults() {
        this.getCurrentTestOutcome().updateOverallResults();
    }

    public Photographer getPhotographer() {
        if (this.photographer == null) {
            this.photographer = new Photographer(this.getDarkroom());
        }
        return this.photographer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPreviousTest() {
        List<TestOutcome> list = this.testOutcomes;
        synchronized (list) {
            if (!this.testOutcomes.isEmpty()) {
                this.testOutcomes.remove(this.testOutcomes.size() - 1);
            }
        }
    }

    public void lastTestPassedAfterRetries(int remainingTries, List<String> failureMessages, TestFailureCause testfailureCause) {
        if (this.latestTestOutcome().isPresent()) {
            ((TestOutcome)this.latestTestOutcome().get()).recordStep(TestStep.forStepCalled("UNSTABLE TEST:\n" + this.failureHistoryFor(failureMessages)).withResult(TestResult.IGNORED));
            ((TestOutcome)this.latestTestOutcome().get()).addTag(TestTag.withName("Retries: " + (remainingTries - 1)).andType("unstable test"));
            ((TestOutcome)this.latestTestOutcome().get()).setFlakyTestFailureCause(testfailureCause);
        }
    }

    private String failureHistoryFor(List<String> failureMessages) {
        List bulletPoints = Lambda.convert(failureMessages, (Converter)new Converter<String, String>(){

            public String convert(String from) {
                return "* " + from;
            }
        });
        return Joiner.on((String)"\n").join((Iterable)bulletPoints);
    }

    public void currentStepIsAPrecondition() {
        this.getCurrentStep().setPrecondition(true);
    }

    public BaseStepListener(File outputDirectory) {
        this(outputDirectory, Injectors.getInjector());
    }

    public BaseStepListener(File outputDirectory, Injector injector) {
        this.proxyFactory = WebdriverProxyFactory.getFactory();
        this.testOutcomes = Lists.newArrayList();
        this.currentStepStack = new Stack();
        this.currentGroupStack = new Stack();
        this.outputDirectory = outputDirectory;
        this.storywideIssues = Lists.newArrayList();
        this.storywideTags = Lists.newArrayList();
        this.clock = (SystemClock)injector.getInstance(SystemClock.class);
        this.configuration = (Configuration)injector.getInstance(Configuration.class);
        this.closeBrowsers = (CloseBrowser)Injectors.getInjector().getInstance(CloseBrowser.class);
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory) {
        this(outputDirectory);
        this.driver = this.getProxyFactory().proxyFor(driverClass);
    }

    public BaseStepListener(Class<? extends WebDriver> driverClass, File outputDirectory, Configuration configuration) {
        this(driverClass, outputDirectory);
        this.configuration = configuration;
    }

    public BaseStepListener(File outputDirectory, WebdriverManager webdriverManager) {
        this(outputDirectory);
    }

    public BaseStepListener(File outputDirectory, Pages pages) {
        this(outputDirectory);
        if (pages != null) {
            this.setDriverUsingPagesDriverIfDefined(pages);
        } else {
            this.createNewDriver();
        }
    }

    protected ScreenshotPermission screenshots() {
        if (this.screenshots == null) {
            this.screenshots = new ScreenshotPermission(this.configuration);
        }
        return this.screenshots;
    }

    private void createNewDriver() {
        this.setDriver(this.getProxyFactory().proxyDriver());
    }

    private void setDriverUsingPagesDriverIfDefined(Pages pages) {
        if (pages.getDriver() == null) {
            ThucydidesWebDriverSupport.initialize();
            ThucydidesWebDriverSupport.useDriver(this.getDriver());
            pages.setDriver(this.getDriver());
        }
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    protected TestOutcome getCurrentTestOutcome() {
        return (TestOutcome)this.latestTestOutcome().get();
    }

    protected Optional<TestOutcome> latestTestOutcome() {
        if (this.testOutcomes.isEmpty()) {
            return Optional.absent();
        }
        TestOutcome latestOutcome = this.testOutcomes.get(this.testOutcomes.size() - 1);
        return Optional.of((Object)latestOutcome);
    }

    protected SystemClock getClock() {
        return this.clock;
    }

    @Override
    public void testSuiteStarted(Class<?> startedTestSuite) {
        this.testSuite = startedTestSuite;
        this.testedStory = Stories.findStoryFrom(startedTestSuite);
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    private void clearStorywideTagsAndIssues() {
        this.storywideIssues.clear();
        this.storywideTags.clear();
    }

    @Override
    public void testSuiteStarted(Story story) {
        this.testSuite = null;
        this.testedStory = story;
        this.suiteStarted = true;
        this.clearStorywideTagsAndIssues();
    }

    public boolean testSuiteRunning() {
        return this.suiteStarted;
    }

    public void addIssuesToCurrentStory(List<String> issues) {
        this.storywideIssues.addAll(issues);
    }

    public void addTagsToCurrentStory(List<TestTag> tags) {
        this.storywideTags.addAll(tags);
    }

    private void closeDarkroom() {
        if (this.darkroom != null) {
            this.darkroom.waitUntilClose();
        }
    }

    @Override
    public void testSuiteFinished() {
        this.closeDarkroom();
        this.clearStorywideTagsAndIssues();
        this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.STORY);
        this.suiteStarted = false;
    }

    @Override
    public void testStarted(String testMethod) {
        TestOutcome newTestOutcome = TestOutcome.forTestInStory(testMethod, this.testSuite, this.testedStory);
        this.recordNewTestOutcome(testMethod, newTestOutcome);
    }

    @Override
    public void testStarted(String testMethod, String id) {
        TestOutcome newTestOutcome = TestOutcome.forTestInStory(testMethod, this.testSuite, this.testedStory).withId(id);
        this.recordNewTestOutcome(testMethod, newTestOutcome);
    }

    private void recordNewTestOutcome(String testMethod, TestOutcome newTestOutcome) {
        newTestOutcome.setTestSource(StepEventBus.getEventBus().getTestSource());
        this.testOutcomes.add(newTestOutcome);
        this.setAnnotatedResult(testMethod);
    }

    private void updateSessionIdIfKnown() {
        SessionId sessionId = ThucydidesWebDriverSupport.getSessionId();
        if (sessionId != null) {
            this.getCurrentTestOutcome().setSessionId(sessionId.toString());
        }
    }

    public StepMutator updateCurrentStepTitle(String updatedStepTitle) {
        if (this.currentStepExists()) {
            this.getCurrentStep().setDescription(updatedStepTitle);
        } else {
            this.stepStarted(ExecutedStepDescription.withTitle(updatedStepTitle));
        }
        return new StepMutator(this);
    }

    private void setAnnotatedResult(String testMethod) {
        if (TestAnnotations.forClass(this.testSuite).isIgnored(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
        }
        if (TestAnnotations.forClass(this.testSuite).isPending(testMethod)) {
            this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        }
    }

    @Override
    public void testFinished(TestOutcome outcome) {
        this.recordTestDuration();
        this.getCurrentTestOutcome().addIssues(this.storywideIssues);
        this.getCurrentTestOutcome().addTags(this.storywideTags);
        if (StepEventBus.getEventBus().isDryRun() || this.getCurrentTestOutcome().getResult() == TestResult.IGNORED) {
            this.testAndTopLevelStepsShouldBeIgnored();
        }
        if (this.currentTestIsABrowserTest()) {
            this.getCurrentTestOutcome().setDriver(this.getDriverUsedInThisTest());
            this.updateSessionIdIfKnown();
            this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.SCENARIO);
        }
        this.currentStepStack.clear();
    }

    private void testAndTopLevelStepsShouldBeIgnored() {
        this.getCurrentTestOutcome().setResult(TestResult.IGNORED);
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateTopLevelStepResultsTo(TestResult.IGNORED);
        }
    }

    private String getDriverUsedInThisTest() {
        return ThucydidesWebDriverSupport.getDriversUsed();
    }

    private boolean currentTestIsABrowserTest() {
        return SerenityJUnitTestCase.inClass(this.testSuite).isAWebTest() || this.testSuite == null && ThucydidesWebDriverSupport.isDriverInstantiated();
    }

    @Override
    public void testRetried() {
        this.currentStepStack.clear();
        this.testOutcomes.remove(this.getCurrentTestOutcome());
    }

    private void recordTestDuration() {
        if (!this.testOutcomes.isEmpty()) {
            this.getCurrentTestOutcome().recordDuration();
        }
    }

    @Override
    public void stepStarted(ExecutedStepDescription description) {
        this.pushStepMethodIn(description);
        this.recordStep(description);
        if (this.currentTestIsABrowserTest()) {
            this.takeInitialScreenshot();
        }
    }

    private void pushStepMethodIn(ExecutedStepDescription description) {
        if (description.isAQuestion()) {
            this.currentStepMethodStack.push(this.tokenQuestionMethod());
        } else {
            this.currentStepMethodStack.push(description.getStepMethod());
        }
    }

    private Method tokenQuestionMethod() {
        try {
            return Question.class.getMethod("ask", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @Override
    public void skippedStepStarted(ExecutedStepDescription description) {
        this.recordStep(description);
    }

    public Optional<Method> getCurrentStepMethod() {
        return this.currentStepMethodStack.empty() ? Optional.absent() : Optional.fromNullable((Object)this.currentStepMethodStack.peek());
    }

    private void recordStep(ExecutedStepDescription description) {
        if (!this.latestTestOutcome().isPresent()) {
            return;
        }
        TestStep step = new TestStep(AnnotatedStepDescription.from(description).getName());
        this.startNewGroupIfNested();
        this.setDefaultResultFromAnnotations(step, description);
        this.currentStepStack.push(step);
        this.recordStepToCurrentTestOutcome(step);
    }

    private void recordStepToCurrentTestOutcome(TestStep step) {
        this.getCurrentTestOutcome().recordStep(step);
    }

    private void setDefaultResultFromAnnotations(TestStep step, ExecutedStepDescription description) {
        if (TestAnnotations.isPending(description.getStepMethod())) {
            step.setResult(TestResult.PENDING);
        }
        if (TestAnnotations.isIgnored(description.getStepMethod())) {
            step.setResult(TestResult.IGNORED);
        }
    }

    private void startNewGroupIfNested() {
        if (this.thereAreUnfinishedSteps() && this.getCurrentStep() != this.getCurrentGroup()) {
            this.startNewGroup();
        }
    }

    private void startNewGroup() {
        this.getCurrentTestOutcome().startGroup();
        this.currentGroupStack.push(this.getCurrentStep());
    }

    private TestStep getCurrentStep() {
        return this.currentStepStack.peek();
    }

    private Optional<TestStep> getPreviousStep() {
        if (this.getCurrentTestOutcome().getTestSteps().size() > 1) {
            List<TestStep> currentTestSteps = this.getCurrentTestOutcome().getTestSteps();
            return Optional.of((Object)currentTestSteps.get(currentTestSteps.size() - 2));
        }
        return Optional.absent();
    }

    private TestStep getCurrentGroup() {
        if (this.currentGroupStack.isEmpty()) {
            return null;
        }
        return this.currentGroupStack.peek();
    }

    private boolean thereAreUnfinishedSteps() {
        return !this.currentStepStack.isEmpty();
    }

    @Override
    public void stepFinished() {
        this.takeEndOfStepScreenshotFor(TestResult.SUCCESS);
        this.currentStepDone(TestResult.SUCCESS);
        this.pauseIfRequired();
    }

    private void updateExampleTableIfNecessary(TestResult result) {
        if (this.getCurrentTestOutcome().isDataDriven()) {
            this.getCurrentTestOutcome().updateCurrentRowResult(result);
        }
    }

    private void finishGroup() {
        this.currentGroupStack.pop();
        this.getCurrentTestOutcome().endGroup();
    }

    private void pauseIfRequired() {
        int delay = this.configuration.getStepDelay();
        if (delay > 0) {
            this.getClock().pauseFor(delay);
        }
    }

    private void markCurrentStepAs(TestResult result) {
        this.getCurrentTestOutcome().currentStep().setResult(result);
        this.updateExampleTableIfNecessary(result);
    }

    @Override
    public void stepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        TestFailureCause failureCause = TestFailureCause.from(failure.getException());
        this.getCurrentTestOutcome().appendTestFailure(failureCause);
        this.recordFailureDetails(failure);
        this.currentStepDone(this.failureAnalysis.resultFor(failure));
    }

    @Override
    public void lastStepFailed(StepFailure failure) {
        this.takeEndOfStepScreenshotFor(TestResult.FAILURE);
        this.getCurrentTestOutcome().lastStepFailedWith(failure);
        this.lastFailingExample = this.currentExample;
    }

    private void recordFailureDetails(StepFailure failure) {
        if (this.currentStepExists()) {
            this.getCurrentStep().failedWith(new StepFailureException(failure.getMessage(), failure.getException()));
        }
        if (this.shouldTagErrors()) {
            this.addTagFor(this.getCurrentTestOutcome());
        }
        this.lastFailingExample = this.currentExample;
    }

    private void addTagFor(TestOutcome testOutcome) {
        testOutcome.addTag(TestTag.withName(testOutcome.getTestFailureCause().getSimpleErrorType()).andType("error type"));
    }

    private boolean shouldTagErrors() {
        return ThucydidesSystemProperty.SERENITY_TAG_FAILURES.booleanFrom(this.configuration.getEnvironmentVariables());
    }

    @Override
    public void stepIgnored() {
        if (this.aStepHasFailed()) {
            this.markCurrentStepAs(TestResult.SKIPPED);
            this.currentStepDone(TestResult.SKIPPED);
        } else {
            this.currentStepDone(TestResult.IGNORED);
        }
    }

    @Override
    public void stepPending() {
        this.currentStepDone(TestResult.PENDING);
    }

    @Override
    public void stepPending(String message) {
        this.getCurrentStep().testAborted(new PendingStepException(message));
        this.stepPending();
    }

    @Override
    public void assumptionViolated(String message) {
        if (this.thereAreUnfinishedSteps()) {
            this.getCurrentStep().testAborted(new PendingStepException(message));
            this.stepIgnored();
        }
        this.testIgnored();
    }

    @Override
    public void testRunFinished() {
        this.closeDarkroom();
    }

    private void currentStepDone(TestResult result) {
        if (!this.currentStepMethodStack.isEmpty()) {
            this.currentStepMethodStack.pop();
        }
        if (this.currentStepExists()) {
            TestStep finishedStep = this.currentStepStack.pop();
            finishedStep.recordDuration();
            if (result != null) {
                finishedStep.setResult(result);
            }
            if (finishedStep == this.getCurrentGroup()) {
                this.finishGroup();
            }
        }
        this.updateExampleTableIfNecessary(result);
    }

    private boolean currentStepExists() {
        return !this.currentStepStack.isEmpty();
    }

    private void takeEndOfStepScreenshotFor(TestResult result) {
        if (this.currentTestIsABrowserTest() && this.shouldTakeEndOfStepScreenshotFor(result)) {
            this.take(ScreenshotType.MANDATORY_SCREENSHOT, result);
        }
    }

    public Optional<TestResult> getForcedResult() {
        return Optional.fromNullable((Object)((Object)this.getCurrentTestOutcome().getAnnotatedResult()));
    }

    public void clearForcedResult() {
        this.getCurrentTestOutcome().clearForcedResult();
    }

    private void take(ScreenshotType screenshotType) {
        this.take(screenshotType, TestResult.UNDEFINED);
    }

    private void take(ScreenshotType screenshotType, TestResult result) {
        if (this.shouldTakeScreenshots()) {
            try {
                Optional<ScreenshotAndHtmlSource> screenshotAndHtmlSource = this.grabScreenshot(result);
                if (screenshotAndHtmlSource.isPresent()) {
                    this.recordScreenshotIfRequired(screenshotType, (ScreenshotAndHtmlSource)screenshotAndHtmlSource.get());
                }
                this.removeDuplicatedInitalScreenshotsIfPresent();
            }
            catch (ScreenshotException e) {
                LOGGER.warn("Failed to take screenshot", (Throwable)e);
            }
        }
    }

    private boolean shouldTakeScreenshots() {
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed() && !StepEventBus.getEventBus().softAssertsActive()) {
            return false;
        }
        return this.currentStepExists() && this.browserIsOpen() && !StepEventBus.getEventBus().isDryRun() && !StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private void removeDuplicatedInitalScreenshotsIfPresent() {
        if (this.currentStepHasMoreThanOneScreenshot() && this.getPreviousStep().isPresent() && ((TestStep)this.getPreviousStep().get()).hasScreenshots()) {
            ScreenshotAndHtmlSource lastScreenshotOfPreviousStep = this.lastScreenshotOf((TestStep)this.getPreviousStep().get());
            ScreenshotAndHtmlSource firstScreenshotOfThisStep = this.getCurrentStep().getFirstScreenshot();
            if (firstScreenshotOfThisStep.hasIdenticalScreenshotsAs(lastScreenshotOfPreviousStep)) {
                this.removeFirstScreenshotOfCurrentStep();
            }
        }
    }

    private void removeFirstScreenshotOfCurrentStep() {
        this.getCurrentStep().removeScreenshot(0);
    }

    private boolean currentStepHasMoreThanOneScreenshot() {
        return this.getCurrentStep().getScreenshotCount() > 1;
    }

    private ScreenshotAndHtmlSource lastScreenshotOf(TestStep testStep) {
        return testStep.getScreenshots().get(testStep.getScreenshots().size() - 1);
    }

    private void recordScreenshotIfRequired(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        if (this.shouldTakeScreenshot(screenshotType, screenshotAndHtmlSource) && this.screenshotWasTaken(screenshotAndHtmlSource)) {
            this.getCurrentStep().addScreenshot(screenshotAndHtmlSource);
        }
    }

    private boolean screenshotWasTaken(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.getScreenshot() != null;
    }

    private boolean shouldTakeScreenshot(ScreenshotType screenshotType, ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotType == ScreenshotType.MANDATORY_SCREENSHOT || this.getCurrentStep().getScreenshots().isEmpty() || this.shouldTakeOptionalScreenshot(screenshotAndHtmlSource);
    }

    private boolean shouldTakeOptionalScreenshot(ScreenshotAndHtmlSource screenshotAndHtmlSource) {
        return screenshotAndHtmlSource.wasTaken() && this.previousScreenshot().isPresent() && !screenshotAndHtmlSource.hasIdenticalScreenshotsAs((ScreenshotAndHtmlSource)this.previousScreenshot().get());
    }

    private Optional<ScreenshotAndHtmlSource> previousScreenshot() {
        List<ScreenshotAndHtmlSource> screenshotsToDate = this.getCurrentTestOutcome().getScreenshotAndHtmlSources();
        if (screenshotsToDate.isEmpty()) {
            return Optional.absent();
        }
        return Optional.of((Object)screenshotsToDate.get(screenshotsToDate.size() - 1));
    }

    private boolean browserIsOpen() {
        return ThucydidesWebDriverSupport.isDriverInstantiated();
    }

    private void takeInitialScreenshot() {
        if (this.currentStepExists() && this.screenshots().areAllowed(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    private Optional<ScreenshotAndHtmlSource> grabScreenshot(TestResult result) {
        ScreenshotPhoto newPhoto = ScreenshotPhoto.None;
        Optional<File> pageSource = Optional.absent();
        if (this.pathOf(this.outputDirectory) != null) {
            newPhoto = this.getPhotographer().takesAScreenshot().with(this.getDriver()).andWithBlurring(AnnotatedBluring.blurLevel()).andSaveToDirectory(this.pathOf(this.outputDirectory));
            pageSource = this.soundEngineer.ifRequiredForResult(result).recordPageSourceUsing(this.getDriver()).intoDirectory(this.pathOf(this.outputDirectory));
        }
        return newPhoto == ScreenshotPhoto.None ? Optional.absent() : Optional.of((Object)new ScreenshotAndHtmlSource(newPhoto.getPathToScreenshot().toFile(), (File)pageSource.orNull()));
    }

    private Path pathOf(File directory) {
        return directory == null ? null : directory.toPath();
    }

    private boolean shouldTakeEndOfStepScreenshotFor(TestResult result) {
        if (result == TestResult.FAILURE) {
            return this.screenshots().areAllowed(TakeScreenshots.FOR_FAILURES);
        }
        return this.screenshots().areAllowed(TakeScreenshots.AFTER_EACH_STEP);
    }

    @Override
    public List<TestOutcome> getTestOutcomes() {
        ArrayList sortedOutcomes = Lists.newArrayList(this.testOutcomes);
        Collections.sort(sortedOutcomes, this.byStartTimeAndName());
        return ImmutableList.copyOf((Collection)sortedOutcomes);
    }

    private Comparator<? super TestOutcome> byStartTimeAndName() {
        return new Comparator<TestOutcome>(){

            @Override
            public int compare(TestOutcome testOutcome1, TestOutcome testOutcome2) {
                String creationTimeAndName1 = testOutcome1.getStartTime().getMillis() + "_" + testOutcome1.getName();
                String creationTimeAndName2 = testOutcome2.getStartTime().getMillis() + "_" + testOutcome2.getName();
                return creationTimeAndName1.compareTo(creationTimeAndName2);
            }
        };
    }

    @Override
    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WebDriver getDriver() {
        return ThucydidesWebDriverSupport.getDriver();
    }

    @Override
    public boolean aStepHasFailed() {
        return !this.getTestOutcomes().isEmpty() && (this.getCurrentTestOutcome().getResult() == TestResult.FAILURE || this.getCurrentTestOutcome().getResult() == TestResult.ERROR || this.getCurrentTestOutcome().getResult() == TestResult.COMPROMISED);
    }

    public boolean aStepHasFailedInTheCurrentExample() {
        if (this.currentExample == 0) {
            return this.aStepHasFailed();
        }
        return this.aStepHasFailed() && this.currentExample == this.lastFailingExample;
    }

    @Override
    public FailureCause getTestFailureCause() {
        return this.getCurrentTestOutcome().getTestFailureCause();
    }

    @Override
    public void testFailed(TestOutcome testOutcome, Throwable cause) {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().determineTestFailureCause(cause);
    }

    @Override
    public void testIgnored() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.IGNORED);
    }

    @Override
    public void testSkipped() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.SKIPPED);
    }

    @Override
    public void testPending() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().setAnnotatedResult(TestResult.PENDING);
        this.updateExampleTableIfNecessary(TestResult.PENDING);
    }

    private boolean testOutcomeRecorded() {
        return !this.testOutcomes.isEmpty();
    }

    @Override
    public void testIsManual() {
        if (!this.testOutcomeRecorded()) {
            return;
        }
        this.getCurrentTestOutcome().asManualTest();
        this.getCurrentTestOutcome().setAnnotatedResult(this.defaulManualTestReportResult());
    }

    private TestResult defaulManualTestReportResult() {
        String manualTestResultValue = ThucydidesSystemProperty.MANUAL_TEST_REPORT_RESULT.from(this.configuration.getEnvironmentVariables(), TestResult.PENDING.toString());
        TestResult manualTestResult = TestResult.PENDING;
        try {
            manualTestResult = TestResult.valueOf(manualTestResultValue.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Badly configured value for manual.test.report.result: should be one of " + Arrays.toString((Object[])TestResult.values()));
        }
        return manualTestResult;
    }

    @Override
    public void notifyScreenChange() {
        if (this.currentTestIsABrowserTest() && this.screenshots().areAllowed(TakeScreenshots.FOR_EACH_ACTION)) {
            this.take(ScreenshotType.OPTIONAL_SCREENSHOT);
        }
    }

    public void takeScreenshot() {
        this.take(ScreenshotType.MANDATORY_SCREENSHOT);
    }

    @Override
    public void useExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().useExamplesFrom(table);
        this.currentExample = 0;
        this.lastFailingExample = 0;
    }

    @Override
    public void addNewExamplesFrom(DataTable table) {
        this.getCurrentTestOutcome().addNewExamplesFrom(table);
    }

    @Override
    public void exampleStarted(Map<String, String> data) {
        this.clearForcedResult();
        if (this.getCurrentTestOutcome().isDataDriven() && !this.getCurrentTestOutcome().dataIsPredefined()) {
            this.getCurrentTestOutcome().addRow(data);
        }
        ++this.currentExample;
        if (this.newStepForEachExample()) {
            this.getEventBus().stepStarted(ExecutedStepDescription.withTitle(this.exampleTitle(this.currentExample, data)));
        }
    }

    private String exampleTitle(int exampleNumber, Map<String, String> data) {
        return String.format("%s #%s: %s", this.getCurrentTestOutcome().getTitle(), exampleNumber, data);
    }

    @Override
    public void exampleFinished() {
        if (this.newStepForEachExample()) {
            this.currentStepDone(null);
        }
        if (this.latestTestOutcome().isPresent()) {
            ((TestOutcome)this.latestTestOutcome().get()).moveToNextRow();
        }
        this.closeBrowsers.forTestSuite(this.testSuite).closeIfConfiguredForANew(RestartBrowserForEach.EXAMPLE);
    }

    private boolean newStepForEachExample() {
        if (!this.latestTestOutcome().isPresent()) {
            return false;
        }
        return this.getCurrentTestOutcome().getTestSource() != null && !this.getCurrentTestOutcome().getTestSource().equalsIgnoreCase("junit");
    }

    public void recordRestQuery(RestQuery restQuery) {
        this.stepStarted(ExecutedStepDescription.withTitle(restQuery.toString()));
        this.addRestQuery(restQuery);
        this.stepFinished();
    }

    public void addRestQuery(RestQuery restQuery) {
        this.getCurrentStep().recordRestQuery(restQuery);
    }

    static class Question {
        Question() {
        }

        public void ask() {
        }
    }

    public class StepMutator {
        private final BaseStepListener baseStepListener;

        public StepMutator(BaseStepListener baseStepListener) {
            this.baseStepListener = baseStepListener;
        }

        public void asAPrecondition() {
            this.baseStepListener.getCurrentStep().setPrecondition(true);
        }
    }

    protected static enum ScreenshotType {
        OPTIONAL_SCREENSHOT,
        MANDATORY_SCREENSHOT;

    }

    public class StepMerger {
        final int maxStepsToMerge;

        public StepMerger(int maxStepsToMerge) {
            this.maxStepsToMerge = maxStepsToMerge;
        }

        public void steps() {
            BaseStepListener.this.getCurrentTestOutcome().mergeMostRecentSteps(this.maxStepsToMerge);
        }
    }
}

