/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.io.IOException;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.servicepools.DriverServicePool;
import net.serenitybdd.core.webdriver.servicepools.GeckoServicePool;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirefoxDriverProvider
implements DriverProvider {
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private final DriverCapabilityRecord driverProperties;
    private static final Logger LOGGER = LoggerFactory.getLogger(FirefoxDriverProvider.class);
    private final DriverServicePool driverServicePool = new GeckoServicePool();

    private DriverServicePool getDriverServicePool() throws IOException {
        this.driverServicePool.ensureServiceIsRunning();
        return this.driverServicePool;
    }

    protected String serviceName() {
        return "firefox";
    }

    public FirefoxDriverProvider(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
        this.driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance() {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        DesiredCapabilities capabilities = new FirefoxDriverCapabilities(this.environmentVariables).getCapabilities();
        WebDriver driver = this.shouldUseGeckoDriver() ? this.newMarionetteDriver(capabilities) : this.newFirefoxDriver(capabilities);
        this.driverProperties.registerCapabilities("firefox", (Capabilities)capabilities);
        return driver;
    }

    private boolean shouldUseGeckoDriver() {
        return (this.geckoDriverIsInEnvironmentVariable() || this.geckoDriverIsOnTheClasspath()) && this.geckoIsNotDisabled();
    }

    private boolean geckoIsNotDisabled() {
        return ThucydidesSystemProperty.USE_GECKO_DRIVER.booleanFrom(this.environmentVariables, true);
    }

    private WebDriver newFirefoxDriver(DesiredCapabilities capabilities) {
        return new FirefoxDriver((Capabilities)this.enhancer.enhanced(capabilities));
    }

    private WebDriver newMarionetteDriver(DesiredCapabilities capabilities) {
        capabilities.setCapability("marionette", true);
        try {
            return this.getDriverServicePool().newDriver((Capabilities)this.enhancer.enhanced(capabilities));
        }
        catch (IOException couldNotStartGeckoDriverService) {
            LOGGER.warn("Failed to start the gecko driver service, using a native driver instead", (Object)couldNotStartGeckoDriverService.getMessage());
            return this.newFirefoxDriver(capabilities);
        }
    }

    private boolean geckoDriverIsOnTheClasspath() {
        try {
            Runtime.getRuntime().exec("geckodriver --help");
            return true;
        }
        catch (Exception geckodriverBinaryNotFound) {
            try {
                Runtime.getRuntime().exec("wires --help");
                return true;
            }
            catch (Exception wiresBinaryNotFound) {
                return false;
            }
        }
    }

    private boolean geckoDriverIsInEnvironmentVariable() {
        try {
            new ProcessBuilder(new String[0]).command(ThucydidesSystemProperty.WEBDRIVER_GECKO_DRIVER.from(this.environmentVariables), "--help").start();
            return true;
        }
        catch (Exception geckodriverBinaryNotFound) {
            return false;
        }
    }
}

