/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Optional;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberOfThreads {
    private static final Logger LOGGER = LoggerFactory.getLogger(NumberOfThreads.class);
    static final double BLOCKING_COEFFICIENT_FOR_IO = 0.9;
    private static final EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);

    public static int forIOOperations() {
        int numberOfCores = Runtime.getRuntime().availableProcessors();
        int reportThreads = (Integer)NumberOfThreads.configuredReportThreads().or((Object)((int)((double)numberOfCores / 0.09999999999999998)));
        LOGGER.info("Configured report threads: {}", (Object)reportThreads);
        return reportThreads;
    }

    private static Optional<Integer> configuredReportThreads() {
        return Optional.fromNullable((Object)environmentVariables.getPropertyAsInteger("report.threads", null));
    }
}

