/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import ch.lambdaj.function.convert.DefaultStringConverter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.PropertiesFileLocalPreferences;
import org.apache.commons.lang3.StringUtils;

public class SystemEnvironmentVariables
implements EnvironmentVariables {
    private Map<String, String> properties;
    private Map<String, String> systemValues;
    private final Lock propertySetLock = new ReentrantLock();

    public SystemEnvironmentVariables() {
        this(System.getProperties(), System.getenv());
    }

    SystemEnvironmentVariables(Properties systemProperties, Map<String, String> systemValues) {
        HashMap<String, String> propertyValues = new HashMap<String, String>();
        for (String property : systemProperties.stringPropertyNames()) {
            propertyValues.put(property, systemProperties.getProperty(property));
        }
        this.properties = ImmutableMap.copyOf(propertyValues);
        this.systemValues = ImmutableMap.copyOf(systemValues);
    }

    @Override
    public String getValue(String name) {
        return this.getValue(name, null);
    }

    @Override
    public String getValue(Enum<?> property) {
        return this.getValue(property.toString());
    }

    @Override
    public String getValue(String name, String defaultValue) {
        String value = this.systemValues.get(name);
        return value == null ? defaultValue : value;
    }

    @Override
    public String getValue(Enum<?> property, String defaultValue) {
        return this.getValue(property.toString(), defaultValue);
    }

    @Override
    public List<String> getKeys() {
        return Lambda.convert(this.properties.keySet(), (Converter)this.toStrings());
    }

    private DefaultStringConverter toStrings() {
        return new DefaultStringConverter();
    }

    @Override
    public Properties getProperties() {
        Properties props = new Properties();
        for (String key : this.properties.keySet()) {
            props.setProperty(key, this.properties.get(key));
        }
        return props;
    }

    @Override
    public Properties getPropertiesWithPrefix(String prefix) {
        Properties filteredProperties = new Properties();
        for (String key : this.properties.keySet()) {
            if (!key.startsWith(prefix)) continue;
            filteredProperties.put(key, this.properties.get(key));
        }
        return filteredProperties;
    }

    @Override
    public boolean aValueIsDefinedFor(Enum<?> property) {
        return this.aValueIsDefinedFor(property.toString());
    }

    @Override
    public boolean aValueIsDefinedFor(String property) {
        return this.properties.containsKey(property);
    }

    @Override
    public Integer getPropertyAsInteger(String property, Integer defaultValue) {
        String value = this.properties.get(property);
        return value != null ? Integer.valueOf(value) : defaultValue;
    }

    @Override
    public Integer getPropertyAsInteger(Enum<?> property, Integer defaultValue) {
        return this.getPropertyAsInteger(property.toString(), defaultValue);
    }

    @Override
    public Boolean getPropertyAsBoolean(String name, boolean defaultValue) {
        if (this.getProperty(name) == null) {
            return defaultValue;
        }
        if (StringUtils.isBlank((CharSequence)this.getProperty(name))) {
            return true;
        }
        return Boolean.parseBoolean(this.getProperty(name, "false"));
    }

    @Override
    public Boolean getPropertyAsBoolean(Enum<?> property, boolean defaultValue) {
        return this.getPropertyAsBoolean(property.toString(), defaultValue);
    }

    @Override
    public String getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public String getProperty(Enum<?> property) {
        return this.getProperty(property.toString());
    }

    @Override
    public String getProperty(String name, String defaultValue) {
        String value = this.properties.get(name);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getProperty(Enum<?> property, String defaultValue) {
        return this.getProperty(property.toString(), defaultValue);
    }

    @Override
    public void setProperty(String name, String value) {
        this.propertySetLock.lock();
        HashMap workingCopy = Maps.newHashMap(this.properties);
        workingCopy.put(name, value);
        this.properties = ImmutableMap.copyOf((Map)workingCopy);
        this.propertySetLock.unlock();
    }

    @Override
    public void clearProperty(String name) {
        this.propertySetLock.lock();
        HashMap workingCopy = Maps.newHashMap(this.properties);
        workingCopy.remove(name);
        this.properties = ImmutableMap.copyOf((Map)workingCopy);
        this.propertySetLock.unlock();
    }

    @Override
    public EnvironmentVariables copy() {
        return new SystemEnvironmentVariables(this.getProperties(), this.systemValues);
    }

    public static EnvironmentVariables createEnvironmentVariables() {
        SystemEnvironmentVariables environmentVariables = new SystemEnvironmentVariables();
        PropertiesFileLocalPreferences localPreferences = new PropertiesFileLocalPreferences(environmentVariables);
        try {
            localPreferences.loadPreferences();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return environmentVariables;
    }
}

