/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import net.thucydides.core.annotations.Narrative;
import net.thucydides.core.requirements.annotations.NarrativeFinder;
import org.apache.commons.lang3.StringUtils;

public abstract class PackageInfoNarrative {
    public abstract Optional<String> definedInPath(String var1);

    protected Optional<Narrative> getClassLevelNarrativeFor(String path) {
        try {
            String packageInfoPath = path.endsWith("package-info") ? path : path + ".package-info";
            return NarrativeFinder.forClass(this.getClass().getClassLoader().loadClass(packageInfoPath));
        }
        catch (ClassNotFoundException e) {
            return Optional.absent();
        }
    }

    public static PackageInfoNarrative text() {
        return new TextPackageInfoNarrative();
    }

    public static TypePackageInfoNarrative type() {
        return new TypePackageInfoNarrative();
    }

    public static class TypePackageInfoNarrative
    extends PackageInfoNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (narrative.isPresent() && !StringUtils.isEmpty((CharSequence)((Narrative)narrative.get()).type())) {
                return Optional.of((Object)((Narrative)narrative.get()).type());
            }
            return Optional.absent();
        }
    }

    public static class TextPackageInfoNarrative
    extends PackageInfoNarrative {
        @Override
        public Optional<String> definedInPath(String path) {
            Optional<Narrative> narrative = this.getClassLevelNarrativeFor(path);
            if (!narrative.isPresent()) {
                return Optional.absent();
            }
            String narrativeText = Joiner.on((String)"\n").join((Object[])((Narrative)narrative.get()).text());
            return Optional.of((Object)(((Narrative)narrative.get()).title() + System.lineSeparator() + narrativeText).trim());
        }
    }
}

