/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.lang.reflect.Method;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.NameConverter;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class BrowserStackRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public BrowserStackRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserStackCapabilities(capabilities);
        return capabilities;
    }

    private void configureBrowserStackCapabilities(DesiredCapabilities capabilities) {
        capabilities.setCapability("name", this.bestGuessOfTestName());
        AddCustomCapabilities.startingWith("browserstack.").from(this.environmentVariables).to(capabilities);
        String remotePlatform = this.environmentVariables.getProperty("remote.platform");
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform)) {
            capabilities.setPlatform(Platform.valueOf((String)remotePlatform));
        }
    }

    private String bestGuessOfTestName() {
        for (StackTraceElement elt : Thread.currentThread().getStackTrace()) {
            try {
                Class<?> callingClass = Class.forName(elt.getClassName());
                Method callingMethod = callingClass.getMethod(elt.getMethodName(), new Class[0]);
                if (this.isATestMethod(callingMethod)) {
                    return NameConverter.humanize(elt.getMethodName());
                }
                if (!this.isASetupMethod(callingMethod)) continue;
                return NameConverter.humanize(callingClass.getSimpleName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean isATestMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Test.class) != null;
    }

    private boolean isASetupMethod(Method callingMethod) {
        return callingMethod.getAnnotation(Before.class) != null || callingMethod.getAnnotation(BeforeClass.class) != null;
    }
}

