/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.buildinfo.BuildInfoProvider;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;
import org.joda.time.DateTime;

public class FreemarkerContext {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirements;
    private final IssueTracking issueTracking;
    private final String relativeLink;
    private final BuildProperties buildProperties;
    private final TestTag parentTag;

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink, TestTag parentTag) {
        this.environmentVariables = environmentVariables;
        this.requirements = requirements;
        this.issueTracking = issueTracking;
        this.relativeLink = relativeLink;
        this.buildProperties = new BuildInfoProvider(environmentVariables).getBuildProperties();
        this.parentTag = parentTag;
    }

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink) {
        this(environmentVariables, requirements, issueTracking, relativeLink, TestTag.EMPTY_TAG);
    }

    public Map<String, Object> getBuildContext(TestOutcomes testOutcomesForTagType, ReportNameProvider reportName, boolean useFiltering) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        TagFilter tagFilter = new TagFilter(this.environmentVariables);
        context.put("testOutcomes", testOutcomesForTagType);
        context.put("allTestOutcomes", testOutcomesForTagType.getRootOutcomes());
        if (useFiltering) {
            context.put("tagTypes", tagFilter.filteredTagTypes(testOutcomesForTagType.getTagTypes()));
        } else {
            context.put("tagTypes", testOutcomesForTagType.getTagTypes());
        }
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("parentTag", this.parentTag);
        context.put("reportName", reportName);
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirements));
        context.put("reportOptions", new ReportOptions(this.environmentVariables));
        context.put("timestamp", this.timestampFrom(new DateTime()));
        context.put("requirementTypes", this.requirements.getRequirementTypes());
        this.addFormattersToContext(context);
        VersionProvider versionProvider = new VersionProvider(this.environmentVariables);
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
        context.put("build", this.buildProperties);
        return context;
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter(this.issueTracking);
        context.put("formatter", formatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("relativeLink", this.relativeLink);
        context.put("reportOptions", new ReportOptions(this.environmentVariables));
    }

    protected String timestampFrom(DateTime startTime) {
        return startTime == null ? "" : startTime.toString("dd-MM-YYYY HH:mm");
    }

    public FreemarkerContext withParentTag(TestTag knownTag) {
        return new FreemarkerContext(this.environmentVariables, this.requirements, this.issueTracking, this.relativeLink, knownTag);
    }
}

