/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.thucydides.core.util.Acronym;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;

public final class NameConverter {
    private static final String INDEXED_METHOD_NAME = ".*\\[\\d+]";
    private static final String[] abbreviations = new String[]{"CSV", "XML", "JSON"};
    private static final Map<Character, String> EXCLUDE_FROM_FILENAMES = new HashMap<Character, String>();

    private NameConverter() {
    }

    public static String humanize(String name) {
        if (name == null || name.trim().length() == 0) {
            return "";
        }
        if (name.contains(" ") && !NameConverter.thereAreParametersIn(name)) {
            return name;
        }
        if (NameConverter.thereAreParametersIn(name)) {
            return NameConverter.humanizeNameWithParameters(name);
        }
        String noUnderscores = name.replaceAll("_", " ");
        String splitCamelCase = NameConverter.splitCamelCase(noUnderscores);
        Set<Acronym> acronyms = Acronym.acronymsIn(splitCamelCase);
        String capitalized = StringUtils.capitalize((String)splitCamelCase);
        for (Acronym acronym : acronyms) {
            capitalized = acronym.restoreIn(capitalized);
        }
        return NameConverter.restoreAbbreviations(capitalized);
    }

    private static String restoreAbbreviations(String sentence) {
        String processing = sentence;
        for (String abbreviation : abbreviations) {
            processing = processing.replaceAll(StringUtils.capitalize((String)abbreviation), abbreviation);
        }
        return processing;
    }

    private static String humanizeNameWithParameters(String name) {
        int parametersStartAt = name.indexOf(": ");
        String bareName = name.substring(0, parametersStartAt);
        String humanizedBareName = NameConverter.humanize(bareName);
        String parameters = name.substring(parametersStartAt);
        return humanizedBareName + parameters;
    }

    private static boolean thereAreParametersIn(String name) {
        return name.contains(": ");
    }

    public static String splitCamelCase(String name) {
        ArrayList<String> splitWords = new ArrayList<String>();
        List phrases = Splitter.on((String)" ").omitEmptyStrings().splitToList((CharSequence)name);
        for (String phrase : phrases) {
            splitWords.addAll(NameConverter.splitWordsIn(phrase));
        }
        String splitPhrase = Joiner.on((String)" ").join(splitWords);
        return splitPhrase.trim();
    }

    private static List<String> splitWordsIn(String phrase) {
        ArrayList<String> splitWords = new ArrayList<String>();
        String currentWord = "";
        for (int index = 0; index < phrase.length(); ++index) {
            if (NameConverter.onWordBoundary(phrase, index)) {
                splitWords.add(NameConverter.lowercaseOrAcronym(currentWord));
                currentWord = String.valueOf(phrase.charAt(index));
                continue;
            }
            currentWord = currentWord + phrase.charAt(index);
        }
        splitWords.add(NameConverter.lowercaseOrAcronym(currentWord));
        return splitWords;
    }

    private static String lowercaseOrAcronym(String word) {
        if (Acronym.isAnAcronym(word)) {
            return word;
        }
        return StringUtils.lowerCase((String)word);
    }

    private static boolean onWordBoundary(String name, int index) {
        return NameConverter.uppercaseLetterAt(name, index) && (NameConverter.lowercaseLetterAt(name, index - 1) || NameConverter.lowercaseLetterAt(name, index + 1));
    }

    private static boolean uppercaseLetterAt(String name, int index) {
        return CharUtils.isAsciiAlphaUpper((char)name.charAt(index));
    }

    private static boolean lowercaseLetterAt(String name, int index) {
        return index >= 0 && index < name.length() && CharUtils.isAsciiAlphaLower((char)name.charAt(index));
    }

    public static String withNoArguments(String methodName) {
        return NameConverter.stripArgumentsFrom(NameConverter.stripIndexesFrom(methodName));
    }

    public static String withNoIssueNumbers(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstIssueNumberIndex = methodName.indexOf("_(#");
        if (firstIssueNumberIndex == -1) {
            firstIssueNumberIndex = methodName.indexOf("(#");
        }
        if (firstIssueNumberIndex == -1) {
            firstIssueNumberIndex = methodName.indexOf("#");
        }
        if (firstIssueNumberIndex > 0) {
            return methodName.substring(0, firstIssueNumberIndex);
        }
        return methodName;
    }

    public static String stripArgumentsFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        int firstArgument = methodName.indexOf(58);
        if (firstArgument > 0) {
            return methodName.substring(0, firstArgument);
        }
        return methodName;
    }

    public static String stripIndexesFrom(String methodName) {
        if (methodName == null) {
            return null;
        }
        return methodName.matches(INDEXED_METHOD_NAME) ? methodName.substring(0, methodName.lastIndexOf(91)) : methodName;
    }

    public static String underscore(String name) {
        if (name != null) {
            return name.replaceAll(" ", "_").replaceAll("<", "_lt_").replaceAll(">", "underscore_gt_").replaceAll("'", "_sq_").replaceAll("\"", "_dq_").replaceAll(",", "_c_").replaceAll(":", "_cl_").replaceAll(";", "_sc_").replaceAll("/", "_sl_").replaceAll("=", "_eq_").toLowerCase(Locale.getDefault()).trim();
        }
        return "";
    }

    public static String filesystemSafe(String name) {
        if (name == null) {
            return name;
        }
        String safeName = name.trim();
        for (Character substitutableChar : EXCLUDE_FROM_FILENAMES.keySet()) {
            safeName = StringUtils.replace((String)safeName, (String)substitutableChar.toString(), (String)EXCLUDE_FROM_FILENAMES.get(substitutableChar));
        }
        return safeName.toLowerCase();
    }

    static {
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('$'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('/'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('\\'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf(':'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf(';'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('<'), "_lt_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('>'), "_gt_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('['), "_obr_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf(']'), "_cbr_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('{'), "_obrc_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('}'), "_cbrc_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('*'), "_star_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('^'), "_caret_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('%'), "_per_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('\"'), "_quote_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('?'), "_question_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('|'), "_pipe_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('&'), "_amp_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf(','), "_comma_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('='), "_equals_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('\''), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('\"'), "_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('@'), "_at_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('#'), "_hash_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf('+'), "_plus_");
        EXCLUDE_FROM_FILENAMES.put(Character.valueOf(' '), "_");
    }
}

