/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.List;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.ChromePreferences;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;

    public ChromeDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        ChromeOptions chromeOptions = this.configuredOptions();
        capabilities.setCapability("chromeOptions", (Object)chromeOptions);
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        capabilities.setCapability("chrome.switches", chromeSwitches);
        AddCustomCapabilities.startingWith("chrome.capabilities.").from(this.environmentVariables).to(capabilities);
        return capabilities;
    }

    private ChromeOptions configuredOptions() {
        ChromeOptions options = new ChromeOptions();
        this.addSwitchesTo(options);
        this.addPreferencesTo(options);
        this.updateChromeBinaryIfSpecified(options);
        return options;
    }

    private void addSwitchesTo(ChromeOptions options) {
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        options.addArguments(new String[]{"test-type"});
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            List<String> arguments = new OptionsSplitter().split(chromeSwitches);
            options.addArguments(arguments);
        }
    }

    private void addPreferencesTo(ChromeOptions options) {
        Map<String, Object> chromePreferences = ChromePreferences.startingWith("chrome_preferences.").from(this.environmentVariables);
        if (!chromePreferences.isEmpty()) {
            options.setExperimentalOption("prefs", chromePreferences);
        }
    }

    private void updateChromeBinaryIfSpecified(ChromeOptions options) {
        String chromeBinary = this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY);
        if (StringUtils.isNotEmpty((CharSequence)chromeBinary)) {
            options.setBinary(chromeBinary);
        }
    }
}

