/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MethodFinder {
    private final Class targetClass;

    private MethodFinder(Class targetClass) {
        this.targetClass = targetClass;
    }

    public static MethodFinder inClass(Class targetClass) {
        return new MethodFinder(targetClass);
    }

    public List<Method> getAllMethods() {
        HashSet allMethods = Sets.newHashSet();
        allMethods.addAll(Arrays.asList(this.targetClass.getDeclaredMethods()));
        allMethods.addAll(Arrays.asList(this.targetClass.getMethods()));
        this.addParentMethods(allMethods, this.targetClass);
        return Lists.newArrayList((Iterable)allMethods);
    }

    private void addParentMethods(Set<Method> allMethods, Class targetClass) {
        if (targetClass.getSuperclass() != null) {
            allMethods.addAll(Arrays.asList(targetClass.getSuperclass().getDeclaredMethods()));
            this.addParentMethods(allMethods, targetClass.getSuperclass());
        }
    }

    public Method getMethodNamed(String methodName) {
        List<Method> methods = this.getAllMethods();
        Method methodFound = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            methodFound = method;
        }
        return methodFound;
    }

    public Method getMethodNamed(String methodName, int argumentCount) {
        List<Method> methods = this.getAllMethods();
        Method methodFound = null;
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            methodFound = method;
            if (method.getParameterTypes().length != argumentCount) continue;
            methodFound = method;
            break;
        }
        return methodFound;
    }
}

