/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import ch.lambdaj.Lambda;
import com.github.rjeschke.txtmark.Configuration;
import com.github.rjeschke.txtmark.Processor;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Key;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.reports.html.ExampleTable;
import net.thucydides.core.reports.html.MarkdownRendering;
import net.thucydides.core.reports.html.ResultIconFormatter;
import net.thucydides.core.reports.html.ResultRankingFormatter;
import net.thucydides.core.reports.renderer.Asciidoc;
import net.thucydides.core.reports.renderer.MarkupRenderer;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formatter {
    private static final String ISSUE_NUMBER_REGEXP = "#([A-Z][A-Z0-9-_]*)?-?\\d+";
    private static final Pattern shortIssueNumberPattern = Pattern.compile("#([A-Z][A-Z0-9-_]*)?-?\\d+");
    private static final String FULL_ISSUE_NUMBER_REGEXP = "([A-Z][A-Z0-9-_]*)-\\d+";
    private static final Pattern fullIssueNumberPattern = Pattern.compile("([A-Z][A-Z0-9-_]*)-\\d+");
    private static final String ISSUE_LINK_FORMAT = "<a target=\"_blank\" href=\"{0}\">{1}</a>";
    private static final String ELIPSE = "&hellip;";
    private static final String ASCIIDOC = "asciidoc";
    private static final String MARKDOWN = "markdown";
    private static final String TEXT = "";
    private static final String STANDARD_NEW_LINE = "\n";
    private static final String NEWLINE_CHAR = "\u2424";
    private static final String NEWLINE = "\u0085";
    private static final String LINE_SEPARATOR = "\u2028";
    private static final String PARAGRAPH_SEPARATOR = "\u2029";
    private static final Logger LOGGER = LoggerFactory.getLogger(Formatter.class);
    public static final String FOUR_SPACES = "&nbsp; &nbsp; &nbsp; &nbsp;";
    public static final String TAB = "\\t";
    public static final String NEW_LINE_ON_ANY_OS = "\\r?\\n";
    public static final String UTF_8_NEW_LINE = "\u2424";
    private final IssueTracking issueTracking;
    private final EnvironmentVariables environmentVariables;
    private final MarkupRenderer asciidocRenderer;
    Configuration markdownEncodingConfiguration;
    private static final CharSequenceTranslator ESCAPE_SPECIAL_CHARS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_ESCAPE())});
    private final CharSequenceTranslator BASIC_XML = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.BASIC_ESCAPE())});

    @Inject
    public Formatter(IssueTracking issueTracking, EnvironmentVariables environmentVariables) {
        this.issueTracking = issueTracking;
        this.environmentVariables = environmentVariables;
        this.asciidocRenderer = (MarkupRenderer)Injectors.getInjector().getInstance(Key.get(MarkupRenderer.class, Asciidoc.class));
        String encoding = ThucydidesSystemProperty.REPORT_CHARSET.from(environmentVariables, "UTF-8");
        this.markdownEncodingConfiguration = Configuration.builder().setEncoding(encoding).build();
    }

    public Formatter(IssueTracking issueTracking) {
        this(issueTracking, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public String renderAsciidoc(String text) {
        return this.stripNewLines(this.asciidocRenderer.render(text));
    }

    public String renderMarkdown(String text) {
        if (text == null) {
            return TEXT;
        }
        return this.stripSurroundingParagraphTagsFrom(Processor.process((String)text, (Configuration)this.markdownEncodingConfiguration));
    }

    private String stripSurroundingParagraphTagsFrom(String text) {
        if (text.toLowerCase().trim().startsWith("<p>")) {
            text = text.trim().substring(3);
        }
        if (text.toLowerCase().trim().endsWith("</p>")) {
            text = text.trim().substring(0, text.length() - 4);
        }
        return text;
    }

    private String stripNewLines(String render) {
        return render.replaceAll(STANDARD_NEW_LINE, TEXT);
    }

    public String stripQualifications(String title) {
        if (title == null) {
            return TEXT;
        }
        if (title.contains("[")) {
            return title.substring(0, title.lastIndexOf("[")).trim();
        }
        return title;
    }

    public String renderText(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return TEXT;
        }
        return Formatter.concatLines(this.BASIC_XML.translate((CharSequence)text), "<br>").replaceAll(TAB, FOUR_SPACES);
    }

    public String renderHeaders(String text) {
        if (text == null) {
            return TEXT;
        }
        return Formatter.concatLines(this.BASIC_XML.translate((CharSequence)Formatter.stringFormOf(text)), "<br>").replaceAll(TAB, TEXT);
    }

    public static List<String> issuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        List<String> issuesWithHash = extractor.getShortenedIssues();
        List<String> allIssues = extractor.getFullIssues();
        allIssues.addAll(issuesWithHash);
        return allIssues;
    }

    public String addLinks(String value) {
        if (this.issueTracking == null) {
            return value;
        }
        String formattedValue = value;
        if (this.issueTracking.getIssueTrackerUrl() != null) {
            formattedValue = this.insertFullIssueTrackingUrls(value);
        }
        if (this.issueTracking.getShortenedIssueTrackerUrl() != null) {
            formattedValue = this.insertShortenedIssueTrackingUrls(formattedValue);
        }
        return formattedValue;
    }

    public String renderDescription(String text) {
        String format = this.environmentVariables.getProperty(ThucydidesSystemProperty.NARRATIVE_FORMAT, TEXT);
        if (this.isRenderedHtml(text)) {
            return text;
        }
        if (format.equalsIgnoreCase(ASCIIDOC)) {
            return this.renderAsciidoc(text);
        }
        if (format.equalsIgnoreCase(MARKDOWN) || MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.narrative)) {
            return this.renderMarkdown(text);
        }
        return Formatter.addLineBreaks(text);
    }

    private boolean isRenderedHtml(String text) {
        return text != null && text.startsWith("<");
    }

    public static String addLineBreaks(String text) {
        return text != null ? Formatter.concatLines(text, "<br>") : TEXT;
    }

    public String convertAnyTables(String text) {
        if (this.shouldFormatEmbeddedTables() && this.containsEmbeddedTable(text)) {
            text = this.convertNonStandardNLChars(text);
            text = ExampleTable.stripBracketsFromOuterPipes(text);
            text = this.withTablesReplaced(text);
        }
        return text;
    }

    private String withTablesReplaced(String text) {
        List<String> unformattedTables = this.getEmbeddedTablesIn(text);
        for (String unformattedTable : unformattedTables) {
            ExampleTable table = new ExampleTable(unformattedTable);
            text = text.replace(unformattedTable, table.inHtmlFormat());
        }
        text = text.replaceAll(this.newLineUsedIn(text), "<br>");
        return text;
    }

    private String convertNonStandardNLChars(String text) {
        text = StringUtils.replace((String)text, (String)"\u2424", (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)NEWLINE, (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)LINE_SEPARATOR, (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)PARAGRAPH_SEPARATOR, (String)STANDARD_NEW_LINE);
        return text;
    }

    private boolean shouldFormatEmbeddedTables() {
        return ThucydidesSystemProperty.IGNORE_EMBEDDED_TABLES.booleanFrom(this.environmentVariables) == false;
    }

    private boolean containsEmbeddedTable(String text) {
        return this.positionOfFirstPipeIn(text) >= 0 && this.positionOfLastPipeIn(text) >= 0;
    }

    private int positionOfLastPipeIn(String text) {
        return text.indexOf("|", this.positionOfFirstPipeIn(text) + 1);
    }

    private int positionOfFirstPipeIn(String text) {
        return text.indexOf("|");
    }

    private List<String> getEmbeddedTablesIn(String text) {
        ArrayList embeddedTables = Lists.newArrayList();
        StringBuffer tableText = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            String line;
            boolean inTable = false;
            String newLine = this.newLineUsedIn(text);
            while ((line = reader.readLine()) != null) {
                if (!inTable && line.contains("|")) {
                    inTable = true;
                } else if (inTable && !line.contains("|") && !this.isBlank(line)) {
                    embeddedTables.add(tableText.toString().trim());
                    tableText = new StringBuffer();
                    inTable = false;
                }
                if (!inTable) continue;
                tableText.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process embedded table", e);
        }
        if (!tableText.toString().isEmpty()) {
            embeddedTables.add(tableText.toString().trim());
        }
        return embeddedTables;
    }

    private boolean isBlank(String line) {
        return StringUtils.isBlank((CharSequence)line.trim());
    }

    private String newLineUsedIn(String text) {
        if (text.contains("\r\n")) {
            return "\r\n";
        }
        if (text.contains(STANDARD_NEW_LINE)) {
            return STANDARD_NEW_LINE;
        }
        if (text.contains("\r")) {
            return "\r";
        }
        return STANDARD_NEW_LINE;
    }

    public String htmlCompatible(Object fieldValue) {
        return this.plainHtmlCompatible(fieldValue);
    }

    public String htmlCompatibleListEntry(Object fieldValue) {
        return MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.list) ? this.renderMarkdown(this.htmlCompatible(fieldValue)) : this.htmlCompatible(fieldValue);
    }

    public String htmlCompatibleStoryTitle(Object fieldValue) {
        return MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.story) ? this.renderMarkdown(this.htmlCompatible(fieldValue)) : this.htmlCompatible(fieldValue);
    }

    public String htmlCompatibleTestTitle(Object fieldValue) {
        return MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.scenario) ? this.renderMarkdown(this.htmlCompatible(fieldValue)) : this.htmlCompatible(fieldValue);
    }

    public String htmlCompatibleStepDescription(Object fieldValue) {
        return MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.step) ? this.renderMarkdown(this.htmlCompatible(fieldValue)) : this.htmlCompatible(fieldValue);
    }

    public String plainHtmlCompatible(Object fieldValue) {
        return Formatter.addLineBreaks(ESCAPE_SPECIAL_CHARS.translate((CharSequence)(fieldValue != null ? Formatter.stringFormOf(fieldValue) : TEXT))).trim();
    }

    public String htmlAttributeCompatible(Object fieldValue) {
        if (fieldValue == null) {
            return TEXT;
        }
        return Formatter.concatLines(ESCAPE_SPECIAL_CHARS.translate((CharSequence)Formatter.stringFormOf(fieldValue).replaceAll("<", "(").replaceAll(">", ")").replaceAll("\"", "'")));
    }

    public String htmlAttributeCompatible(Object fieldValue, int maxLength) {
        return StringUtils.abbreviate((String)this.htmlAttributeCompatible(fieldValue), (int)maxLength);
    }

    public ResultIconFormatter resultIcon() {
        return new ResultIconFormatter();
    }

    public ResultRankingFormatter resultRank() {
        return new ResultRankingFormatter();
    }

    private static String concatLines(String message) {
        return Formatter.concatLines(message, " ");
    }

    private static String concatLines(String message, String newLine) {
        message = StringUtils.replace((String)message, (String)"\u2424", (String)newLine);
        List lines = Splitter.onPattern((String)NEW_LINE_ON_ANY_OS).splitToList((CharSequence)message);
        return StringUtils.join((Iterable)lines, (String)newLine);
    }

    private static String stringFormOf(Object fieldValue) {
        if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
            return "[" + Lambda.join((Object)fieldValue) + "]";
        }
        return fieldValue.toString();
    }

    public String truncatedHtmlCompatible(String text, int length) {
        return this.renderMarkdown(Formatter.addLineBreaks(ESCAPE_SPECIAL_CHARS.translate((CharSequence)this.truncate(text, length))));
    }

    private String truncate(String text, int length) {
        if (text.length() > length) {
            return text.substring(0, length).trim() + ELIPSE;
        }
        return text;
    }

    private String replaceWithTokens(String value, List<String> issues) {
        List<String> sortedIssues = this.inOrderOfDecreasingLength(issues);
        for (int i = 0; i < sortedIssues.size(); ++i) {
            value = value.replaceAll(sortedIssues.get(i), "%%%" + i + "%%%");
        }
        return value;
    }

    private List<String> inOrderOfDecreasingLength(List<String> issues) {
        ArrayList sortedIssues = Lists.newArrayList(issues);
        Collections.sort(sortedIssues, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o2.length() - o1.length();
            }
        });
        return sortedIssues;
    }

    public static List<String> shortenedIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getShortenedIssues();
    }

    public static List<String> fullIssuesIn(String value) {
        IssueExtractor extractor = new IssueExtractor(value);
        return extractor.getFullIssues();
    }

    private String insertShortenedIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getShortenedIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(Formatter.shortenedIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, this.stripLeadingHashFrom(issue));
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private String insertFullIssueTrackingUrls(String value) {
        String issueUrlFormat = this.issueTracking.getIssueTrackerUrl();
        List<String> issues = this.sortByDecreasingSize(Formatter.fullIssuesIn(value));
        String formattedValue = this.replaceWithTokens(value, issues);
        int i = 0;
        for (String issue : issues) {
            String issueUrl = MessageFormat.format(issueUrlFormat, issue);
            String issueLink = MessageFormat.format(ISSUE_LINK_FORMAT, issueUrl, issue);
            String token = "%%%" + i++ + "%%%";
            formattedValue = formattedValue.replaceAll(token, issueLink);
        }
        return formattedValue;
    }

    private List<String> sortByDecreasingSize(List<String> issues) {
        ArrayList sortedIssues = Lists.newArrayList(issues);
        Collections.sort(sortedIssues, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                return Integer.valueOf(-a.length()).compareTo(b.length());
            }
        });
        return sortedIssues;
    }

    public String formatWithFields(String textToFormat) {
        String textWithEscapedFields = textToFormat.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        String renderedText = Formatter.addLineBreaks(this.removeMacros(this.convertAnyTables(textWithEscapedFields)));
        if (MarkdownRendering.configuredIn(this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.step)) {
            renderedText = this.renderMarkdown(renderedText);
        }
        return renderedText;
    }

    private String removeMacros(String textToFormat) {
        return textToFormat.replaceAll("\\{trim=false\\}\\s*\\r?\\n", TEXT);
    }

    private String stripLeadingHashFrom(String issue) {
        return issue.substring(1);
    }

    static class IssueExtractor {
        private String workingCopy;

        IssueExtractor(String initialValue) {
            this.workingCopy = initialValue;
        }

        public List<String> getShortenedIssues() {
            Matcher matcher = shortIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (matcher.find()) {
                String issue = matcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, Formatter.TEXT);
            }
            return issues;
        }

        public List<String> getFullIssues() {
            Matcher unhashedMatcher = fullIssueNumberPattern.matcher(this.workingCopy);
            ArrayList issues = Lists.newArrayList();
            while (unhashedMatcher.find()) {
                String issue = unhashedMatcher.group();
                issues.add(issue);
                this.workingCopy = this.workingCopy.replaceFirst(issue, Formatter.TEXT);
            }
            return issues;
        }
    }
}

