/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.phantomjs;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class PhantomJSCapabilityEnhancer {
    private final EnvironmentVariables environmentVariables;

    public PhantomJSCapabilityEnhancer(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void enhanceCapabilities(DesiredCapabilities capabilities) {
        if (this.environmentVariables.getProperty(ThucydidesSystemProperty.PHANTOMJS_BINARY_PATH) != null) {
            capabilities.setCapability("phantomjs.binary.path", this.environmentVariables.getProperty(ThucydidesSystemProperty.PHANTOMJS_BINARY_PATH));
        }
        ArrayList cliArgs = Lists.newArrayList();
        this.setSecurityOptions(cliArgs);
        this.setLoggingOptions(cliArgs);
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables))) {
            this.setProxyOptions(cliArgs);
        }
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables))) {
            this.setRemoteOptions(cliArgs);
        }
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.PHANTOMJS_SSL_PROTOCOL.from(this.environmentVariables))) {
            String sslSupport = ThucydidesSystemProperty.PHANTOMJS_SSL_PROTOCOL.from(this.environmentVariables);
            if (sslSupport.equals("sslv2") || sslSupport.equals("sslv3") || sslSupport.equals("tlsv1") || sslSupport.equals("any")) {
                cliArgs.add("--ssl-protocol=" + sslSupport);
            } else {
                cliArgs.add("--ssl-protocol=any");
            }
        } else {
            cliArgs.add("--ssl-protocol=any");
        }
        AddCustomCapabilities.startingWith("phantomjs.").from(this.environmentVariables).withAndWithoutPrefixes().to(capabilities);
        capabilities.setCapability("phantomjs.cli.args", (Object)cliArgs.toArray(new String[0]));
    }

    private void setRemoteOptions(ArrayList<String> cliArgs) {
        cliArgs.add("--webdriver-selenium-grid-hub=" + ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.from(this.environmentVariables));
        if (StringUtils.isNotEmpty((CharSequence)ThucydidesSystemProperty.PHANTOMJS_WEBDRIVER_PORT.from(this.environmentVariables))) {
            cliArgs.add("--webdriver=" + ThucydidesSystemProperty.PHANTOMJS_WEBDRIVER_PORT.from(this.environmentVariables));
        }
    }

    private void setProxyOptions(ArrayList<String> cliArgs) {
        String proxyUrl = ThucydidesSystemProperty.SERENITY_PROXY_HTTP.from(this.environmentVariables);
        String proxyPort = ThucydidesSystemProperty.SERENITY_PROXY_HTTP_PORT.from(this.environmentVariables);
        String proxyType = ThucydidesSystemProperty.SERENITY_PROXY_TYPE.from(this.environmentVariables);
        String proxyUser = ThucydidesSystemProperty.SERENITY_PROXY_USER.from(this.environmentVariables);
        String proxyPassword = ThucydidesSystemProperty.SERENITY_PROXY_PASSWORD.from(this.environmentVariables);
        if (StringUtils.isEmpty((CharSequence)proxyPort)) {
            cliArgs.add("--proxy=" + proxyUrl);
        } else {
            cliArgs.add("--proxy=" + proxyUrl + ":" + proxyPort);
        }
        if (StringUtils.isNotEmpty((CharSequence)proxyUser)) {
            cliArgs.add("--proxy-auth=" + proxyUser + ":" + proxyPassword);
        }
        if (StringUtils.isNotEmpty((CharSequence)proxyType)) {
            cliArgs.add("--proxy-type=" + proxyType);
        }
    }

    private void setSecurityOptions(ArrayList<String> cliArgs) {
        cliArgs.add("--web-security=false");
        cliArgs.add("--ignore-ssl-errors=true");
    }

    private void setLoggingOptions(ArrayList<String> cliArgs) {
        cliArgs.add("--webdriver-loglevel=OFF");
    }
}

