/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import java.net.URL;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.MobilePlatform;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import net.thucydides.core.webdriver.appium.AppiumConfiguration;
import net.thucydides.core.webdriver.stubs.WebDriverStub;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class AppiumDriverProvider
implements DriverProvider {
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private final DriverCapabilityRecord driverProperties;

    public AppiumDriverProvider(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
        this.driverProperties = (DriverCapabilityRecord)Injectors.getInjector().getInstance(DriverCapabilityRecord.class);
    }

    @Override
    public WebDriver newInstance(String options) {
        if (StepEventBus.getEventBus().webdriverCallsAreSuspended()) {
            return new WebDriverStub();
        }
        switch (this.appiumTargetPlatform()) {
            case ANDROID: {
                AndroidDriver androidDriver = new AndroidDriver(this.appiumUrl(), (Capabilities)this.enhancer.enhanced(this.appiumCapabilities(options)));
                this.driverProperties.registerCapabilities("appium", androidDriver.getCapabilities());
                return androidDriver;
            }
            case IOS: {
                IOSDriver iosDriver = new IOSDriver(this.appiumUrl(), (Capabilities)this.enhancer.enhanced(this.appiumCapabilities(options)));
                this.driverProperties.registerCapabilities("appium", iosDriver.getCapabilities());
                return iosDriver;
            }
        }
        throw new UnsupportedDriverException(this.appiumTargetPlatform().name());
    }

    private DesiredCapabilities appiumCapabilities(String options) {
        return AppiumConfiguration.from(this.environmentVariables).getCapabilities(options);
    }

    private MobilePlatform appiumTargetPlatform() {
        return AppiumConfiguration.from(this.environmentVariables).getTargetPlatform();
    }

    private URL appiumUrl() {
        return AppiumConfiguration.from(this.environmentVariables).getUrl();
    }
}

