/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.issues;

import com.google.common.base.Joiner;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class IssueKeyFormat {
    private final EnvironmentVariables environmentVariables;

    private IssueKeyFormat(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    private String getProjectPrefix() {
        return ThucydidesSystemProperty.THUCYDIDES_PROJECT_KEY.from(this.environmentVariables);
    }

    public String andKey(String issueNumber) {
        String issueKey = issueNumber;
        if (issueKey.startsWith("#")) {
            issueKey = issueKey.substring(1);
        }
        if (StringUtils.isNumeric((CharSequence)issueKey) && this.getProjectPrefix() != null) {
            Joiner joiner = Joiner.on((String)"-");
            issueKey = joiner.join((Object)this.getProjectPrefix(), (Object)issueKey, new Object[0]);
        }
        return issueKey;
    }

    public static IssueKeyFormat forEnvironment(EnvironmentVariables environmentVariables) {
        return new IssueKeyFormat(environmentVariables);
    }
}

