/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;

public class StackTraceSanitizer {
    private final EnvironmentVariables environmentVariables;
    private final StackTraceElement[] stackTrace;
    private static final List<String> MASKED_PACKAGES = ImmutableList.of((Object)"sun.", (Object)"com.sun", (Object)"java.", (Object)"org.junit", (Object)"org.gradle", (Object)"org.testng", (Object)"org.hamcrest", (Object)"com.jayway.restassured", (Object)"org.fest", (Object)"org.assertj", (Object)"org.openqa.selenium", (Object)"org.spockframework", (Object[])new String[]{"org.apache.maven.surefire", "com.intellij", "net.sf.cglib", "org.codehaus.groovy", "org.jbehave", "cucumber.runtime", "cucumber.api", "net.serenitybdd.core", "net.serenitybdd.junit", "net.serenitybdd.plugins", "net.serenitybdd.cucumber", "net.serenitybdd.jbehave", "net.serenitybdd.screenplay", "net.thucydides.core", "net.thucydides.junit", "net.thucydides.plugins", "net.thucydides.jbehave"});

    public StackTraceSanitizer(EnvironmentVariables environmentVariables, StackTraceElement[] stackTrace) {
        this.environmentVariables = environmentVariables;
        this.stackTrace = Arrays.copyOf(stackTrace, stackTrace.length);
    }

    public static StackTraceSanitizer forStackTrace(StackTraceElement[] stackTrace) {
        return new StackTraceSanitizer((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get(), stackTrace);
    }

    public StackTraceElement[] sanitized(StackTraceElement[] stackTrace) {
        return this.useSimplifedStackTraces() ? this.simplifiedStackTrace(stackTrace) : stackTrace;
    }

    private boolean useSimplifedStackTraces() {
        return ThucydidesSystemProperty.SIMPLIFIED_STACK_TRACES.booleanFrom(this.environmentVariables, true);
    }

    private StackTraceElement[] simplifiedStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElement> cleanStackTrace = new ArrayList<StackTraceElement>();
        for (StackTraceElement element : stackTrace) {
            if (!this.shouldDisplayInStackTrace(element)) continue;
            cleanStackTrace.add(element);
        }
        return cleanStackTrace.toArray(new StackTraceElement[0]);
    }

    private boolean shouldDisplayInStackTrace(StackTraceElement element) {
        if (element.getClassName().contains("$")) {
            return false;
        }
        for (String maskedPackage : MASKED_PACKAGES) {
            if (!element.getClassName().startsWith(maskedPackage)) continue;
            return false;
        }
        return true;
    }

    public StackTraceElement[] getSanitizedStackTrace() {
        return this.sanitized(this.stackTrace);
    }
}

