/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages.components;

import java.io.File;
import java.net.URL;
import java.util.regex.Pattern;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.webdriver.ConfigureFileDetector;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.FileDetector;
import org.openqa.selenium.remote.LocalFileDetector;
import org.openqa.selenium.remote.RemoteWebElement;

public class FileToUpload {
    private final String filename;
    static final String WINDOWS_PATH_PATTERN = "^[A-Z]:\\\\.*";
    private static Pattern fullWindowsPath = Pattern.compile("^[A-Z]:\\\\.*");
    private final WebDriver driver;
    private boolean remoteDriver = false;

    public FileToUpload(WebDriver driver, String filename) {
        this.driver = driver;
        this.filename = this.isOnTheClasspath(filename) ? this.getFileFromResourcePath(filename) : this.getFileFromFileSystem(filename);
    }

    private boolean isOnTheClasspath(String filename) {
        if (FileToUpload.isOnTheUnixFileSystem(filename) || FileToUpload.isOnTheWindowsFileSystem(filename)) {
            return false;
        }
        return this.resourceOnClasspath(filename) != null;
    }

    private URL resourceOnClasspath(String filename) {
        ClassLoader cldr = Thread.currentThread().getContextClassLoader();
        return cldr.getResource(filename);
    }

    public static boolean isOnTheWindowsFileSystem(String filename) {
        return SystemUtils.IS_OS_WINDOWS && new File(filename).exists();
    }

    public static boolean isAFullWindowsPath(String filename) {
        return fullWindowsPath.matcher(filename).find();
    }

    public static boolean isOnTheUnixFileSystem(String filename) {
        return SystemUtils.IS_OS_UNIX && new File(filename).exists();
    }

    private String getFileFromResourcePath(String filename) {
        return new File(this.resourceOnClasspath(filename).getFile()).getAbsolutePath();
    }

    private String getFileFromFileSystem(String filename) {
        File fileToUpload = new File(filename);
        return fileToUpload.getAbsolutePath();
    }

    public void to(WebElement uploadFileField) {
        String filePath = this.uploadableFilePathTo(uploadFileField).forFile(this.filename);
        uploadFileField.sendKeys(new CharSequence[]{this.osSpecificPathOf(filePath)});
    }

    private FilePathLocator uploadableFilePathTo(WebElement uploadFileField) {
        return this.isRemoteDriver() ? new RemoteFilePathLocator(uploadFileField) : new LocalFilePathLocator();
    }

    public boolean isRemoteDriver() {
        return this.remoteDriver;
    }

    public FileToUpload useRemoteDriver(boolean remoteDriver) {
        this.remoteDriver = remoteDriver;
        return this;
    }

    private String osSpecificPathOf(String fileToUpload) {
        if (FileToUpload.isAFullWindowsPath(fileToUpload)) {
            return this.windowsNative(fileToUpload);
        }
        return fileToUpload;
    }

    private String windowsNative(String fileToUpload) {
        String bareFilename = fileToUpload.charAt(0) == '/' ? fileToUpload.substring(1) : fileToUpload;
        return StringUtils.replace((String)bareFilename, (String)"/", (String)"\\");
    }

    public FileToUpload fromLocalMachine() {
        ConfigureFileDetector.forDriver(this.driver);
        return this;
    }

    class RemoteFilePathLocator
    implements FilePathLocator {
        private final WebElement uploadFileField;

        public RemoteFilePathLocator(WebElement uploadFileField) {
            this.uploadFileField = uploadFileField;
        }

        @Override
        public String forFile(String filename) {
            WebElement resolvedField;
            LocalFileDetector detector = new LocalFileDetector();
            File localFile = detector.getLocalFile(new CharSequence[]{FileToUpload.this.osSpecificPathOf(filename)});
            WebElement webElement = resolvedField = this.uploadFileField instanceof WebElementFacade ? ((WebElementFacade)this.uploadFileField).getWrappedElement() : this.uploadFileField;
            if (resolvedField instanceof RemoteWebElement) {
                ((RemoteWebElement)resolvedField).setFileDetector((FileDetector)detector);
            }
            return localFile.getAbsolutePath();
        }
    }

    static interface FilePathLocator {
        public String forFile(String var1);
    }

    private class LocalFilePathLocator
    implements FilePathLocator {
        @Override
        public String forFile(String filename) {
            return FileToUpload.this.osSpecificPathOf(filename);
        }
    }
}

