/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.Optional;
import java.util.Properties;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.RemoteDriverCapabilities;
import net.thucydides.core.webdriver.capabilities.RemoteTestName;
import net.thucydides.core.webdriver.capabilities.SetAppropriateSaucelabsPlatformVersion;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SaucelabsRemoteDriverCapabilities
implements RemoteDriverCapabilities {
    private final EnvironmentVariables environmentVariables;

    public SaucelabsRemoteDriverCapabilities(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public String getUrl() {
        return ThucydidesSystemProperty.SAUCELABS_URL.from(this.environmentVariables);
    }

    @Override
    public DesiredCapabilities getCapabilities(DesiredCapabilities capabilities) {
        this.configureBrowserVersion(capabilities);
        this.configureTargetPlatform(capabilities);
        Properties saucelabsProperties = this.environmentVariables.getPropertiesWithPrefix("saucelabs.");
        for (String propertyName : saucelabsProperties.stringPropertyNames()) {
            String unprefixedPropertyName = this.unprefixed(propertyName);
            capabilities.setCapability(propertyName, this.typed(saucelabsProperties.getProperty(propertyName)));
            capabilities.setCapability(unprefixedPropertyName, this.typed(saucelabsProperties.getProperty(propertyName)));
        }
        this.addBuildNumberTo(capabilities);
        this.configureTestName(capabilities);
        capabilities.setJavascriptEnabled(true);
        return capabilities;
    }

    private void addBuildNumberTo(DesiredCapabilities capabilities) {
        if (this.environmentVariables.getProperty("BUILD_NUMBER") != null) {
            capabilities.setCapability("build", this.environmentVariables.getProperty("BUILD_NUMBER"));
        }
    }

    private void configureBrowserVersion(DesiredCapabilities capabilities) {
        String driverVersion = ThucydidesSystemProperty.SAUCELABS_DRIVER_VERSION.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)driverVersion)) {
            capabilities.setCapability("version", driverVersion);
        }
    }

    private void configureTargetPlatform(DesiredCapabilities capabilities) {
        SetAppropriateSaucelabsPlatformVersion.inCapabilities(capabilities).from(this.environmentVariables);
        String remotePlatform = this.environmentVariables.getProperty("remote.platform");
        if (StringUtils.isNotEmpty((CharSequence)remotePlatform)) {
            capabilities.setPlatform(Platform.valueOf((String)remotePlatform));
        }
    }

    private Object typed(String value) {
        if (this.isABoolean(value)) {
            return Boolean.parseBoolean(value);
        }
        if (this.isAnInteger(value)) {
            return Integer.parseInt(value);
        }
        return value;
    }

    private boolean isAnInteger(String value) {
        return StringUtils.isNumeric((CharSequence)value);
    }

    private boolean isABoolean(String value) {
        return value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false");
    }

    private String unprefixed(String propertyName) {
        return propertyName.replace("saucelabs.", "");
    }

    private void configureTestName(DesiredCapabilities capabilities) {
        String testName = ThucydidesSystemProperty.SAUCELABS_TEST_NAME.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)testName)) {
            capabilities.setCapability("name", testName);
        } else {
            Optional<String> guessedTestName = RemoteTestName.fromCurrentTest();
            guessedTestName.ifPresent(name -> capabilities.setCapability("name", name));
        }
    }
}

