/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.screenshots;

import java.lang.reflect.Method;
import java.util.Optional;
import net.thucydides.core.annotations.Screenshots;
import net.thucydides.core.model.TakeScreenshots;
import net.thucydides.core.model.screenshots.ScreenshotPreferencesByClass;
import net.thucydides.core.reflection.StackTraceAnalyser;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.webdriver.Configuration;

public class ScreenshotPermission {
    private final Configuration configuration;

    public ScreenshotPermission(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean areAllowed(TakeScreenshots takeScreenshots) {
        com.google.common.base.Optional configuredLevel = this.methodOverride().or(this.classOverride()).or(this.configuration.getScreenshotLevel());
        if (configuredLevel.isPresent()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast((TakeScreenshots)((Object)configuredLevel.get()));
        }
        return this.legacyScreenshotConfiguration(takeScreenshots);
    }

    private boolean legacyScreenshotConfiguration(TakeScreenshots takeScreenshots) {
        if (this.configuration.onlySaveFailingScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_FAILURES);
        }
        if (this.configuration.takeVerboseScreenshots()) {
            return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.FOR_EACH_ACTION);
        }
        return this.takeScreenshotLevel(takeScreenshots).isAtLeast(TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP);
    }

    private com.google.common.base.Optional<TakeScreenshots> methodOverride() {
        for (Method callingMethod : StackTraceAnalyser.inscopeMethodsIn(new Throwable().getStackTrace())) {
            com.google.common.base.Optional<TakeScreenshots> overriddenScreenshotPreference = this.overriddenScreenshotPreferenceFor(callingMethod);
            if (!overriddenScreenshotPreference.isPresent()) continue;
            return overriddenScreenshotPreference;
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<TakeScreenshots> classOverride() {
        com.google.common.base.Optional<Method> currentStepMethod;
        if (StepEventBus.getEventBus().isBaseStepListenerRegistered() && (currentStepMethod = StepEventBus.getEventBus().getBaseStepListener().getCurrentStepMethod()) != null && currentStepMethod.isPresent()) {
            return this.overriddenScreenshotPreferenceForClass(((Method)currentStepMethod.get()).getDeclaringClass());
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<TakeScreenshots> overriddenScreenshotPreferenceForClass(Class<?> declaringClass) {
        Optional<TakeScreenshots> optionalScreenshotPreference = ScreenshotPreferencesByClass.forClass(declaringClass).withEnvironmentVariables(this.configuration.getEnvironmentVariables()).getScreenshotPreference();
        return com.google.common.base.Optional.fromJavaUtil(optionalScreenshotPreference);
    }

    private com.google.common.base.Optional<TakeScreenshots> overriddenScreenshotPreferenceFor(Method callingMethod) {
        if (callingMethod.getAnnotation(Screenshots.class) != null) {
            return com.google.common.base.Optional.of((Object)((Object)this.screenshotLevelFrom(callingMethod.getAnnotation(Screenshots.class))));
        }
        return com.google.common.base.Optional.absent();
    }

    private TakeScreenshots screenshotLevelFrom(Screenshots screenshots) {
        if (screenshots.disabled()) {
            return TakeScreenshots.DISABLED;
        }
        if (screenshots.onlyOnFailures()) {
            return TakeScreenshots.FOR_FAILURES;
        }
        if (screenshots.forEachAction()) {
            return TakeScreenshots.FOR_EACH_ACTION;
        }
        if (screenshots.afterEachStep()) {
            return TakeScreenshots.AFTER_EACH_STEP;
        }
        if (screenshots.beforeAndAfterEachStep()) {
            return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
        }
        return TakeScreenshots.BEFORE_AND_AFTER_EACH_STEP;
    }

    private TakeScreenshotsComparer takeScreenshotLevel(TakeScreenshots takeScreenshots) {
        return new TakeScreenshotsComparer(takeScreenshots);
    }

    private static class TakeScreenshotsComparer {
        private final TakeScreenshots takeScreenshots;

        private TakeScreenshotsComparer(TakeScreenshots takeScreenshots) {
            this.takeScreenshots = takeScreenshots;
        }

        public boolean isAtLeast(TakeScreenshots requiredLevel) {
            return this.takeScreenshots.compareTo(requiredLevel) >= 0;
        }
    }
}

