/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.files.TheDirectoryStructure;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.AllRequirements;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.RootDirectory;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.NarrativeReader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemRequirementsTagProvider.class);
    private static final List<Requirement> NO_REQUIREMENTS = new ArrayList<Requirement>();
    private static final List<TestTag> NO_TEST_TAGS = new ArrayList<TestTag>();
    public static final String STORY_EXTENSION = "story";
    public static final String FEATURE_EXTENSION = "feature";
    private final NarrativeReader narrativeReader;
    private final int level;
    private final RequirementsConfiguration requirementsConfiguration;
    private List<Requirement> requirements;
    private final ReentrantLock requirementsLock = new ReentrantLock();

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(RootDirectory.defaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()), environmentVariables);
    }

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this(rootDirectoryPath, environmentVariables);
    }

    public FileSystemRequirementsTagProvider() {
        this(RootDirectory.defaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()));
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), level, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    private static String filePathFormOf(String rootDirectory) {
        if (rootDirectory.contains(".")) {
            return rootDirectory.replace(".", "/");
        }
        return rootDirectory;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.narrativeReader = NarrativeReader.forRootDirectory(rootDirectory).withRequirementTypes(this.getRequirementTypes());
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        Set<String> directoryPaths = FileSystemRequirementsTagProvider.rootDirectories(rootDirectory, environmentVariables);
        this.level = this.requirementsConfiguration.startLevelForADepthOf(this.maxDirectoryDepthIn(directoryPaths) + 1);
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.narrativeReader = NarrativeReader.forRootDirectory(rootDirectory).withRequirementTypes(this.getRequirementTypes());
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.level = level;
    }

    private static Set<String> rootDirectories(String rootDirectory, EnvironmentVariables environmentVariables) {
        return new RootDirectory(environmentVariables, rootDirectory).getRootDirectoryPaths();
    }

    public FileSystemRequirementsTagProvider(String rootDirectory) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            this.requirementsLock.lock();
            try {
                HashSet allRequirements = Sets.newHashSet();
                Set<String> directoryPaths = this.getRootDirectoryPaths();
                for (String path : directoryPaths) {
                    File rootDirectory = new File(path);
                    logger.trace("Loading requirements from {}", (Object)rootDirectory);
                    if (!rootDirectory.exists()) continue;
                    allRequirements.addAll(this.loadCapabilitiesFrom(rootDirectory.listFiles(this.thatAreFeatureDirectories())));
                    allRequirements.addAll(this.loadStoriesFrom(rootDirectory.listFiles(this.thatAreStories())));
                }
                this.requirements = Lists.newArrayList((Iterable)allRequirements);
                Collections.sort(this.requirements);
            }
            catch (IOException e) {
                this.requirements = NO_REQUIREMENTS;
                throw new IllegalArgumentException("Could not load requirements from '" + this.rootDirectory + "'", e);
            }
            this.requirements = this.addParentsTo(this.requirements);
            this.requirementsLock.unlock();
        }
        return this.requirements;
    }

    private int maxDirectoryDepthIn(Set<String> directoryPaths) {
        return directoryPaths.stream().mapToInt(directoryPath -> TheDirectoryStructure.startingAt(new File((String)directoryPath)).maxDepth()).max().orElse(0);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements) {
        return this.addParentsTo(requirements, null);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements, String parent) {
        ArrayList<Requirement> augmentedRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            List<Requirement> children = requirement.hasChildren() ? this.addParentsTo(requirement.getChildren(), requirement.qualifiedName()) : NO_REQUIREMENTS;
            augmentedRequirements.add(requirement.withParent(parent).withChildren(children));
        }
        return augmentedRequirements;
    }

    public Set<String> getRootDirectoryPaths() throws IOException {
        return new RootDirectory(this.environmentVariables, this.rootDirectory).getRootDirectoryPaths();
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            Optional<TestTag> matchingRequirementTag;
            Optional<Requirement> matchingRequirement = this.requirementWithMatchingFeatureFile(testOutcome);
            if (matchingRequirement.isPresent()) {
                tags.add(matchingRequirement.get().asTag());
                tags.addAll(this.parentRequirementsOf(matchingRequirement.get().asTag()));
            }
            List<String> storyPathElements = this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath())));
            tags.addAll(this.getMatchingCapabilities(this.getRequirements(), this.stripStorySuffixFrom(storyPathElements)));
            if (tags.isEmpty() && this.storyOrFeatureDescribedIn(storyPathElements).isPresent() && (matchingRequirementTag = this.getMatchingRequirementTagsFor(this.storyOrFeatureDescribedIn(storyPathElements).get())).isPresent()) {
                tags.add(matchingRequirementTag.get());
                tags.addAll(this.parentRequirementsOf(matchingRequirementTag.get()));
            }
        }
        return tags;
    }

    Optional<Requirement> requirementWithMatchingFeatureFile(TestOutcome testOutcome) {
        String candidatePath = testOutcome.getPath();
        String parentRequirementId = testOutcome.getParentId();
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (requirement.getId() != null && requirement.getId().equals(parentRequirementId)) {
                return Optional.of(requirement);
            }
            if (requirement.getFeatureFileName() == null || !requirement.getFeatureFileName().equalsIgnoreCase(candidatePath)) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private Collection<TestTag> parentRequirementsOf(TestTag requirementTag) {
        ArrayList<TestTag> matchingTags = new ArrayList<TestTag>();
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(requirementTag);
        Optional<Requirement> parent = this.parentRequirementsOf(matchingRequirement.get());
        while (parent.isPresent()) {
            matchingTags.add(parent.get().asTag());
            parent = this.parentRequirementsOf(parent.get());
        }
        return matchingTags;
    }

    private Optional<Requirement> parentRequirementsOf(Requirement matchingRequirement) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (!requirement.getChildren().contains(matchingRequirement)) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private List<String> stripStorySuffixFrom(List<String> pathElements) {
        if (!pathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(pathElements))) {
            return this.dropLastElement(pathElements);
        }
        return pathElements;
    }

    private List<String> dropLastElement(List<String> pathElements) {
        ArrayList strippedPathElements = Lists.newArrayList(pathElements);
        strippedPathElements.remove(pathElements.size() - 1);
        return strippedPathElements;
    }

    private Optional<Requirement> getMatchingRequirementFor(TestTag storyOrFeatureTag) {
        return AllRequirements.in(this.getRequirements()).stream().filter(requirement -> requirement.asTag().isAsOrMoreSpecificThan(storyOrFeatureTag)).findFirst();
    }

    private Optional<TestTag> getMatchingRequirementTagsFor(TestTag storyOrFeatureTag) {
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(storyOrFeatureTag);
        return matchingRequirement.map(Requirement::asTag);
    }

    private Optional<TestTag> storyOrFeatureDescribedIn(List<String> storyPathElements) {
        if (!storyPathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(storyPathElements))) {
            String storyName = (String)Lists.reverse(storyPathElements).get(1);
            String storyParent = this.parentElement(storyPathElements);
            String qualifiedName = storyParent == null ? NameConverter.humanize(storyName) : NameConverter.humanize(storyParent).trim() + "/" + NameConverter.humanize(storyName);
            TestTag storyTag = TestTag.withName(qualifiedName).andType(this.last(storyPathElements));
            return Optional.of(storyTag);
        }
        return Optional.empty();
    }

    private String parentElement(List<String> storyPathElements) {
        return storyPathElements.size() > 2 ? (String)Lists.reverse(storyPathElements).get(2) : null;
    }

    private String last(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public com.google.common.base.Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        return this.firstRequirementFoundIn(this.parentRequirementFromPackagePath(testOutcome), this.requirementWithMatchingParentId(testOutcome), this.requirementWithMatchingPath(testOutcome), this.featureTagRequirementIn(testOutcome), this.mostSpecificTagRequirementFor(testOutcome));
    }

    private com.google.common.base.Optional<Requirement> featureTagRequirementIn(TestOutcome testOutcome) {
        List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
        return this.lastRequirementFrom(storyPathElements);
    }

    private com.google.common.base.Optional<Requirement> parentRequirementFromPackagePath(TestOutcome testOutcome) {
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
            return this.lastRequirementFrom(storyPathElements);
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<Requirement> mostSpecificTagRequirementFor(TestOutcome testOutcome) {
        com.google.common.base.Optional<Requirement> mostSpecificRequirement = com.google.common.base.Optional.absent();
        int currentSpecificity = -1;
        for (TestTag tag : testOutcome.getTags()) {
            int specificity;
            com.google.common.base.Optional<Requirement> matchingRequirement = this.getRequirementFor(tag);
            if (!matchingRequirement.isPresent() || currentSpecificity >= (specificity = this.requirementsConfiguration.getRequirementTypes().indexOf(((Requirement)matchingRequirement.get()).getType()))) continue;
            currentSpecificity = specificity;
            mostSpecificRequirement = matchingRequirement;
        }
        return mostSpecificRequirement;
    }

    private com.google.common.base.Optional<Requirement> requirementWithMatchingPath(TestOutcome testOutcome) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (requirement.getFeatureFileName() == null || testOutcome.getPath() == null || !Paths.get(testOutcome.getPath(), new String[0]).equals(Paths.get(requirement.getFeatureFileName(), new String[0]))) continue;
            return com.google.common.base.Optional.of((Object)requirement);
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<Requirement> requirementWithMatchingParentId(TestOutcome testOutcome) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (requirement.getId() == null || testOutcome.getParentId() == null || !requirement.getId().equals(testOutcome.getParentId())) continue;
            return com.google.common.base.Optional.of((Object)requirement);
        }
        return com.google.common.base.Optional.absent();
    }

    @Override
    public com.google.common.base.Optional<Requirement> getRequirementFor(TestTag testTag) {
        for (Requirement requirement : AllRequirements.in(this.getRequirements())) {
            if (!requirement.getName().equalsIgnoreCase(testTag.getName()) || !requirement.getType().equalsIgnoreCase(testTag.getType())) continue;
            return com.google.common.base.Optional.of((Object)requirement);
        }
        return com.google.common.base.Optional.absent();
    }

    private com.google.common.base.Optional<Requirement> lastRequirementFrom(List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return com.google.common.base.Optional.absent();
        }
        return this.lastRequirementMatchingPath(this.getRequirements(), storyPathElements);
    }

    private com.google.common.base.Optional<Requirement> lastRequirementMatchingPath(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return com.google.common.base.Optional.absent();
        }
        com.google.common.base.Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (!matchingRequirement.isPresent()) {
            return com.google.common.base.Optional.absent();
        }
        if (this.tail(storyPathElements).isEmpty()) {
            return matchingRequirement;
        }
        List<Requirement> childRequrements = ((Requirement)matchingRequirement.get()).getChildren();
        return this.lastRequirementMatchingPath(childRequrements, this.tail(storyPathElements));
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return NO_TEST_TAGS;
        }
        com.google.common.base.Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (matchingRequirement.isPresent()) {
            TestTag thisTag = ((Requirement)matchingRequirement.get()).asTag();
            List<TestTag> remainingTags = this.getMatchingCapabilities(((Requirement)matchingRequirement.get()).getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return NO_TEST_TAGS;
    }

    private List<String> stripRootFrom(List<String> storyPathElements) {
        return RequirementsPath.stripRootFromPath(this.rootDirectory, storyPathElements);
    }

    private String stripRootPathFrom(String testOutcomePath) {
        String rootPath = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private com.google.common.base.Optional<Requirement> findMatchingRequirementIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(Inflector.getInstance().underscore(storyPathElement, new char[0]), new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement) && !storyPathElement.equalsIgnoreCase(FilenameUtils.removeExtension((String)requirement.getFeatureFileName())) && !storyPathElement.equalsIgnoreCase(requirement.getName())) continue;
            return com.google.common.base.Optional.of((Object)requirement);
        }
        return com.google.common.base.Optional.absent();
    }

    private List<Requirement> loadCapabilitiesFrom(File[] requirementDirectories) {
        return Arrays.stream(requirementDirectories).map(this::readRequirementFrom).collect(Collectors.toList());
    }

    private List<Requirement> loadStoriesFrom(File[] storyFiles) {
        return Arrays.stream(storyFiles).map(this::readRequirementsFromStoryOrFeatureFile).collect(Collectors.toList());
    }

    public Requirement readRequirementFrom(File requirementDirectory) {
        Optional<Narrative> requirementNarrative = this.narrativeReader.loadFrom(requirementDirectory, this.level);
        if (requirementNarrative.isPresent()) {
            return this.requirementWithNarrative(requirementDirectory, this.humanReadableVersionOf(requirementDirectory.getName()), requirementNarrative.get());
        }
        return this.requirementFromDirectoryName(requirementDirectory);
    }

    public Requirement readRequirementsFromStoryOrFeatureFile(File storyFile) {
        FeatureType type = this.featureTypeOf(storyFile);
        String defaultStoryName = storyFile.getName().replace(type.getExtension(), "");
        Optional<Narrative> narrative = type == FeatureType.STORY ? this.loadFromStoryFile(storyFile) : this.loadFromFeatureFile(storyFile);
        String storyName = this.storyNameFrom(narrative, type, storyFile);
        Requirement requirement = narrative.isPresent() ? this.leafRequirementWithNarrative(this.humanReadableVersionOf(storyName), storyFile.getPath(), narrative.get()).withType(type.toString()) : this.storyNamed(storyName).withType(type.toString());
        return requirement.definedInFile(storyFile);
    }

    private String storyNameFrom(Optional<Narrative> narrative, FeatureType type, File storyFile) {
        if (narrative.isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)narrative.get().getTitle().or((Object)"")))) {
            return (String)narrative.get().getTitle().get();
        }
        return storyFile.getName().replace(type.getExtension(), "");
    }

    private Optional<Narrative> loadFromStoryFile(File storyFile) {
        return this.narrativeReader.loadFromStoryFile(storyFile);
    }

    private Optional<Narrative> loadFromFeatureFile(File storyFile) {
        String explicitLocale = this.readLocaleFromFeatureFile(storyFile);
        CucumberParser parser = explicitLocale != null ? new CucumberParser(explicitLocale, this.environmentVariables) : new CucumberParser(this.environmentVariables);
        return parser.loadFeatureNarrative(storyFile);
    }

    private String readLocaleFromFeatureFile(File storyFile) {
        try {
            List featureFileLines = FileUtils.readLines((File)storyFile);
            for (String line : featureFileLines) {
                if (!line.startsWith("#") || !line.contains("language:")) continue;
                return line.substring(line.indexOf("language:") + 10).trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private FeatureType featureTypeOf(File storyFile) {
        return storyFile.getName().endsWith(".story") ? FeatureType.STORY : FeatureType.FEATURE;
    }

    private Requirement requirementFromDirectoryName(File requirementDirectory) {
        String shortName = this.humanReadableVersionOf(requirementDirectory.getName());
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withType(this.getDefaultType(this.level)).withNarrative(shortName).withChildren(children);
    }

    private Requirement storyNamed(String storyName) {
        String shortName = this.humanReadableVersionOf(storyName);
        return Requirement.named(shortName).withType(STORY_EXTENSION).withNarrative(shortName);
    }

    private Requirement leafRequirementWithNarrative(String shortName, String path, Narrative requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = (String)requirementNarrative.getCardNumber().orNull();
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        return Requirement.named(shortName).withId((String)requirementNarrative.getId().or((Object)path)).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions);
    }

    private Requirement requirementWithNarrative(File requirementDirectory, String shortName, Narrative requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = (String)requirementNarrative.getCardNumber().orNull();
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions).withChildren(children);
    }

    private List<Requirement> readChildrenFrom(File requirementDirectory) {
        String childDirectory = this.rootDirectory + "/" + requirementDirectory.getName();
        if (this.childrenExistFor(childDirectory)) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(childDirectory, this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        if (this.childrenExistFor(requirementDirectory.getPath())) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(requirementDirectory.getPath(), this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        return NO_REQUIREMENTS;
    }

    private boolean childrenExistFor(String path) {
        if (this.hasSubdirectories(path)) {
            return true;
        }
        if (this.hasFeatureOrStoryFiles(path)) {
            return true;
        }
        return this.classpathResourceExistsFor(path);
    }

    private boolean hasFeatureOrStoryFiles(String path) {
        File requirementDirectory = new File(path);
        if (requirementDirectory.isDirectory()) {
            return requirementDirectory.list(this.storyFiles()).length > 0 || requirementDirectory.list(this.featureFiles()).length > 0;
        }
        return false;
    }

    private FilenameFilter storyFiles() {
        return (dir, name) -> name.endsWith(".story");
    }

    private FilenameFilter featureFiles() {
        return (dir, name) -> name.endsWith(".feature");
    }

    private boolean classpathResourceExistsFor(String path) {
        return this.getClass().getResource(this.resourcePathFor(path)) != null;
    }

    private String resourcePathFor(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private boolean hasSubdirectories(String path) {
        File pathDirectory = new File(path);
        if (!pathDirectory.exists()) {
            return false;
        }
        for (File subdirectory : pathDirectory.listFiles()) {
            if (!subdirectory.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private String getTitleFromNarrativeOrDirectoryName(Narrative requirementNarrative, String nameIfNoNarrativePresent) {
        if (requirementNarrative.getTitle().isPresent() && StringUtils.isNotBlank((CharSequence)((CharSequence)requirementNarrative.getTitle().get()))) {
            return (String)requirementNarrative.getTitle().get();
        }
        return nameIfNoNarrativePresent;
    }

    private FileFilter thatAreFeatureDirectories() {
        return file -> !file.getName().startsWith(".") && this.storyOrFeatureFilesExistIn(file);
    }

    private boolean storyOrFeatureFilesExistIn(File directory) {
        return TheDirectoryStructure.startingAt(directory).containsFiles(this.thatAreStories(), this.thatAreNarratives());
    }

    private FileFilter thatAreStories() {
        return file -> {
            String filename = file.getName().toLowerCase();
            if (filename.startsWith("given") || filename.startsWith("precondition")) {
                return false;
            }
            return file.getName().toLowerCase().endsWith(".story") || file.getName().toLowerCase().endsWith(".feature");
        };
    }

    private FileFilter thatAreNarratives() {
        return file -> file.getName().toLowerCase().equals("narrative.txt") || file.getName().toLowerCase().equals("placeholder.txt");
    }

    private boolean isSupportedFileStoryExtension(String storyFileExtension) {
        return storyFileExtension.toLowerCase().equals(FEATURE_EXTENSION) || storyFileExtension.toLowerCase().equals(STORY_EXTENSION);
    }
}

