/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.InvalidStepsFieldException;
import net.thucydides.core.annotations.Steps;
import net.thucydides.core.reflection.FieldSetter;
import net.thucydides.core.util.Inflector;
import org.apache.commons.lang3.StringUtils;

public class StepsAnnotatedField {
    private Field field;
    private static final String NO_ANNOTATED_FIELD_ERROR = "No field annotated with @Steps was found in the test case.";

    public String getFieldName() {
        return this.field.getName();
    }

    public static List<StepsAnnotatedField> findMandatoryAnnotatedFields(Class<?> clazz) {
        List<StepsAnnotatedField> annotatedFields = StepsAnnotatedField.findOptionalAnnotatedFields(clazz);
        if (annotatedFields.isEmpty()) {
            throw new InvalidStepsFieldException(NO_ANNOTATED_FIELD_ERROR);
        }
        return annotatedFields;
    }

    public static List<StepsAnnotatedField> findOptionalAnnotatedFields(Class<?> clazz) {
        ArrayList<StepsAnnotatedField> annotatedFields = new ArrayList<StepsAnnotatedField>();
        for (Field field : Fields.of(clazz).allFields()) {
            if (!StepsAnnotatedField.fieldIsAnnotated(field)) continue;
            annotatedFields.add(new StepsAnnotatedField(field));
        }
        return annotatedFields;
    }

    private static boolean fieldIsAnnotated(Field aField) {
        Steps fieldAnnotation = StepsAnnotatedField.annotationFrom(aField);
        return fieldAnnotation != null;
    }

    private static Steps annotationFrom(Field aField) {
        Steps annotationOnField = null;
        if (StepsAnnotatedField.isFieldAnnotated(aField)) {
            annotationOnField = aField.getAnnotation(Steps.class);
        }
        return annotationOnField;
    }

    private static boolean isFieldAnnotated(Field field) {
        return StepsAnnotatedField.fieldIsAnnotatedCorrectly(field);
    }

    private static boolean fieldIsAnnotatedCorrectly(Field field) {
        return field.getAnnotation(Steps.class) != null;
    }

    protected StepsAnnotatedField(Field field) {
        this.field = field;
    }

    protected FieldSetter set(Object targetObject) {
        return new FieldSetter(this.field, targetObject);
    }

    public void setValue(Object field, Object value) {
        try {
            this.set(field).to(value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set field: " + field, e);
        }
    }

    public boolean isInstantiated(Object testCase) {
        try {
            this.field.setAccessible(true);
            Object fieldValue = this.field.get(testCase);
            return fieldValue != null;
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set @Steps field: " + this.field, e);
        }
    }

    public Class<?> getFieldClass() {
        return this.field.getType();
    }

    public boolean isSharedInstance() {
        return this.field.getAnnotation(Steps.class).shared();
    }

    public boolean isUniqueInstance() {
        return this.field.getAnnotation(Steps.class).uniqueInstance();
    }

    public Optional<String> actor() {
        String nameValue = this.field.getAnnotation(Steps.class).actor();
        if (StringUtils.isBlank((CharSequence)nameValue)) {
            return Optional.empty();
        }
        return Optional.of(nameValue);
    }

    public void assignActorNameIn(Object steps) {
        String actorName = this.actor().orElse(this.humanReadable(this.getFieldName()));
        if (StringUtils.isNotBlank((CharSequence)actorName)) {
            this.actorFieldIn(steps).ifPresent(field -> this.assignValueToField((Field)field, steps, actorName));
        }
    }

    private String humanReadable(String fieldName) {
        return new Inflector().of(fieldName).asATitle().toString();
    }

    private void assignValueToField(Field field, Object steps, String value) {
        field.setAccessible(true);
        try {
            field.set(steps, value);
        }
        catch (IllegalAccessException e) {
            throw new InvalidStepsFieldException("Could not access or set name field: " + field, e);
        }
    }

    private Optional<Field> actorFieldIn(Object steps) {
        return Fields.of(steps.getClass()).allFields().stream().filter(field -> field.getName().equals("actor") && field.getType().equals(String.class)).findFirst();
    }
}

