/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.util;

import net.thucydides.core.util.Inflector;

public class Inflection {
    private static final int DEFAULT_PLURAL_COUNT = 2;
    private String word;
    private int pluralCount;
    private final Inflector inflector;

    Inflection(String word, Inflector inflector) {
        this(word, 2, inflector);
    }

    Inflection(String word, int pluralCount, Inflector inflector) {
        this.word = word;
        this.pluralCount = pluralCount;
        this.inflector = inflector;
    }

    public String toString() {
        return this.word;
    }

    public Inflection inPluralForm() {
        this.word = this.inflector.pluralize(this.word, this.pluralCount);
        return this;
    }

    public Inflection inSingularForm() {
        this.word = this.inflector.singularize(this.word);
        return this;
    }

    public Inflection startingWithACapital() {
        this.word = this.inflector.capitalize(this.word);
        return this;
    }

    public Inflection inHumanReadableForm() {
        this.word = this.inflector.humanize(this.inflector.underscore(this.word, new char[0]), new String[0]);
        return this;
    }

    public Inflection withUnderscores() {
        this.word = this.inflector.underscore(this.word, new char[0]);
        return this;
    }

    public Inflection asATitle() {
        this.word = this.inflector.titleCase(this.word, new String[0]);
        return this;
    }
}

