/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import java.util.Collection;
import java.util.List;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.requirements.classpath.ChildElementAdder;
import net.thucydides.core.requirements.classpath.NarrativeTitle;
import net.thucydides.core.requirements.classpath.PackageInfoClass;
import net.thucydides.core.requirements.classpath.PackageInfoNarrative;
import net.thucydides.core.requirements.classpath.PathElements;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.util.NameConverter;

public class NonLeafRequirementsAdder {
    private final String path;
    private final Requirement leafRequirement;
    private final String rootPackage;
    private final int requirementsDepth;
    protected final RequirementsConfiguration requirementsConfiguration;

    public NonLeafRequirementsAdder(String path, String rootPackage, int requirementsDepth, Requirement leafRequirement) {
        this.path = path;
        this.rootPackage = rootPackage;
        this.leafRequirement = leafRequirement;
        this.requirementsConfiguration = new RequirementsConfiguration(ConfiguredEnvironment.getEnvironmentVariables());
        this.requirementsDepth = requirementsDepth;
    }

    public void to(Collection<Requirement> allRequirements) {
        int startFromRequirementLevel;
        List<String> parentElements = PackageInfoClass.isDefinedIn(this.path) ? PathElements.allButLast(PathElements.allButLast(PathElements.elementsOf(this.path, this.rootPackage))) : PathElements.allButLast(PathElements.elementsOf(this.path, this.rootPackage));
        int level = startFromRequirementLevel = this.getRequirementTypes().size() - this.requirementsDepth;
        Requirement parent = null;
        StringBuilder fullPath = new StringBuilder(this.rootPackage);
        for (String pathElement : parentElements) {
            Requirement nextRequirement;
            String parentName;
            String type = this.requirementsConfiguration.getRequirementType(level++);
            fullPath.append(".").append(pathElement);
            String string = parentName = parent != null ? parent.getName() : null;
            if (this.requirementExistsCalled(NameConverter.humanize(pathElement), allRequirements)) {
                nextRequirement = this.requirementCalled(NameConverter.humanize(pathElement), allRequirements).withParent(parentName);
            } else {
                String narrativeText = (String)PackageInfoNarrative.text().definedInPath(fullPath.toString()).or((Object)NarrativeTitle.definedIn(fullPath.toString(), type));
                String narrativeType = (String)PackageInfoNarrative.type().definedInPath(fullPath.toString()).or((Object)type);
                nextRequirement = Requirement.named(NameConverter.humanize(pathElement)).withType(narrativeType).withNarrative(narrativeText).withParent(parentName);
                allRequirements.add(nextRequirement);
            }
            if (parent != null) {
                ChildElementAdder.addChild(nextRequirement).toParent(parent).in(allRequirements);
            }
            parent = nextRequirement;
        }
        ChildElementAdder.addChild(this.leafRequirement).toParent(parent).in(allRequirements);
    }

    protected List<String> getRequirementTypes() {
        return this.requirementsConfiguration.getRequirementTypes();
    }

    private boolean requirementExistsCalled(String name, Collection<Requirement> allRequirements) {
        return this.requirementCalled(name, allRequirements) != null;
    }

    private Requirement requirementCalled(String name, Collection<Requirement> allRequirements) {
        for (Requirement requirement : allRequirements) {
            if (!requirement.getName().equals(name)) continue;
            return requirement;
        }
        return null;
    }

    public static NonLeafRequirementsAdderBuilder addParentsOf(Requirement leafRequirement) {
        return new NonLeafRequirementsAdderBuilder(leafRequirement);
    }

    public static class NonLeafRequirementsAdderBuilder {
        private Requirement leafRequirement;
        private String path;
        private int requirementsDepth = 0;

        public NonLeafRequirementsAdderBuilder(Requirement leafRequirement) {
            this.leafRequirement = leafRequirement;
        }

        public NonLeafRequirementsAdder startingAt(String rootPackage) {
            return new NonLeafRequirementsAdder(this.path, rootPackage, this.requirementsDepth, this.leafRequirement);
        }

        public NonLeafRequirementsAdderBuilder in(String path) {
            this.path = path;
            return this;
        }

        public NonLeafRequirementsAdderBuilder withAMaximumRequirementsDepthOf(int requirementsDepth) {
            this.requirementsDepth = requirementsDepth;
            return this;
        }
    }
}

