/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.OutcomeCounter;
import net.thucydides.core.model.Release;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestType;
import net.thucydides.core.releases.ReleaseManager;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.ExcludedUnrelatedRequirementTypes;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementOutcome;
import net.thucydides.core.requirements.reports.RequirementsOutcomesOfTypeCache;
import net.thucydides.core.requirements.reports.RequirementsOverview;
import net.thucydides.core.requirements.reports.RequirementsPercentageFormatter;
import net.thucydides.core.requirements.reports.RequirementsProportionCounter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsOutcomes {
    private final List<RequirementOutcome> requirementOutcomes;
    private final TestOutcomes testOutcomes;
    private final Optional<Requirement> parentRequirement;
    private final EnvironmentVariables environmentVariables;
    private final IssueTracking issueTracking;
    private final List<? extends RequirementsTagProvider> requirementsTagProviders;
    private final ReleaseManager releaseManager;
    private final ReportNameProvider reportNameProvider;
    List<RequirementOutcome> flattenedRequirementOutcomes = null;
    public static final Integer DEFAULT_TESTS_PER_REQUIREMENT = 4;
    private final Map<String, Integer> totalCountCache = new ConcurrentHashMap<String, Integer>();
    RequirementsOutcomesOfTypeCache requirementsOfTypeCache = new RequirementsOutcomesOfTypeCache(this);

    public RequirementsOutcomes(List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider) {
        this(null, requirements, testOutcomes, issueTracking, environmentVariables, requirementsTagProviders, reportNameProvider);
    }

    public RequirementsOutcomes(Requirement parentRequirement, List<Requirement> requirements, TestOutcomes testOutcomes, IssueTracking issueTracking, EnvironmentVariables environmentVariables, List<? extends RequirementsTagProvider> requirementsTagProviders, ReportNameProvider reportNameProvider) {
        this.testOutcomes = testOutcomes;
        this.parentRequirement = Optional.fromNullable((Object)parentRequirement);
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.requirementOutcomes = this.buildRequirementOutcomes(requirements);
        this.reportNameProvider = reportNameProvider;
        this.releaseManager = new ReleaseManager(environmentVariables, reportNameProvider);
    }

    RequirementsOutcomes(ReportNameProvider reportNameProvider, List<RequirementOutcome> requirementOutcomes, TestOutcomes testOutcomes, Optional<Requirement> parentRequirement, EnvironmentVariables environmentVariables, IssueTracking issueTracking, List<? extends RequirementsTagProvider> requirementsTagProviders, ReleaseManager releaseManager) {
        this.reportNameProvider = reportNameProvider;
        this.requirementOutcomes = requirementOutcomes;
        this.testOutcomes = testOutcomes;
        this.parentRequirement = parentRequirement;
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
        this.requirementsTagProviders = requirementsTagProviders;
        this.releaseManager = releaseManager;
    }

    private List<RequirementOutcome> buildRequirementOutcomes(List<Requirement> requirements) {
        List distinctRequirements = requirements.stream().distinct().collect(Collectors.toList());
        return distinctRequirements.parallelStream().map(requirement -> this.requirementOutcomeFor((Requirement)requirement)).collect(Collectors.toList());
    }

    private RequirementOutcome requirementOutcomeFor(Requirement requirement) {
        TestOutcomes outcomesForRequirement = this.testOutcomes.forRequirement(requirement);
        long requirementsWithoutTests = this.countRequirementsWithoutTestsIn(requirement);
        long estimatedUnimplementedTests = requirementsWithoutTests * (long)this.estimatedTestsPerRequirement();
        return new RequirementOutcome(requirement, outcomesForRequirement, requirementsWithoutTests, estimatedUnimplementedTests, this.issueTracking);
    }

    public String getOverview() {
        if (this.getParentRequirement().isPresent()) {
            return this.getNestedOverviewFrom((Requirement)this.getParentRequirement().get());
        }
        return RequirementsOverview.withEnvironmentVariables(this.environmentVariables).asRenderedHtml();
    }

    private String getNestedOverviewFrom(Requirement parentRequirement) {
        if (StringUtils.isEmpty((CharSequence)parentRequirement.getPath())) {
            return RequirementsOverview.withEnvironmentVariables(this.environmentVariables).asRenderedHtml();
        }
        return RequirementsOverview.withEnvironmentVariables(this.environmentVariables).withRelativePath(parentRequirement.getPath()).asRenderedHtml();
    }

    public RequirementsOutcomes requirementsOfType(String type) {
        return this.requirementsOfTypeCache.byType(type);
    }

    public RequirementsOutcomes ofType(String type) {
        ArrayList<Requirement> matchingRequirements = new ArrayList<Requirement>();
        ArrayList matchingTests = new ArrayList();
        this.getFlattenedRequirementOutcomes().stream().filter(requirementOutcome -> requirementOutcome.getRequirement().getType().equalsIgnoreCase(type)).forEach(requirementOutcome -> {
            matchingRequirements.add(requirementOutcome.getRequirement());
            matchingTests.addAll(requirementOutcome.getTestOutcomes().getOutcomes());
        });
        return new RequirementsOutcomes(matchingRequirements, TestOutcomes.of(matchingTests), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
    }

    private long countRequirementsWithoutTestsIn(Requirement rootRequirement) {
        return this.getFlattenedRequirements(rootRequirement).stream().filter(requirement -> this.testOutcomes.forRequirement((Requirement)requirement).getTotal() == 0).count();
    }

    public int getFlattenedRequirementCount() {
        if (this.totalIsCachedFor("FlattenedRequirementCount")) {
            return this.cachedTotalOf("FlattenedRequirementCount");
        }
        int requirementCount = this.requirementOutcomes.stream().mapToInt(RequirementOutcome::getFlattenedRequirementCount).sum();
        return this.cachedTotal("FlattenedRequirementCount", requirementCount);
    }

    private int cachedTotal(String key, int total) {
        this.totalCountCache.put(key, total);
        return total;
    }

    private int cachedTotalOf(String key) {
        return this.totalCountCache.get(key);
    }

    private boolean totalIsCachedFor(String key) {
        return this.totalCountCache.containsKey(key);
    }

    private List<Requirement> getFlattenedRequirements(Requirement rootRequirement) {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        flattenedRequirements.add(rootRequirement);
        flattenedRequirements.addAll(rootRequirement.getNestedChildren());
        return flattenedRequirements;
    }

    public Optional<Requirement> getParentRequirement() {
        return this.parentRequirement;
    }

    public Optional<Requirement> getGrandparentRequirement() {
        if (!this.parentRequirement.isPresent()) {
            return Optional.absent();
        }
        if (StringUtils.isEmpty((CharSequence)((Requirement)this.parentRequirement.get()).getParent())) {
            return Optional.absent();
        }
        return this.parentRequirementOf((Requirement)this.parentRequirement.get());
    }

    private Optional<Requirement> parentRequirementOf(Requirement requirement) {
        for (RequirementsTagProvider requirementsTagProvider : this.requirementsTagProviders) {
            if (!requirementsTagProvider.getParentRequirementOf(requirement).isPresent()) continue;
            return requirementsTagProvider.getParentRequirementOf(requirement);
        }
        return Optional.absent();
    }

    public int getRequirementCount() {
        return this.requirementOutcomes.size();
    }

    public List<RequirementOutcome> getRequirementOutcomes() {
        return ImmutableList.copyOf(this.requirementOutcomes);
    }

    public String getType() {
        if (this.requirementOutcomes.isEmpty()) {
            return "requirement";
        }
        return this.requirementOutcomes.get(0).getRequirement().getType();
    }

    public String getChildrenType() {
        return this.typeOfFirstChildPresent();
    }

    public List<String> getTypes() {
        return this.getAllRequirements().stream().map(Requirement::getType).distinct().collect(Collectors.toList());
    }

    private String typeOfFirstChildPresent() {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (outcome.getRequirement().getChildren().isEmpty()) continue;
            Requirement firstChildRequirement = outcome.getRequirement().getChildren().get(0);
            return firstChildRequirement.getType();
        }
        return null;
    }

    public TestOutcomes getTestOutcomes() {
        return this.testOutcomes;
    }

    public String toString() {
        return "RequirementsOutcomes{requirementOutcomes=" + this.requirementOutcomes + ", parentRequirement=" + this.parentRequirement + '}';
    }

    public int getCompletedRequirementsCount() {
        if (this.totalIsCachedFor("CompletedRequirementsCount")) {
            return this.cachedTotalOf("CompletedRequirementsCount");
        }
        int completedRequirements = 0;
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.isComplete()) continue;
            ++completedRequirements;
        }
        return this.cachedTotal("CompletedRequirementsCount", completedRequirements);
    }

    public int getUnsuccessfulRequirementsCount() {
        return this.getErrorRequirementsCount() + this.getFailingRequirementsCount() + this.getCompromisedRequirementsCount();
    }

    public int getErrorRequirementsCount() {
        if (this.totalIsCachedFor("ErrorRequirementsCount")) {
            return this.cachedTotalOf("ErrorRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isError).count();
        return this.cachedTotal("ErrorRequirementsCount", matchingRequirements);
    }

    public int getFailingRequirementsCount() {
        if (this.totalIsCachedFor("FailingRequirementsCount")) {
            return this.cachedTotalOf("FailingRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isFailure).count();
        return this.cachedTotal("FailingRequirementsCount", matchingRequirements);
    }

    public int getPendingRequirementsCount() {
        if (this.totalIsCachedFor("PendingRequirementsCount")) {
            return this.cachedTotalOf("PendingRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isPending).count();
        return this.cachedTotal("PendingRequirementsCount", matchingRequirements);
    }

    public int getCompromisedRequirementsCount() {
        if (this.totalIsCachedFor("CompromisedRequirementsCount")) {
            return this.cachedTotalOf("CompromisedRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isCompromised).count();
        return this.cachedTotal("CompromisedRequirementsCount", matchingRequirements);
    }

    public int getIgnoredRequirementsCount() {
        if (this.totalIsCachedFor("IgnoredRequirementsCount")) {
            return this.cachedTotalOf("IgnoredRequirementsCount");
        }
        int matchingRequirements = (int)this.requirementOutcomes.stream().filter(RequirementOutcome::isIgnored).count();
        return this.cachedTotal("IgnoredRequirementsCount", matchingRequirements);
    }

    public int getRequirementsWithoutTestsCount() {
        if (this.totalIsCachedFor("RequirementsWithoutTestsCount")) {
            return this.cachedTotalOf("RequirementsWithoutTestsCount");
        }
        int requirementsWithNoTests = 0;
        for (Requirement requirement : this.getTopLevelRequirements()) {
            if (this.testsRecordedFor(requirement) || this.isPending(requirement)) continue;
            ++requirementsWithNoTests;
        }
        return this.cachedTotal("IgnoredRequirementsCount", requirementsWithNoTests);
    }

    private boolean isPending(Requirement requirement) {
        for (RequirementOutcome requirementOutcome : this.requirementOutcomes) {
            if (!requirementOutcome.getRequirement().equals(requirement) || !requirementOutcome.isPending()) continue;
            return true;
        }
        return false;
    }

    private boolean testsRecordedFor(Requirement requirement) {
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            if (!outcome.testsRequirement(requirement) || outcome.getTestCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<Requirement> getAllRequirements() {
        ArrayList<Requirement> allRequirements = new ArrayList<Requirement>();
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            this.addFlattenedRequirements(outcome.getRequirement(), allRequirements);
        }
        return allRequirements;
    }

    private List<Requirement> getTopLevelRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (RequirementOutcome outcome : this.requirementOutcomes) {
            requirements.add(outcome.getRequirement());
        }
        return requirements;
    }

    public int getTotalRequirements() {
        return this.getAllRequirements().size();
    }

    private void addFlattenedRequirements(Requirement requirement, List<Requirement> allRequirements) {
        allRequirements.add(requirement);
        for (Requirement child : requirement.getChildren()) {
            this.addFlattenedRequirements(child, allRequirements);
        }
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes() {
        if (this.flattenedRequirementOutcomes == null) {
            this.flattenedRequirementOutcomes = this.getFlattenedRequirementOutcomes(this.requirementOutcomes);
        }
        return this.flattenedRequirementOutcomes;
    }

    public List<RequirementOutcome> getFlattenedRequirementOutcomes(List<RequirementOutcome> outcomes) {
        HashSet flattenedOutcomes = Sets.newHashSet();
        for (RequirementOutcome requirementOutcome : outcomes) {
            flattenedOutcomes.add(requirementOutcome);
            for (Requirement requirement : requirementOutcome.getRequirement().getChildren()) {
                TestOutcomes testOutcomesForRequirement = requirementOutcome.getTestOutcomes().forRequirement(requirement);
                flattenedOutcomes.add(new RequirementOutcome(requirement, testOutcomesForRequirement, this.issueTracking));
                List<Requirement> childRequirements = requirement.getChildren();
                RequirementsOutcomes childOutcomes = new RequirementsOutcomes(childRequirements, testOutcomesForRequirement, this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
                flattenedOutcomes.addAll(this.getFlattenedRequirementOutcomes(childOutcomes.getRequirementOutcomes()));
            }
        }
        return ImmutableList.copyOf((Collection)flattenedOutcomes);
    }

    public OutcomeCounter getTotal() {
        return this.count(TestType.ANY);
    }

    public OutcomeCounter count(TestType testType) {
        return new OutcomeCounter(testType, this.getTestOutcomes());
    }

    public OutcomeCounter count(String testType) {
        return this.count(TestType.valueOf(testType.toUpperCase()));
    }

    public int getTotalTestCount() {
        return this.testOutcomes.getTotal();
    }

    public RequirementsPercentageFormatter getFormattedPercentage() {
        return new RequirementsPercentageFormatter(this.getProportion());
    }

    public RequirementsPercentageFormatter getFormattedPercentage(String testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    public RequirementsPercentageFormatter getFormattedPercentage(TestType testType) {
        return new RequirementsPercentageFormatter(this.proportionOf(testType));
    }

    private int totalEstimatedAndImplementedTests() {
        int totalImplementedTests = this.getTotalTestCount();
        return totalImplementedTests + this.getEstimatedUnimplementedTests();
    }

    public int getEstimatedUnimplementedTests() {
        return this.getRequirementsWithoutTestsCount() * this.estimatedTestsPerRequirement();
    }

    private int estimatedTestsPerRequirement() {
        return ThucydidesSystemProperty.THUCYDIDES_ESTIMATED_TESTS_PER_REQUIREMENT.integerFrom(this.environmentVariables, DEFAULT_TESTS_PER_REQUIREMENT);
    }

    public RequirementsProportionCounter getProportion() {
        return this.proportionOf(TestType.ANY);
    }

    public RequirementsProportionCounter proportionOf(String testType) {
        return this.proportionOf(TestType.valueOf(testType.toUpperCase()));
    }

    public RequirementsProportionCounter proportionOf(TestType testType) {
        return new RequirementsProportionCounter(testType, this.testOutcomes, this.totalEstimatedAndImplementedTests());
    }

    public RequirementsOutcomes getReleasedRequirementsFor(Release release) {
        Set<Requirement> matchingRequirements = new HashSet<Requirement>();
        HashSet<TestOutcome> matchingTestOutcomes = new HashSet<TestOutcome>();
        List<RequirementOutcome> requirementOutcomes = this.releaseManager.enrichRequirementsOutcomesWithReleaseTags(this.getRequirementOutcomes());
        for (RequirementOutcome outcome : requirementOutcomes) {
            List<TestOutcome> outcomesForRelease;
            Set<String> releaseVersions = outcome.getReleaseVersions();
            if (!releaseVersions.contains(release.getName()) || (outcomesForRelease = this.outcomesForRelease(outcome.getTestOutcomes().getOutcomes(), release.getName())).isEmpty()) continue;
            matchingTestOutcomes.addAll(outcomesForRelease);
            matchingRequirements.add(outcome.getRequirement());
        }
        matchingRequirements = this.removeRequirementsWithoutTestsFrom(matchingRequirements);
        return new RequirementsOutcomes(Lists.newArrayList(matchingRequirements), TestOutcomes.of(matchingTestOutcomes), this.issueTracking, this.environmentVariables, this.requirementsTagProviders, this.reportNameProvider).withoutUnrelatedRequirements();
    }

    private Set<Requirement> removeRequirementsWithoutTestsFrom(Collection<Requirement> requirements) {
        HashSet<Requirement> prunedRequirements = new HashSet<Requirement>();
        for (Requirement requirement : requirements) {
            if (!this.testsExistFor(requirement)) continue;
            Set<Requirement> prunedChildren = this.removeRequirementsWithoutTestsFrom(requirement.getChildren());
            prunedRequirements.add(requirement.withChildren(new ArrayList<Requirement>(prunedChildren)));
        }
        return prunedRequirements;
    }

    private boolean testsExistFor(Requirement requirement) {
        return !this.getTestOutcomes().forRequirement(requirement).getOutcomes().isEmpty();
    }

    private List<TestOutcome> outcomesForRelease(List<? extends TestOutcome> outcomes, String releaseName) {
        this.releaseManager.enrichOutcomesWithReleaseTags(outcomes);
        return outcomes.stream().filter(outcome -> outcome.getVersions().contains(releaseName)).collect(Collectors.toList());
    }

    public RequirementsOutcomes withoutUnrelatedRequirements() {
        if (StringUtils.isEmpty((CharSequence)ThucydidesSystemProperty.THUCYDIDES_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE.from(this.environmentVariables))) {
            return this;
        }
        return new RequirementsOutcomes(this.reportNameProvider, this.pruned(this.requirementOutcomes), this.testOutcomes, this.parentRequirement, this.environmentVariables, this.issueTracking, this.requirementsTagProviders, this.releaseManager);
    }

    private List<RequirementOutcome> pruned(List<RequirementOutcome> requirementOutcomes) {
        return requirementOutcomes.stream().filter(requirementOutcome -> !this.shouldPrune((RequirementOutcome)requirementOutcome)).map(requirementOutcome -> requirementOutcome.withoutUnrelatedRequirements()).distinct().collect(Collectors.toList());
    }

    public boolean shouldPrune(RequirementOutcome requirementOutcome) {
        return requirementOutcome.getTestCount() == 0 && ExcludedUnrelatedRequirementTypes.definedIn(this.environmentVariables).excludeUntestedRequirementOfType(requirementOutcome.getRequirement().getType());
    }
}

