/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import net.serenitybdd.core.IgnoredStepException;
import net.serenitybdd.core.PendingStepException;
import net.serenitybdd.core.Serenity;
import net.serenitybdd.core.SkipNested;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.steps.HasCustomFieldValues;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.annotations.Pending;
import net.thucydides.core.annotations.Step;
import net.thucydides.core.annotations.StepGroup;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.stacktrace.StackTraceSanitizer;
import net.thucydides.core.steps.AnnotatedStepDescription;
import net.thucydides.core.steps.DefaultValue;
import net.thucydides.core.steps.DryRunMethodRunner;
import net.thucydides.core.steps.ErrorConvertor;
import net.thucydides.core.steps.ExecutedStepDescription;
import net.thucydides.core.steps.MethodErrorReporter;
import net.thucydides.core.steps.MethodRunner;
import net.thucydides.core.steps.NormalMethodRunner;
import net.thucydides.core.steps.StepArgumentWriter;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFailure;
import net.thucydides.core.steps.StepName;
import net.thucydides.core.steps.interception.DynamicExampleStepInterceptionListener;
import net.thucydides.core.steps.interception.StepInterceptionListener;
import net.thucydides.core.steps.service.CleanupMethodAnnotationProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.junit.internal.AssumptionViolatedException;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepInterceptor
implements MethodInterceptor,
MethodErrorReporter {
    private final Class<?> testStepClass;
    private Throwable error = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(StepInterceptor.class);
    private final EnvironmentVariables environmentVariables;
    private final List<String> cleanupMethodsAnnotations = new ArrayList<String>();
    private List<StepInterceptionListener> listeners = new ArrayList<StepInterceptionListener>();
    private final List<String> OBJECT_METHODS = Arrays.asList("toString", "equals", "hashcode", "clone", "notify", "notifyAll", "wait", "finalize", "getMetaClass");

    StepInterceptor(Class<?> testStepClass) {
        this.testStepClass = testStepClass;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
        ServiceLoader<CleanupMethodAnnotationProvider> cleanupMethodAnnotationProviders = ServiceLoader.load(CleanupMethodAnnotationProvider.class);
        for (CleanupMethodAnnotationProvider cleanupMethodAnnotationProvider : cleanupMethodAnnotationProviders) {
            this.cleanupMethodsAnnotations.addAll(cleanupMethodAnnotationProvider.getCleanupMethodAnnotations());
        }
        this.listeners.add(new DynamicExampleStepInterceptionListener());
    }

    public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = this.baseClassMethod(method, obj.getClass()) ? this.runBaseObjectMethod(obj, method, args, proxy) : this.testStepResult(obj, method, args, proxy);
        return result;
    }

    private boolean baseClassMethod(Method method, Class callingClass) {
        boolean isACoreLanguageMethod = this.OBJECT_METHODS.contains(method.getName());
        boolean methodDoesNotComeFromThisClassOrARelatedParentClass = !this.declaredInSameDomain(method, callingClass);
        return isACoreLanguageMethod || methodDoesNotComeFromThisClassOrARelatedParentClass;
    }

    private boolean declaredInSameDomain(Method method, Class callingClass) {
        return this.domainPackageOf(this.getRoot(method)).equals(this.domainPackageOf(callingClass));
    }

    private String domainPackageOf(Class callingClass) {
        Package classPackage = callingClass.getPackage();
        String classPackageName = classPackage != null ? classPackage.getName() : "";
        return this.packageDomainName(classPackageName);
    }

    private String packageDomainName(String methodPackage) {
        ArrayList packages = Lists.newArrayList((Iterable)Splitter.on((String)".").omitEmptyStrings().split((CharSequence)methodPackage));
        if (packages.size() == 0) {
            return "";
        }
        if (packages.size() == 1) {
            return (String)packages.get(0);
        }
        return (String)packages.get(0) + "." + (String)packages.get(1);
    }

    private String domainPackageOf(Method method) {
        Package methodPackage = method.getDeclaringClass().getPackage();
        String methodPackageName = methodPackage != null ? methodPackage.getName() : "";
        return this.packageDomainName(methodPackageName);
    }

    private Method getRoot(Method method) {
        try {
            method.getClass().getDeclaredField("root").setAccessible(true);
            return (Method)method.getClass().getDeclaredField("root").get(method);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return method;
        }
    }

    private Object testStepResult(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        if (!this.isATestStep(method)) {
            return this.runNormalMethod(obj, method, args, proxy);
        }
        this.listeners.forEach(listener -> listener.start(obj, method, args, proxy));
        Object result = this.runOrSkipMethod(obj, method, args, proxy);
        this.listeners.forEach(listener -> listener.end(obj, method, args, proxy));
        return result;
    }

    private Object runOrSkipMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result;
        if (this.shouldSkip(method) && !this.stepIsCalledFromCleanupMethod()) {
            result = this.skipStepMethod(obj, method, args, proxy);
        } else {
            this.notifyStepStarted(obj, method, args);
            result = this.runTestStep(obj, method, args, proxy);
        }
        return result;
    }

    private void endDynamicExampleIfPresent() {
    }

    private void startDynamicExampleIfPresent() {
    }

    private boolean stepIsCalledFromCleanupMethod() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            try {
                Method m = Class.forName(stackTraceElement.getClassName()).getMethod(stackTraceElement.getMethodName(), new Class[0]);
                if (m.getAnnotations() == null || m.getAnnotations().length <= 0) continue;
                for (Annotation a : m.getAnnotations()) {
                    if (!this.cleanupMethodsAnnotations.contains(a.toString())) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private Object skipStepMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        if ((this.aPreviousStepHasFailed() || this.testAssumptionViolated()) && !this.shouldExecuteNestedStepsAfterFailures()) {
            this.notifySkippedStepStarted(obj, method, args);
            this.notifySkippedStepFinishedFor(method, args);
            return this.appropriateReturnObject(obj, method);
        }
        this.notifySkippedStepStarted(obj, method, args);
        return this.skipTestStep(obj, method, args, proxy);
    }

    private boolean shouldExecuteNestedStepsAfterFailures() {
        return ThucydidesSystemProperty.DEEP_STEP_EXECUTION_AFTER_FAILURES.booleanFrom(this.environmentVariables, false);
    }

    private Object skipTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Exception {
        Object skippedReturnObject = this.runSkippedMethod(obj, method, args, proxy);
        this.notifyStepSkippedFor(method, args);
        LOGGER.debug("SKIPPED STEP: {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        return this.appropriateReturnObject(skippedReturnObject, obj, method);
    }

    private Object runSkippedMethod(Object obj, Method method, Object[] args, MethodProxy proxy) {
        LOGGER.trace("Running test step " + (String)StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        StepEventBus.getEventBus().temporarilySuspendWebdriverCalls();
        Object result = this.runIfNestedMethodsShouldBeRun(obj, method, args, proxy);
        StepEventBus.getEventBus().reenableWebdriverCalls();
        return result;
    }

    private Object runIfNestedMethodsShouldBeRun(Object obj, Method method, Object[] args, MethodProxy proxy) {
        Object result = null;
        try {
            if (this.shouldRunNestedMethodsIn(method)) {
                result = this.invokeMethod(obj, args, proxy);
            }
        }
        catch (Throwable anyException) {
            LOGGER.trace("Ignoring exception thrown during a skipped test", anyException);
        }
        return result;
    }

    private boolean shouldRunNestedMethodsIn(Method method) {
        return !TestAnnotations.shouldSkipNested(method) && !this.shouldSkipNestedIn(method.getDeclaringClass());
    }

    private boolean shouldSkipNestedIn(Class testStepClass) {
        return SkipNested.class.isAssignableFrom(testStepClass);
    }

    private Object appropriateReturnObject(Object returnedValue, Object obj, Method method) {
        if (returnedValue != null) {
            return returnedValue;
        }
        return this.appropriateReturnObject(obj, method);
    }

    private PrimitiveReturnType returnTypeOf(Method method) {
        Class<?> returnType = method.getReturnType();
        if (returnType == String.class) {
            return PrimitiveReturnType.STRING;
        }
        if (Long.class.isAssignableFrom(returnType) || returnType.getName().equals("long")) {
            return PrimitiveReturnType.LONG;
        }
        if (Integer.class.isAssignableFrom(returnType) || returnType.getName().equals("int")) {
            return PrimitiveReturnType.INTEGER;
        }
        if (Double.class.isAssignableFrom(returnType) || returnType.getName().equals("double")) {
            return PrimitiveReturnType.DOUBLE;
        }
        if (Float.class.isAssignableFrom(returnType) || returnType.getName().equals("float")) {
            return PrimitiveReturnType.FLOAT;
        }
        if (Boolean.class.isAssignableFrom(returnType) || returnType.getName().equals("boolean")) {
            return PrimitiveReturnType.BOOLEAN;
        }
        if (returnType.getName().equals("void")) {
            return PrimitiveReturnType.VOID;
        }
        return PrimitiveReturnType.UNSUPPORTED;
    }

    Object appropriateReturnObject(Object obj, Method method) {
        if (method.getReturnType().isAssignableFrom(obj.getClass())) {
            return obj;
        }
        if (this.returnTypeIsPrimativeFor(method)) {
            return this.primativeDefaultValueFor(method);
        }
        return this.mockedReturnObjectFor(method);
    }

    private Object mockedReturnObjectFor(Method method) {
        try {
            return Mockito.mock(method.getReturnType());
        }
        catch (RuntimeException tooHardToMockLetsJustCallItQuits) {
            return null;
        }
    }

    private boolean returnTypeIsPrimativeFor(Method method) {
        return this.returnTypeOf(method) != PrimitiveReturnType.UNSUPPORTED;
    }

    private Object primativeDefaultValueFor(Method method) {
        switch (this.returnTypeOf(method)) {
            case VOID: {
                return null;
            }
            case STRING: {
                return "";
            }
            case LONG: {
                return 0L;
            }
            case INTEGER: {
                return 0;
            }
            case FLOAT: {
                return Float.valueOf(0.0f);
            }
            case DOUBLE: {
                return 0.0;
            }
            case BOOLEAN: {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    private boolean shouldSkip(Method methodOrStep) {
        if (this.aPreviousStepHasFailed() && !this.isSoftAssert()) {
            return true;
        }
        return this.testIsPending() || this.isDryRun() || this.isPending(methodOrStep) || this.isIgnored(methodOrStep);
    }

    private boolean testIsPending() {
        return StepEventBus.getEventBus().currentTestIsSuspended();
    }

    private boolean testAssumptionViolated() {
        return StepEventBus.getEventBus().assumptionViolated();
    }

    private boolean aPreviousStepHasFailed() {
        boolean aPreviousStepHasFailed = false;
        if (StepEventBus.getEventBus().aStepInTheCurrentTestHasFailed()) {
            aPreviousStepHasFailed = true;
        }
        return aPreviousStepHasFailed;
    }

    private boolean isDryRun() {
        return StepEventBus.getEventBus().isDryRun();
    }

    private boolean isSoftAssert() {
        return StepEventBus.getEventBus().softAssertsActive();
    }

    private Object runBaseObjectMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        return this.invokeMethod(obj, args, proxy);
    }

    private Object runNormalMethod(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        Object result = DefaultValue.defaultReturnValueFor(method, obj);
        return this.withNonStepMethodRunner(method, obj.getClass()).invokeMethodAndNotifyFailures(obj, method, args, proxy, result);
    }

    private MethodRunner withNonStepMethodRunner(Method methodOrStep, Class callingClass) {
        return this.shouldRunInDryRunMode(methodOrStep, callingClass) ? new DryRunMethodRunner() : new NormalMethodRunner(this);
    }

    private boolean shouldRunInDryRunMode(Method methodOrStep, Class callingClass) {
        return (this.aPreviousStepHasFailed() || this.testIsPending() || this.isDryRun()) && this.declaredInSameDomain(methodOrStep, callingClass);
    }

    @Override
    public void reportMethodError(Throwable generalException, Object obj, Method method, Object[] args) throws Throwable {
        this.error = SerenityManagedException.detachedCopyOf(generalException);
        Throwable assertionError = ErrorConvertor.forError(this.error).convertToAssertion();
        this.notifyStepStarted(obj, method, args);
        this.notifyOfStepFailure(obj, method, args, assertionError);
    }

    private boolean isAnnotatedWithAValidStepAnnotation(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            if (!this.isAThucydidesStep(annotation) && !AnnotatedStepDescription.isACompatibleStep(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isAThucydidesStep(Annotation annotation) {
        return annotation instanceof Step || annotation instanceof StepGroup;
    }

    private boolean isATestStep(Method method) {
        return this.isAnnotatedWithAValidStepAnnotation(method);
    }

    private boolean isIgnored(Method method) {
        return TestAnnotations.isIgnored(method);
    }

    private Object runTestStep(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
        String callingClass = this.testContext();
        LOGGER.debug("STARTING STEP: {} - {}", (Object)callingClass, StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        Object result = null;
        try {
            result = this.executeTestStepMethod(obj, method, args, proxy, result);
            LOGGER.debug("STEP DONE: {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()));
        }
        catch (AssertionError failedAssertion) {
            this.error = failedAssertion;
            this.logStepFailure(obj, method, args, (Throwable)((Object)failedAssertion));
            result = this.appropriateReturnObject(obj, method);
        }
        catch (AssumptionViolatedException assumptionFailed) {
            result = this.appropriateReturnObject(obj, method);
        }
        catch (Throwable testErrorException) {
            this.error = SerenityManagedException.detachedCopyOf(testErrorException);
            this.logStepFailure(obj, method, args, ErrorConvertor.forError(this.error).convertToAssertion());
            result = this.appropriateReturnObject(obj, method);
        }
        return result;
    }

    private void logStepFailure(Object object, Method method, Object[] args, Throwable assertionError) throws Throwable {
        this.notifyOfStepFailure(object, method, args, assertionError);
        LOGGER.debug("STEP FAILED: {} - {}", StepName.fromStepAnnotationIn(method).or((Object)method.getName()), (Object)assertionError.getMessage());
    }

    private Object executeTestStepMethod(Object obj, Method method, Object[] args, MethodProxy proxy, Object result) throws Throwable {
        try {
            result = this.invokeMethod(obj, args, proxy);
            this.notifyStepFinishedFor(method, args);
        }
        catch (PendingStepException pendingStep) {
            this.notifyStepPending(pendingStep.getMessage());
        }
        catch (IgnoredStepException ignoredStep) {
            this.notifyStepIgnored(ignoredStep.getMessage());
        }
        catch (AssumptionViolatedException assumptionViolated) {
            this.notifyAssumptionViolated(assumptionViolated.getMessage());
        }
        Preconditions.checkArgument((boolean)true);
        return result;
    }

    private Object invokeMethod(Object obj, Object[] args, MethodProxy proxy) throws Throwable {
        return proxy.invokeSuper(obj, args);
    }

    private boolean isPending(Method method) {
        return method.getAnnotation(Pending.class) != null;
    }

    private void notifyStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepFinished();
    }

    private void notifySkippedStepFinishedFor(Method method, Object[] args) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private void notifyStepPending(String message) {
        StepEventBus.getEventBus().stepPending(message);
    }

    private void notifyAssumptionViolated(String message) {
        StepEventBus.getEventBus().assumptionViolated(message);
    }

    private void notifyStepIgnored(String message) {
        StepEventBus.getEventBus().stepIgnored();
    }

    private String getTestNameFrom(Method method, Object[] args) {
        if (args == null || args.length == 0) {
            return method.getName();
        }
        return this.testNameWithArguments(method, args);
    }

    private String testNameWithArguments(Method method, Object[] args) {
        StringBuilder testName = new StringBuilder(method.getName());
        testName.append(": ");
        boolean isFirst = true;
        for (Object arg : args) {
            if (!isFirst) {
                testName.append(", ");
            }
            testName.append(StepArgumentWriter.readableFormOf(arg));
            isFirst = false;
        }
        return testName.toString();
    }

    private void notifyStepSkippedFor(Method method, Object[] args) throws Exception {
        if (this.isPending(method)) {
            StepEventBus.getEventBus().stepPending();
        } else {
            StepEventBus.getEventBus().stepIgnored();
        }
    }

    private void notifyOfStepFailure(Object object, Method method, Object[] args, Throwable cause) throws Throwable {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args), args).withDisplayedFields(this.fieldValuesIn(object));
        StepFailure failure = new StepFailure(description, cause);
        StepEventBus.getEventBus().stepFailed(failure);
        if (this.shouldThrowExceptionImmediately()) {
            throw cause;
        }
    }

    private boolean shouldThrowExceptionImmediately() {
        return Serenity.shouldThrowErrorsImmediately();
    }

    private void notifyStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args), args).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().stepStarted(description);
    }

    private Map<String, Object> fieldValuesIn(Object object) {
        Map<String, Object> coreFieldValues = Fields.of(object).asMap();
        if (object instanceof HasCustomFieldValues) {
            coreFieldValues.putAll(((HasCustomFieldValues)object).getCustomFieldValues());
        }
        return coreFieldValues;
    }

    private void notifySkippedStepStarted(Object object, Method method, Object[] args) {
        ExecutedStepDescription description = ExecutedStepDescription.of(this.testStepClass, this.getTestNameFrom(method, args), args).withDisplayedFields(this.fieldValuesIn(object));
        StepEventBus.getEventBus().skippedStepStarted(description);
    }

    String testContext() {
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(new RuntimeException().getStackTrace());
        StackTraceElement[] stackTrace = stackTraceSanitizer.getSanitizedStackTrace();
        return stackTrace.length > 0 ? this.getTestContextFrom(stackTraceSanitizer.getSanitizedStackTrace()[0]) : "";
    }

    private String getTestContextFrom(StackTraceElement stackTraceElement) {
        return this.shortenedClassName(stackTraceElement.getClassName()) + "." + stackTraceElement.getMethodName();
    }

    private String shortenedClassName(String className) {
        String[] classNameElements = StringUtils.split((String)className, (String)".");
        return classNameElements[classNameElements.length - 1];
    }

    static enum PrimitiveReturnType {
        STRING,
        LONG,
        INTEGER,
        DOUBLE,
        FLOAT,
        BOOLEAN,
        VOID,
        UNSUPPORTED;

    }
}

