/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.classpath;

import com.google.common.io.Resources;
import java.io.File;
import java.util.Optional;
import net.thucydides.core.requirements.model.LoadedNarrative;
import net.thucydides.core.requirements.model.Narrative;
import org.apache.commons.lang3.StringUtils;

public class NarrativeText {
    public static String definedIn(String fullPath, String type) {
        String narrativePath = NarrativeText.asResourcePath(NarrativeText.fileSystemPathOfNarrativeInPackage(fullPath)) + ".txt";
        try {
            Optional<Narrative> narrative;
            String narrativeFilePath = Resources.getResource((String)narrativePath).getFile();
            if (new File(narrativeFilePath).exists() && (narrative = LoadedNarrative.load().fromFile(new File(narrativeFilePath), type)).isPresent()) {
                return ((String)narrative.get().getTitle().or((Object)"") + System.lineSeparator() + narrative.get().getText()).trim();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return "";
    }

    private static String asResourcePath(String path) {
        return StringUtils.replace((String)path, (String)File.separator, (String)"/");
    }

    private static String fileSystemPathOfNarrativeInPackage(String fullPath) {
        String narrativePath = fullPath + File.separator + "narrative";
        return StringUtils.replaceChars((String)narrativePath, (String)".", (String)File.separator);
    }
}

