/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.annotations.locators;

import io.appium.java_client.MobileBy;
import io.appium.java_client.pagefactory.AndroidFindAll;
import io.appium.java_client.pagefactory.AndroidFindBy;
import io.appium.java_client.pagefactory.AndroidFindBys;
import io.appium.java_client.pagefactory.iOSFindAll;
import io.appium.java_client.pagefactory.iOSFindBy;
import io.appium.java_client.pagefactory.iOSFindBys;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.serenitybdd.core.annotations.findby.How;
import net.serenitybdd.core.annotations.findby.di.CustomFindByAnnotationProviderService;
import net.thucydides.core.annotations.findby.FindBy;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.webdriver.MobilePlatform;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ByIdOrName;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.ByChained;

public class SmartAnnotations
extends Annotations {
    private Field field;
    private MobilePlatform platform;
    private CustomFindByAnnotationProviderService customFindByAnnotationProviderService;
    private static final Class<?>[] DEFAULT_ANNOTATION_METHOD_ARGUMENTS = new Class[0];
    private static final List<String> METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            List objectClassMethodNames = SmartAnnotations.getMethodNames(Object.class.getDeclaredMethods());
            this.addAll(objectClassMethodNames);
            List annotationClassMethodNames = SmartAnnotations.getMethodNames(Annotation.class.getDeclaredMethods());
            annotationClassMethodNames.removeAll(objectClassMethodNames);
            this.addAll(annotationClassMethodNames);
        }
    };

    public SmartAnnotations(Field field, MobilePlatform platform) {
        this(field, platform, (CustomFindByAnnotationProviderService)Injectors.getInjector().getInstance(CustomFindByAnnotationProviderService.class));
    }

    public SmartAnnotations(Field field, MobilePlatform platform, CustomFindByAnnotationProviderService customFindByAnnotationProviderService) {
        super(field);
        this.field = field;
        this.platform = platform;
        this.customFindByAnnotationProviderService = customFindByAnnotationProviderService;
    }

    protected void assertValidAnnotations() {
        FindBys findBys = this.field.getAnnotation(FindBys.class);
        net.serenitybdd.core.annotations.findby.FindBy myFindBy = this.field.getAnnotation(net.serenitybdd.core.annotations.findby.FindBy.class);
        FindBy myDepFindBy = this.field.getAnnotation(FindBy.class);
        if (myDepFindBy != null && myFindBy != null) {
            throw new IllegalArgumentException("Do not combine the serenitybdd and thucydides namespace. The thucydides namespace is now deprecated, so please convert.");
        }
        if (findBys != null && myDepFindBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
        if (findBys != null && myFindBy != null) {
            throw new IllegalArgumentException("If you use a '@FindBys' annotation, you must not also use a '@FindBy' annotation");
        }
    }

    public By buildBy() {
        iOSFindAll iOSFindAll2;
        iOSFindBys iOSBys;
        iOSFindBy iOSBy2;
        AndroidFindAll androidFindAll;
        AndroidFindBys androidBys;
        this.assertValidAnnotations();
        By by = null;
        AndroidFindBy androidBy = this.field.getAnnotation(AndroidFindBy.class);
        if (androidBy != null && "Android".toUpperCase().equals(this.platform.name())) {
            by = this.getMobileBy((Annotation)androidBy, SmartAnnotations.getFieldValue((Annotation)androidBy));
        }
        if ((androidBys = this.field.getAnnotation(AndroidFindBys.class)) != null && "Android".toUpperCase().equals(this.platform.name())) {
            by = this.getComplexMobileBy((Annotation[])androidBys.value(), ByChained.class);
        }
        if ((androidFindAll = this.field.getAnnotation(AndroidFindAll.class)) != null && "Android".toUpperCase().equals(this.platform.name())) {
            by = this.getComplexMobileBy((Annotation[])androidFindAll.value(), ByChained.class);
        }
        if ((iOSBy2 = this.field.getAnnotation(iOSFindBy.class)) != null && "iOS".toUpperCase().equals(this.platform.name())) {
            by = this.getMobileBy((Annotation)iOSBy2, SmartAnnotations.getFieldValue((Annotation)iOSBy2));
        }
        if ((iOSBys = this.field.getAnnotation(iOSFindBys.class)) != null && "iOS".toUpperCase().equals(this.platform.name())) {
            by = this.getComplexMobileBy((Annotation[])iOSBys.value(), ByChained.class);
        }
        if ((iOSFindAll2 = this.field.getAnnotation(iOSFindAll.class)) != null && "iOS".toUpperCase().equals(this.platform.name())) {
            by = this.getComplexMobileBy((Annotation[])iOSFindAll2.value(), ByChained.class);
        }
        net.serenitybdd.core.annotations.findby.FindBy myFindBy = this.field.getAnnotation(net.serenitybdd.core.annotations.findby.FindBy.class);
        if (by == null && myFindBy != null) {
            by = this.buildByFromFindBy(myFindBy);
        }
        FindBy myDepFindBy = this.field.getAnnotation(FindBy.class);
        if (by == null && myDepFindBy != null) {
            by = this.buildByFromFindBy(myDepFindBy);
        }
        if (by == null) {
            by = this.buildByFromCustomAnnotationProvider(this.field);
        }
        if (by == null) {
            by = super.buildBy();
        }
        if (by == null) {
            by = this.buildByFromDefault();
        }
        if (by == null) {
            throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
        }
        return by;
    }

    protected By buildByFromCustomAnnotationProvider(Field field) {
        return this.customFindByAnnotationProviderService.getCustomFindByAnnotationServices().stream().filter(annotationService -> annotationService.isAnnotatedByCustomFindByAnnotation(field)).findFirst().map(annotationService -> annotationService.buildByFromCustomFindByAnnotation(field)).orElse(null);
    }

    protected By buildByFromFindBy(net.serenitybdd.core.annotations.findby.FindBy myFindBy) {
        this.assertValidFindBy(myFindBy);
        By by = this.buildByFromShortFindBy(myFindBy);
        if (by == null) {
            by = this.buildByFromLongFindBy(myFindBy);
        }
        return by;
    }

    protected By buildByFromLongFindBy(net.serenitybdd.core.annotations.findby.FindBy myFindBy) {
        How how = myFindBy.how();
        String using = myFindBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
            case JQUERY: {
                return net.serenitybdd.core.annotations.findby.By.jquery(using);
            }
            case SCLOCATOR: {
                return net.serenitybdd.core.annotations.findby.By.sclocator(using);
            }
            case ACCESSIBILITY_ID: {
                return MobileBy.AccessibilityId((String)using);
            }
            case IOS_UI_AUTOMATION: {
                return MobileBy.IosUIAutomation((String)using);
            }
            case ANDROID_UI_AUTOMATOR: {
                return MobileBy.AndroidUIAutomator((String)using);
            }
            case IOS_CLASS_CHAIN: {
                return MobileBy.iOSClassChain((String)using);
            }
            case IOS_NS_PREDICATE_STRING: {
                return MobileBy.iOSNsPredicateString((String)using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    protected By buildByFromShortFindBy(net.serenitybdd.core.annotations.findby.FindBy myFindBy) {
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.className())) {
            return By.className((String)myFindBy.className());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.css())) {
            return By.cssSelector((String)myFindBy.css());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.id())) {
            return By.id((String)myFindBy.id());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.linkText())) {
            return By.linkText((String)myFindBy.linkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.name())) {
            return By.name((String)myFindBy.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.ngModel())) {
            return By.cssSelector((String)("*[ng-model='" + myFindBy.ngModel() + "']"));
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.partialLinkText())) {
            return By.partialLinkText((String)myFindBy.partialLinkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.tagName())) {
            return By.tagName((String)myFindBy.tagName());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.xpath())) {
            return By.xpath((String)myFindBy.xpath());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.sclocator())) {
            return net.serenitybdd.core.annotations.findby.By.sclocator(myFindBy.sclocator());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.jquery())) {
            return net.serenitybdd.core.annotations.findby.By.jquery(myFindBy.jquery());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.accessibilityId())) {
            return MobileBy.AccessibilityId((String)myFindBy.accessibilityId());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.androidUIAutomator())) {
            return MobileBy.AndroidUIAutomator((String)myFindBy.androidUIAutomator());
        }
        if (StringUtils.isNotEmpty((CharSequence)myFindBy.iOSUIAutomation())) {
            return MobileBy.IosUIAutomation((String)myFindBy.iOSUIAutomation());
        }
        return null;
    }

    private By getMobileBy(Annotation annotation, String valueName) {
        Strategies[] strategies;
        for (Strategies strategy : strategies = Strategies.values()) {
            if (!strategy.returnValueName().equals(valueName)) continue;
            return strategy.getBy(annotation);
        }
        throw new IllegalArgumentException("@" + annotation.getClass().getSimpleName() + ": There is an unknown strategy " + valueName);
    }

    private <T extends By> T getComplexMobileBy(Annotation[] annotations, Class<T> requiredByClass) {
        By[] byArray = new By[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            byArray[i] = this.getMobileBy(annotations[i], SmartAnnotations.getFieldValue(annotations[i]));
        }
        try {
            Constructor<T> c = requiredByClass.getConstructor(By[].class);
            Object[] values = new Object[]{byArray};
            return (T)((By)c.newInstance(values));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFieldValue(Annotation mobileBy) {
        Method[] values;
        for (Method value : values = SmartAnnotations.prepareAnnotationMethods(mobileBy.getClass())) {
            try {
                String strategyParameter = value.invoke((Object)mobileBy, new Object[0]).toString();
                if (!StringUtils.isNotEmpty((CharSequence)strategyParameter) || StringUtils.isNumeric((CharSequence)strategyParameter)) continue;
                return value.getName();
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException("@" + mobileBy.getClass().getSimpleName() + ": one of " + Arrays.toString(Strategies.strategyNames()) + " should be filled");
    }

    private static Method[] prepareAnnotationMethods(Class<? extends Annotation> annotation) {
        List<String> targetAnnotationMethodNamesList = SmartAnnotations.getMethodNames(annotation.getDeclaredMethods());
        targetAnnotationMethodNamesList.removeAll(METHODS_TO_BE_EXCLUDED_WHEN_ANNOTATION_IS_READ);
        Method[] result = new Method[targetAnnotationMethodNamesList.size()];
        for (String methodName : targetAnnotationMethodNamesList) {
            try {
                result[targetAnnotationMethodNamesList.indexOf((Object)methodName)] = annotation.getMethod(methodName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static List<String> getMethodNames(Method[] methods) {
        ArrayList<String> names = new ArrayList<String>();
        for (Method m : methods) {
            names.add(m.getName());
        }
        return names;
    }

    private void assertValidFindBy(net.serenitybdd.core.annotations.findby.FindBy findBy) {
        if (findBy.how() != null && findBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findBy.using())) {
            finders.add("how: " + findBy.using());
        }
        if (!"".equals(findBy.className())) {
            finders.add("class name:" + findBy.className());
        }
        if (!"".equals(findBy.css())) {
            finders.add("css:" + findBy.css());
        }
        if (!"".equals(findBy.id())) {
            finders.add("id: " + findBy.id());
        }
        if (!"".equals(findBy.linkText())) {
            finders.add("link text: " + findBy.linkText());
        }
        if (!"".equals(findBy.name())) {
            finders.add("name: " + findBy.name());
        }
        if (!"".equals(findBy.ngModel())) {
            finders.add("ngModel: " + findBy.ngModel());
        }
        if (!"".equals(findBy.partialLinkText())) {
            finders.add("partial link text: " + findBy.partialLinkText());
        }
        if (!"".equals(findBy.tagName())) {
            finders.add("tag name: " + findBy.tagName());
        }
        if (!"".equals(findBy.xpath())) {
            finders.add("xpath: " + findBy.xpath());
        }
        if (!"".equals(findBy.sclocator())) {
            finders.add("scLocator: " + findBy.sclocator());
        }
        if (!"".equals(findBy.jquery())) {
            finders.add("jquery: " + findBy.jquery());
        }
        if (!"".equals(findBy.accessibilityId())) {
            finders.add("accessibilityId: " + findBy.accessibilityId());
        }
        if (!"".equals(findBy.androidUIAutomator())) {
            finders.add("androidUIAutomator: " + findBy.androidUIAutomator());
        }
        if (!"".equals(findBy.iOSUIAutomation())) {
            finders.add("iOSUIAutomation: " + findBy.iOSUIAutomation());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
    }

    @Deprecated
    protected By buildByFromFindBy(FindBy myDepFindBy) {
        this.assertValidFindBy(myDepFindBy);
        By ans = this.buildByFromShortFindBy(myDepFindBy);
        if (ans == null) {
            ans = this.buildByFromLongFindBy(myDepFindBy);
        }
        return ans;
    }

    @Deprecated
    protected By buildByFromLongFindBy(FindBy myDepFindBy) {
        How how = myDepFindBy.how();
        String using = myDepFindBy.using();
        switch (how) {
            case CLASS_NAME: {
                return By.className((String)using);
            }
            case CSS: {
                return By.cssSelector((String)using);
            }
            case ID: {
                return By.id((String)using);
            }
            case ID_OR_NAME: {
                return new ByIdOrName(using);
            }
            case LINK_TEXT: {
                return By.linkText((String)using);
            }
            case NAME: {
                return By.name((String)using);
            }
            case PARTIAL_LINK_TEXT: {
                return By.partialLinkText((String)using);
            }
            case TAG_NAME: {
                return By.tagName((String)using);
            }
            case XPATH: {
                return By.xpath((String)using);
            }
            case JQUERY: {
                return net.serenitybdd.core.annotations.findby.By.jquery(using);
            }
            case SCLOCATOR: {
                return net.serenitybdd.core.annotations.findby.By.sclocator(using);
            }
        }
        throw new IllegalArgumentException("Cannot determine how to locate element " + this.field);
    }

    @Deprecated
    protected By buildByFromShortFindBy(FindBy myDepFindBy) {
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.className())) {
            return By.className((String)myDepFindBy.className());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.css())) {
            return By.cssSelector((String)myDepFindBy.css());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.id())) {
            return By.id((String)myDepFindBy.id());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.linkText())) {
            return By.linkText((String)myDepFindBy.linkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.name())) {
            return By.name((String)myDepFindBy.name());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.ngModel())) {
            return By.cssSelector((String)("*[ng-model='" + myDepFindBy.ngModel() + "']"));
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.partialLinkText())) {
            return By.partialLinkText((String)myDepFindBy.partialLinkText());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.tagName())) {
            return By.tagName((String)myDepFindBy.tagName());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.xpath())) {
            return By.xpath((String)myDepFindBy.xpath());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.sclocator())) {
            return net.serenitybdd.core.annotations.findby.By.sclocator(myDepFindBy.sclocator());
        }
        if (StringUtils.isNotEmpty((CharSequence)myDepFindBy.jquery())) {
            return net.serenitybdd.core.annotations.findby.By.jquery(myDepFindBy.jquery());
        }
        return null;
    }

    @Deprecated
    private void assertValidFindBy(FindBy findDepBy) {
        if (findDepBy.how() != null && findDepBy.using() == null) {
            throw new IllegalArgumentException("If you set the 'how' property, you must also set 'using'");
        }
        HashSet<String> finders = new HashSet<String>();
        if (!"".equals(findDepBy.using())) {
            finders.add("how: " + findDepBy.using());
        }
        if (!"".equals(findDepBy.className())) {
            finders.add("class name:" + findDepBy.className());
        }
        if (!"".equals(findDepBy.css())) {
            finders.add("css:" + findDepBy.css());
        }
        if (!"".equals(findDepBy.id())) {
            finders.add("id: " + findDepBy.id());
        }
        if (!"".equals(findDepBy.linkText())) {
            finders.add("link text: " + findDepBy.linkText());
        }
        if (!"".equals(findDepBy.name())) {
            finders.add("name: " + findDepBy.name());
        }
        if (!"".equals(findDepBy.ngModel())) {
            finders.add("ngModel: " + findDepBy.ngModel());
        }
        if (!"".equals(findDepBy.partialLinkText())) {
            finders.add("partial link text: " + findDepBy.partialLinkText());
        }
        if (!"".equals(findDepBy.tagName())) {
            finders.add("tag name: " + findDepBy.tagName());
        }
        if (!"".equals(findDepBy.xpath())) {
            finders.add("xpath: " + findDepBy.xpath());
        }
        if (!"".equals(findDepBy.sclocator())) {
            finders.add("scLocator: " + findDepBy.sclocator());
        }
        if (!"".equals(findDepBy.jquery())) {
            finders.add("jquery: " + findDepBy.jquery());
        }
        if (finders.size() > 1) {
            throw new IllegalArgumentException(String.format("You must specify at most one location strategy. Number found: %d (%s)", finders.size(), ((Object)finders).toString()));
        }
    }

    private static enum Strategies {
        BYUIAUTOMATOR("uiAutomator"){

            @Override
            By getBy(Annotation annotation) {
                String value = Strategies.getValue(annotation, (Strategies)this);
                if (annotation.annotationType().equals(AndroidFindBy.class)) {
                    return MobileBy.AndroidUIAutomator((String)value);
                }
                if (annotation.annotationType().equals(iOSFindBy.class)) {
                    return MobileBy.IosUIAutomation((String)value);
                }
                return super.getBy(annotation);
            }
        }
        ,
        BYACCESSABILITY("accessibility"){

            @Override
            By getBy(Annotation annotation) {
                return MobileBy.AccessibilityId((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYCLASSNAME("className"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.className((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYID("id"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.id((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYTAG("tagName"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.tagName((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYNAME("name"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.name((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYXPATH("xpath"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.xpath((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYCSS("css"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.cssSelector((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYLINKTEXT("linkText"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.linkText((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        BYPARTIALLINKTEXT("partialLinkText"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.partialLinkText((String)Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        JQUERY("jQuery"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.jquery(Strategies.getValue(annotation, (Strategies)this));
            }
        }
        ,
        SCUSING("scUsing"){

            @Override
            By getBy(Annotation annotation) {
                return net.serenitybdd.core.annotations.findby.By.sclocator(Strategies.getValue(annotation, (Strategies)this));
            }
        };

        private final String valueName;

        private String returnValueName() {
            return this.valueName;
        }

        private Strategies(String valueName) {
            this.valueName = valueName;
        }

        private static String[] strategyNames() {
            Strategies[] strategies = Strategies.values();
            String[] result = new String[strategies.length];
            int i = 0;
            for (Strategies strategy : Strategies.values()) {
                result[i] = strategy.valueName;
                ++i;
            }
            return result;
        }

        private static String getValue(Annotation annotation, Strategies strategy) {
            try {
                Method m = annotation.getClass().getMethod(strategy.valueName, DEFAULT_ANNOTATION_METHOD_ARGUMENTS);
                return m.invoke((Object)annotation, new Object[0]).toString();
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        By getBy(Annotation annotation) {
            return null;
        }
    }
}

