/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.pages;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.PageObjects;
import net.thucydides.core.annotations.Fields;
import net.thucydides.core.pages.WrongPageError;
import net.thucydides.core.steps.EnclosingClass;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.WebdriverProxyFactory;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pages
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient WebDriver driver;
    private static final Logger LOGGER = LoggerFactory.getLogger(Pages.class);
    private String defaultBaseUrl;
    private final Configuration configuration;
    private WebdriverProxyFactory proxyFactory;
    private transient boolean usePreviousPage = false;
    PageObject currentPage = null;

    public Pages(Configuration configuration) {
        this.configuration = configuration;
        this.proxyFactory = WebdriverProxyFactory.getFactory();
    }

    public Pages() {
        this(ConfiguredEnvironment.getConfiguration());
    }

    public Pages(WebDriver driver) {
        this(ConfiguredEnvironment.getConfiguration());
        this.driver = driver;
    }

    public Pages(WebDriver driver, Configuration configuration) {
        this(configuration);
        this.driver = driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    protected WebdriverProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public <T extends PageObject> T getAt(Class<T> pageObjectClass) {
        return this.getPage(pageObjectClass);
    }

    public <T extends PageObject> T getPage(Class<T> pageObjectClass) {
        T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
        ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
        return pageCandidate;
    }

    public <T extends PageObject> T get(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    public <T extends PageObject> T currentPageAt(Class<T> pageObjectClass) {
        PageObject nextPage;
        if (this.shouldUsePreviousPage(pageObjectClass)) {
            nextPage = this.currentPage;
        } else {
            T pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            ((PageObject)pageCandidate).setDefaultBaseUrl(this.getDefaultBaseUrl());
            this.openBrowserIfRequiredFor(pageCandidate);
            this.checkUrlPatterns(pageObjectClass, pageCandidate);
            this.cacheCurrentPage((PageObject)pageCandidate);
            nextPage = pageCandidate;
            nextPage.addJQuerySupport();
        }
        this.usePreviousPage = false;
        return (T)nextPage;
    }

    private <T extends PageObject> void openBrowserIfRequiredFor(T pageCandidate) {
        if (this.browserNotOpen()) {
            this.openHeadlessDriverIfNotOpen();
            pageCandidate.open();
        }
    }

    private void openHeadlessDriverIfNotOpen() {
        if (this.browserIsHeadless()) {
            this.driver.get("about:blank");
        }
    }

    private boolean browserNotOpen() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return !((WebDriverFacade)this.getDriver()).isInstantiated();
        }
        return StringUtils.isEmpty((CharSequence)this.getDriver().getCurrentUrl());
    }

    private boolean browserIsHeadless() {
        if (this.getDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getDriver()).getProxiedDriver() instanceof HtmlUnitDriver;
        }
        return this.getDriver() instanceof HtmlUnitDriver;
    }

    private <T extends PageObject> void checkUrlPatterns(Class<T> pageObjectClass, T pageCandidate) {
        String currentUrl;
        if (!pageCandidate.matchesAnyUrl() && !pageCandidate.compatibleWithUrl(currentUrl = this.getDriver().getCurrentUrl())) {
            this.thisIsNotThePageYourLookingFor(pageObjectClass);
        }
    }

    private <T extends PageObject> boolean shouldUsePreviousPage(Class<T> pageObjectClass) {
        if (!this.usePreviousPage) {
            return false;
        }
        return this.currentPageIsSameTypeAs(pageObjectClass);
    }

    private void cacheCurrentPage(PageObject newPage) {
        this.currentPage = newPage;
    }

    private <T extends PageObject> boolean currentPageIsSameTypeAs(Class<T> pageObjectClass) {
        return this.currentPage != null && this.currentPage.getClass().equals(pageObjectClass);
    }

    public boolean isCurrentPageAt(Class<? extends PageObject> pageObjectClass) {
        try {
            PageObject pageCandidate = this.getCurrentPageOfType(pageObjectClass);
            String currentUrl = this.getDriver().getCurrentUrl();
            return pageCandidate.compatibleWithUrl(currentUrl);
        }
        catch (WrongPageError e) {
            return false;
        }
    }

    private <T extends PageObject> T getCurrentPageOfType(Class<T> pageObjectClass) {
        T currentPage = null;
        try {
            currentPage = this.createFromSimpleConstructor(pageObjectClass);
            if (currentPage == null) {
                currentPage = this.createFromConstructorWithWebdriver(pageObjectClass);
            }
            if (this.hasPageFactoryProperty(currentPage)) {
                this.setPageFactory(currentPage);
            }
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("This page object does not appear have a constructor that takes a WebDriver parameter: {} ({})", pageObjectClass, (Object)e.getMessage());
            this.thisPageObjectLooksDodgy(pageObjectClass, "This page object does not appear have a constructor that takes a WebDriver parameter");
        }
        catch (InvocationTargetException e) {
            LOGGER.warn("Failed to instantiate page of type {} ({})", pageObjectClass, (Object)e.getTargetException());
            this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page (" + e.getTargetException() + ")");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to instantiate page of type {} ({})", pageObjectClass, (Object)e);
            this.thisPageObjectLooksDodgy(pageObjectClass, "Failed to instantiate page (" + e + ")");
        }
        return currentPage;
    }

    private <T extends PageObject> T createFromSimpleConstructor(Class<T> pageObjectClass) throws IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        PageObject newPage = null;
        try {
            if (this.hasDefaultConstructor(pageObjectClass)) {
                Class[] constructorArgs = new Class[]{};
                Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
                newPage = (PageObject)constructor.newInstance(new Object[0]);
                newPage.setDriver(this.driver);
            } else if (this.hasOuterClassConstructor(pageObjectClass)) {
                Constructor<T> constructor = pageObjectClass.getConstructor(pageObjectClass.getEnclosingClass());
                newPage = (PageObject)constructor.newInstance(EnclosingClass.of(pageObjectClass).newInstance());
                newPage.setDriver(this.driver);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return (T)newPage;
    }

    private <T extends PageObject> boolean hasDefaultConstructor(Class<T> pageObjectClass) {
        return Arrays.stream(pageObjectClass.getConstructors()).anyMatch(constructor -> constructor.getParameters().length == 0);
    }

    private <T extends PageObject> boolean hasOuterClassConstructor(Class<T> pageObjectClass) {
        return Arrays.stream(pageObjectClass.getConstructors()).anyMatch(constructor -> constructor.getParameters().length == 1 && constructor.getParameters()[0].getType() == pageObjectClass.getEnclosingClass());
    }

    private <T extends PageObject> T createFromConstructorWithWebdriver(Class<T> pageObjectClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class[] constructorArgs = new Class[]{WebDriver.class};
        Constructor<T> constructor = pageObjectClass.getConstructor(constructorArgs);
        return (T)((PageObject)constructor.newInstance(this.driver));
    }

    private boolean hasPageFactoryProperty(Object pageObject) {
        Optional<Field> pagesField = Fields.of(pageObject.getClass()).withName("pages");
        return pagesField.isPresent() && pagesField.get().getType() == Pages.class;
    }

    private void setPageFactory(Object pageObject) throws IllegalAccessException {
        Fields.of(pageObject.getClass()).withName("pages").ifPresent(field -> this.assignTo((Field)field, pageObject));
    }

    private void assignTo(Field pagesField, Object pageObject) {
        try {
            pagesField.setAccessible(true);
            pagesField.set(pageObject, this);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Failed to assign page object field: ", (Throwable)e);
        }
    }

    private void thisPageObjectLooksDodgy(Class<? extends PageObject> pageObjectClass, String message) {
        String errorDetails = "The page object " + pageObjectClass + " looks dodgy:\n" + message;
        throw new WrongPageError(errorDetails);
    }

    private void thisIsNotThePageYourLookingFor(Class<? extends PageObject> pageObjectClass) {
        String errorDetails = "This is not the page you're looking for: I was looking for a page compatible with " + pageObjectClass + " but I was at the URL " + this.getDriver().getCurrentUrl();
        throw new WrongPageError(errorDetails);
    }

    public String getDefaultBaseUrl() {
        String baseUrl = this.defaultBaseUrl;
        if (StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getBaseUrl())) {
            baseUrl = this.getConfiguration().getBaseUrl();
        }
        return baseUrl;
    }

    public void setDefaultBaseUrl(String defaultBaseUrl) {
        this.defaultBaseUrl = defaultBaseUrl;
    }

    public Pages onSamePage() {
        this.usePreviousPage = true;
        return this;
    }

    public static <T extends PageObject> T instrumentedPageObjectUsing(Class<T> pageObjectClass, WebDriver driver) {
        return PageObjects.usingDriver(driver).ofType(pageObjectClass);
    }
}

