/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.requirements.BaseRequirementsService;
import net.thucydides.core.requirements.FileSystemRequirementsTagProvider;
import net.thucydides.core.requirements.ReleaseProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementsTagProvider.class);
    private RequirementsTagProvider fileSystemRequirementsTagProvider;

    public FileSystemRequirementsService(String rootPath) {
        super((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
        this.fileSystemRequirementsTagProvider = new FileSystemRequirementsTagProvider(this.environmentVariables, rootPath);
    }

    @Override
    public List<Requirement> getRequirements() {
        this.requirements = this.fileSystemRequirementsTagProvider.getRequirements();
        this.requirements = this.addParentsTo(this.requirements);
        this.indexRequirements();
        LOGGER.debug("Requirements found:" + this.requirements);
        return this.requirements;
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        return NewList.of(this.fileSystemRequirementsTagProvider);
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        return Optional.empty();
    }
}

