/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import com.google.common.base.Splitter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.requirements.SearchForFilesOfType;
import net.thucydides.core.requirements.model.RequirementTypeAt;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RequirementsConfiguration {
    public static final List<String> DEFAULT_CAPABILITY_TYPES = NewList.of("capability", "feature", "story");
    protected static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private final EnvironmentVariables environmentVariables;
    private String rootRequirementsDirectory = "/";
    SearchForFilesOfType jbehaveFileMatcher;
    SearchForFilesOfType cucumberFileMatcher;

    public RequirementsConfiguration(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public List<String> getRequirementTypes() {
        String requirementTypes = ThucydidesSystemProperty.SERENITY_REQUIREMENT_TYPES.from(this.environmentVariables);
        List types = StringUtils.isNotEmpty((CharSequence)requirementTypes) ? Splitter.on((String)",").trimResults().splitToList((CharSequence)requirementTypes) : this.getDefaultCapabilityTypes();
        return types;
    }

    public String getDefaultRootDirectory() {
        if (ThucydidesSystemProperty.THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return ThucydidesSystemProperty.THUCYDIDES_ANNOTATED_REQUIREMENTS_DIR.from(this.environmentVariables);
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public List<String> getDefaultCapabilityTypes() {
        if (this.jbehaveFilesExist()) {
            return this.jbehaveCapabilityTypes();
        }
        if (this.cucumberFilesExist()) {
            return this.cucumberCapabilityTypes();
        }
        return DEFAULT_CAPABILITY_TYPES;
    }

    private List<String> jbehaveCapabilityTypes() {
        int featureDirectoryDepth = this.getJBehaveFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("story");
            }
            case 1: {
                return NewList.of("feature", "story");
            }
        }
        return NewList.of("capability", "feature", "story");
    }

    private List<String> cucumberCapabilityTypes() {
        int featureDirectoryDepth = this.getCucumberFileMatcher().get().getMaxDepth();
        switch (featureDirectoryDepth) {
            case 0: {
                return NewList.of("feature");
            }
            case 1: {
                return NewList.of("capability", "feature");
            }
        }
        return NewList.of("theme", "capability", "feature");
    }

    private Optional<SearchForFilesOfType> getJBehaveFileMatcher() {
        if (this.jbehaveFileMatcher != null) {
            return Optional.of(this.jbehaveFileMatcher);
        }
        try {
            Path root = this.findResourcePath(this.rootRequirementsDirectory + "/stories");
            if (root != null) {
                this.jbehaveFileMatcher = new SearchForFilesOfType(root, ".story");
                Files.walkFileTree(root, this.jbehaveFileMatcher);
                return Optional.of(this.jbehaveFileMatcher);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.empty();
    }

    public String getRequirementType(int level) {
        return RequirementTypeAt.level(level).in(this.getRequirementTypes());
    }

    private Path findResourcePath(String path) throws URISyntaxException {
        URL storyDirectory = this.getClass().getResource(path);
        Path root = storyDirectory != null ? Paths.get(storyDirectory.toURI()) : Paths.get("src/test/resources/" + path, new String[0]);
        return root;
    }

    private Optional<SearchForFilesOfType> getCucumberFileMatcher() {
        if (this.cucumberFileMatcher != null) {
            return Optional.of(this.cucumberFileMatcher);
        }
        try {
            Path root = this.findResourcePath(this.rootRequirementsDirectory + "/features");
            if (root != null) {
                this.cucumberFileMatcher = new SearchForFilesOfType(root, ".feature");
                Files.walkFileTree(root, this.cucumberFileMatcher);
                return Optional.of(this.cucumberFileMatcher);
            }
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        catch (IOException e) {
            e.printStackTrace();
            return Optional.empty();
        }
        return Optional.empty();
    }

    private boolean jbehaveFilesExist() {
        return this.getJBehaveFileMatcher().isPresent() && this.getJBehaveFileMatcher().get().hasMatchingFiles();
    }

    private boolean cucumberFilesExist() {
        return this.getCucumberFileMatcher().isPresent() && this.getCucumberFileMatcher().get().hasMatchingFiles();
    }

    public int startLevelForADepthOf(int requirementsDepth) {
        return Math.max(0, this.getRequirementTypes().size() - requirementsDepth);
    }
}

