/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.pages.FindAllWaitOptions;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import net.serenitybdd.core.selectors.Selectors;
import net.thucydides.core.scheduling.NormalFluentWait;
import net.thucydides.core.scheduling.ThucydidesFluentWait;
import net.thucydides.core.steps.StepEventBus;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchFrameException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.Clock;
import org.openqa.selenium.support.ui.Duration;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Sleeper;
import org.openqa.selenium.support.ui.SystemClock;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderedPageObjectView {
    private final transient WebDriver driver;
    private transient Duration waitForTimeout;
    private final Clock webdriverClock;
    private final Sleeper sleeper;
    private final PageObject pageObject;
    private final boolean timeoutCanBeOverriden;
    private static final int WAIT_FOR_ELEMENT_PAUSE_LENGTH = 50;
    private static final Logger LOGGER = LoggerFactory.getLogger(RenderedPageObjectView.class);
    private Duration oldWaitFor;

    public RenderedPageObjectView(WebDriver driver, PageObject pageObject, long waitForTimeoutInMilliseconds) {
        this(driver, pageObject, new Duration(waitForTimeoutInMilliseconds, TimeUnit.MILLISECONDS), true);
    }

    public RenderedPageObjectView(WebDriver driver, PageObject pageObject, Duration waitForTimeout, boolean timeoutCanBeOverriden) {
        this.driver = driver;
        this.pageObject = pageObject;
        this.setWaitForTimeout(waitForTimeout);
        this.webdriverClock = new SystemClock();
        this.sleeper = Sleeper.SYSTEM_SLEEPER;
        this.timeoutCanBeOverriden = timeoutCanBeOverriden;
    }

    private boolean driverIsDisabled() {
        return StepEventBus.getEventBus().webdriverCallsAreSuspended();
    }

    public ThucydidesFluentWait<WebDriver> waitForCondition() {
        return new NormalFluentWait<WebDriver>(this.driver, this.webdriverClock, this.sleeper).withTimeout(this.waitForTimeout.in(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).pollingEvery(50L, TimeUnit.MILLISECONDS).ignoring(NoSuchElementException.class, NoSuchFrameException.class, StaleElementReferenceException.class, InvalidElementStateException.class);
    }

    public FluentWait<WebDriver> doWait() {
        return new FluentWait((Object)this.driver).withTimeout(this.waitForTimeout.in(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).pollingEvery(50L, TimeUnit.MILLISECONDS).ignoreAll(NewList.of(NoSuchElementException.class, NoSuchFrameException.class, StaleElementReferenceException.class, InvalidElementStateException.class));
    }

    private ExpectedCondition<Boolean> elementDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsCurrentlyVisible(byElementCriteria);
            }

            public String toString() {
                return "Expecting element is displayed: " + byElementCriteria.toString();
            }
        };
    }

    public void waitFor(By byElementCriteria) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.elementDisplayed(byElementCriteria));
        }
    }

    public void waitFor(ExpectedCondition expectedCondition) {
        this.doWait().until((java.util.function.Function)expectedCondition);
    }

    public void waitFor(String xpathOrCssSelector) {
        this.waitFor(Selectors.xpathOrCssSelector(xpathOrCssSelector));
    }

    public WebElementFacade waitFor(WebElement webElement) {
        return webElement instanceof WebElementFacade ? this.waitForElement((WebElementFacade)webElement) : this.waitForElement((WebElementFacade)this.pageObject.element(webElement));
    }

    public WebElementFacade waitFor(WebElementFacade webElement) {
        return this.waitForElement(webElement);
    }

    public List<WebElementFacade> waitFor(List<WebElementFacade> webElements) {
        return this.waitForElements(webElements);
    }

    private WebElementFacade waitForElement(WebElementFacade webElement) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.elementIsDisplayed(webElement));
        }
        return webElement;
    }

    private List<WebElementFacade> waitForElements(List<WebElementFacade> elements) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.elementsAreDisplayed(elements));
        }
        return elements;
    }

    private Function<? super WebDriver, Boolean> elementIsDisplayed(final WebElementFacade webElement) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    if (webElement.isCurrentlyVisible()) {
                        return true;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
                return false;
            }
        };
    }

    private boolean elementIsNotDisplayed(By byElementCriteria) {
        List<WebElementFacade> matchingElements = this.findAllWithNoWait(byElementCriteria);
        for (WebElementFacade matchingElement : matchingElements) {
            if (!matchingElement.isCurrentlyVisible()) continue;
            return false;
        }
        return true;
    }

    private Function<? super WebDriver, Boolean> elementsAreDisplayed(final List<WebElementFacade> webElements) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                try {
                    return webElements.size() > 0 && RenderedPageObjectView.this.allElementsVisibleIn(webElements);
                }
                catch (NoSuchElementException noSuchElementException) {
                    return false;
                }
            }
        };
    }

    private boolean allElementsVisibleIn(List<WebElementFacade> webElements) {
        for (WebElementFacade element : webElements) {
            if (element.isCurrentlyVisible()) continue;
            return false;
        }
        return true;
    }

    public void waitForPresenceOf(By byElementCriteria) {
        WebDriverWait wait = new WebDriverWait(this.driver, this.waitForTimeout.in(TimeUnit.SECONDS));
        wait.until((java.util.function.Function)ExpectedConditions.presenceOfElementLocated((By)byElementCriteria));
    }

    public boolean elementIsPresent(By byElementCriteria) {
        boolean isDisplayed = true;
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            if (matchingElements.isEmpty()) {
                isDisplayed = false;
            }
        }
        catch (NoSuchElementException noSuchElement) {
            isDisplayed = false;
        }
        return isDisplayed;
    }

    public boolean elementIsDisplayed(By byElementCriteria) {
        try {
            this.waitFor(ExpectedConditions.visibilityOfAllElementsLocatedBy((By)byElementCriteria));
            return true;
        }
        catch (NoSuchElementException noSuchElement) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
        catch (TimeoutException iGuessItsNotThere) {
            return false;
        }
    }

    public boolean elementIsCurrentlyVisible(By byElementCriteria) {
        try {
            List matchingElements = this.driver.findElements(byElementCriteria);
            return !matchingElements.isEmpty() && ((WebElement)matchingElements.get(0)).isDisplayed();
        }
        catch (NoSuchElementException noSuchElement) {
            return false;
        }
        catch (StaleElementReferenceException se) {
            return false;
        }
        catch (TimeoutException iGuessItsNotThere) {
            return false;
        }
    }

    private ExpectedCondition<Boolean> textPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(expectedText);
            }

            public String toString() {
                return "Expecting text present: '" + expectedText + "'";
            }
        };
    }

    public void waitForText(String expectedText) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.textPresent(expectedText));
        }
    }

    private ExpectedCondition<Boolean> textPresentInElement(final WebElement element, final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.containsText(element, expectedText);
            }

            public String toString() {
                return "Expecting text present in element: '" + expectedText + "'";
            }
        };
    }

    public void waitForText(WebElement element, String expectedText) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.textPresentInElement(element, expectedText));
        }
    }

    private ExpectedCondition<Boolean> titlePresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.titleIs(expectedTitle);
            }

            public String toString() {
                return "Expecting title present: '" + expectedTitle + "', but found '" + RenderedPageObjectView.this.driver.getTitle() + "' instead.'";
            }
        };
    }

    public void waitForTitle(String expectedTitle) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.titlePresent(expectedTitle));
        }
    }

    private boolean titleIs(String expectedTitle) {
        return this.driver.getTitle() != null && this.driver.getTitle().equals(expectedTitle);
    }

    public boolean containsText(String textValue) {
        return this.driver.findElement(By.tagName((String)"body")).getText().contains(textValue);
    }

    public boolean containsText(WebElement element, String textValue) {
        return element.getText().contains(textValue);
    }

    private ExpectedCondition<Boolean> textNotPresent(final String expectedText) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.containsText(expectedText);
            }

            public String toString() {
                return "Expecting text not present: '" + expectedText + "'";
            }
        };
    }

    public void waitForTextToDisappear(String expectedText, long timeout) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().withTimeout(timeout, TimeUnit.MILLISECONDS).until(this.textNotPresent(expectedText));
        }
    }

    public void waitForTextToAppear(String expectedText, long timeout) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().withTimeout(timeout, TimeUnit.MILLISECONDS).until(this.textPresent(expectedText));
        }
    }

    private ExpectedCondition<Boolean> titleNotPresent(final String expectedTitle) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return !RenderedPageObjectView.this.titleIs(expectedTitle);
            }

            public String toString() {
                return "Expecting title present: '" + expectedTitle + "', but found '" + RenderedPageObjectView.this.driver.getTitle() + "' instead.";
            }
        };
    }

    public void waitForTitleToDisappear(String expectedTitle) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.titleNotPresent(expectedTitle));
        }
    }

    private ExpectedCondition<Boolean> anyTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.pageContainsAny(expectedTexts);
            }
        };
    }

    public void waitForAnyTextToAppear(String ... expectedTexts) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.anyTextPresent(expectedTexts));
        }
    }

    private ExpectedCondition<Boolean> anyTextPresentInElement(final WebElement element, final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementContains(element, expectedTexts);
            }

            public String toString() {
                return "Expecting any text present in element: '" + Arrays.toString(expectedTexts) + "'";
            }
        };
    }

    public void waitForAnyTextToAppear(WebElement element, String ... expectedTexts) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.anyTextPresentInElement(element, expectedTexts));
        }
    }

    public void waitForAbsenceOf(String xpathOrCssSelector) {
        this.waitForElementsToDisappear(Selectors.xpathOrCssSelector(xpathOrCssSelector));
    }

    private boolean elementContains(WebElement element, String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(element, expectedText)) continue;
            return true;
        }
        return false;
    }

    private boolean pageContainsAny(String ... expectedTexts) {
        for (String expectedText : expectedTexts) {
            if (!this.containsText(expectedText)) continue;
            return true;
        }
        return false;
    }

    private ExpectedCondition<Boolean> allTextPresent(final String ... expectedTexts) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (String expectedText : expectedTexts) {
                    if (RenderedPageObjectView.this.containsText(expectedText)) continue;
                    return false;
                }
                return true;
            }

            public String toString() {
                return "Expecting all texts present in element: '" + Arrays.toString(expectedTexts) + "'";
            }
        };
    }

    public void waitForAllTextToAppear(String ... expectedTexts) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.allTextPresent(expectedTexts));
        }
    }

    private ExpectedCondition<Boolean> elementNotDisplayed(final By byElementCriteria) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                return RenderedPageObjectView.this.elementIsNotDisplayed(byElementCriteria);
            }

            public String toString() {
                return "Expecting element not displayed: " + byElementCriteria;
            }
        };
    }

    public void waitForElementsToDisappear(By byElementCriteria) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.elementNotDisplayed(byElementCriteria));
        }
    }

    private ExpectedCondition<Boolean> anyElementPresent(final By ... expectedElements) {
        return new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (By expectedElement : expectedElements) {
                    if (!RenderedPageObjectView.this.elementIsDisplayed(expectedElement)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "Expecting any element present: " + Arrays.toString(expectedElements);
            }
        };
    }

    public void waitForAnyRenderedElementOf(By[] expectedElements) {
        if (!this.driverIsDisabled()) {
            this.waitForCondition().until(this.anyElementPresent(expectedElements));
        }
    }

    public void setWaitForTimeout(Duration waitForTimeout) {
        this.waitForTimeout = waitForTimeout;
    }

    public Duration getWaitForTimeout() {
        return this.waitForTimeout;
    }

    protected List<WebElementFacade> findAllWithOptionalWait(By bySelector, FindAllWaitOptions waitForOptions) {
        List<WebElementFacade> results;
        try {
            this.pageObject.setImplicitTimeout(0, TimeUnit.SECONDS);
            if (this.timeoutCanBeOverriden) {
                this.overrideWaitForTimeoutTo(new Duration(0L, TimeUnit.SECONDS));
            }
            if (waitForOptions == FindAllWaitOptions.WITH_WAIT) {
                this.waitFor(bySelector);
            }
            results = this.pageObject.findAll(bySelector);
            if (this.timeoutCanBeOverriden) {
                this.resetWaitForTimeout();
            }
            this.pageObject.resetImplicitTimeout();
        }
        catch (TimeoutException e) {
            return new ArrayList<WebElementFacade>();
        }
        return results;
    }

    public List<WebElementFacade> findAll(By bySelector) {
        return this.findAllWithOptionalWait(bySelector, FindAllWaitOptions.WITH_WAIT);
    }

    public List<WebElementFacade> findAllWithNoWait(By bySelector) {
        return this.findAllWithOptionalWait(bySelector, FindAllWaitOptions.WITH_NO_WAIT);
    }

    private void overrideWaitForTimeoutTo(Duration duration) {
        this.oldWaitFor = this.waitForTimeout;
        this.setWaitForTimeout(duration);
    }

    private void resetWaitForTimeout() {
        this.setWaitForTimeout(this.oldWaitFor);
    }

    public List<WebElementFacade> findAll(String xpathOrCssSelector) {
        return this.findAll(Selectors.xpathOrCssSelector(xpathOrCssSelector));
    }

    public WebElementFacade find(By bySelector) {
        this.waitFor(bySelector);
        this.pageObject.setImplicitTimeout(0, TimeUnit.SECONDS);
        Object result = this.pageObject.find(bySelector);
        this.pageObject.resetImplicitTimeout();
        return result;
    }

    public WebElementFacade find(String xpathOrCssSelector) {
        return this.find(Selectors.xpathOrCssSelector(xpathOrCssSelector));
    }

    public <T extends WebElementFacade> T moveTo(String xpathOrCssSelector) {
        this.pageObject.withAction().moveToElement(this.pageObject.findBy(xpathOrCssSelector));
        return this.pageObject.findBy(xpathOrCssSelector);
    }
}

