/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilitySet;
import net.thucydides.core.webdriver.SupportedWebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilityEnhancer {
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;

    public CapabilityEnhancer(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
    }

    public DesiredCapabilities enhanced(DesiredCapabilities capabilities, SupportedWebDriver driver) {
        CapabilitySet capabilitySet = new CapabilitySet(this.environmentVariables);
        this.addExtraCapabiities(capabilities, capabilitySet);
        if (ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            capabilities.acceptInsecureCerts();
        }
        this.addCapabilitiesFromFixtureServicesTo(capabilities);
        AddCustomDriverCapabilities.from(this.environmentVariables).forDriver(driver).to(capabilities);
        return capabilities;
    }

    private void addExtraCapabiities(DesiredCapabilities capabilities, CapabilitySet capabilitySet) {
        Map<String, Object> extraCapabilities = capabilitySet.getCapabilities();
        for (String capabilityName : extraCapabilities.keySet()) {
            capabilities.setCapability(capabilityName, this.convertFromString(extraCapabilities.get(capabilityName)));
        }
    }

    private Object convertFromString(Object value) {
        if (!(value instanceof String)) {
            return value;
        }
        if (this.isaBoolean(value)) {
            return Boolean.getBoolean(value.toString());
        }
        if (this.isAnInteger(value)) {
            return Integer.parseInt(value.toString());
        }
        return false;
    }

    private boolean isaBoolean(Object value) {
        return value.toString().equalsIgnoreCase("true") || value.toString().equalsIgnoreCase("false");
    }

    private boolean isAnInteger(Object value) {
        try {
            Integer.parseInt(value.toString());
            return true;
        }
        catch (NumberFormatException notAnInteger) {
            return false;
        }
    }

    private void addCapabilitiesFromFixtureServicesTo(DesiredCapabilities capabilities) {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.addCapabilitiesTo(capabilities);
        }
    }
}

