/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import java.util.List;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.SetProxyConfiguration;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.capabilities.AddCustomCapabilities;
import net.thucydides.core.webdriver.capabilities.ChromePreferences;
import net.thucydides.core.webdriver.chrome.OptionsSplitter;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;

public class ChromeDriverCapabilities
implements DriverCapabilitiesProvider {
    private final EnvironmentVariables environmentVariables;
    private final String driverOptions;

    public ChromeDriverCapabilities(EnvironmentVariables environmentVariables, String driverOptions) {
        this.environmentVariables = environmentVariables;
        this.driverOptions = driverOptions;
    }

    @Override
    public DesiredCapabilities getCapabilities() {
        DesiredCapabilities capabilities = DesiredCapabilities.chrome();
        ChromeOptions chromeOptions = this.configuredOptions();
        capabilities.setCapability("goog:chromeOptions", (Object)chromeOptions);
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        capabilities.setCapability("chrome.switches", chromeSwitches);
        AddCustomCapabilities.startingWith("chrome.capabilities.").from(this.environmentVariables).to(capabilities);
        SetProxyConfiguration.from(this.environmentVariables).in(capabilities);
        return capabilities;
    }

    private ChromeOptions configuredOptions() {
        ChromeOptions options = new ChromeOptions();
        this.addEnvironmentSwitchesTo(options);
        this.addRuntimeOptionsTo(options);
        this.addPreferencesTo(options);
        this.updateChromeBinaryIfSpecified(options);
        return options;
    }

    private void addEnvironmentSwitchesTo(ChromeOptions options) {
        String chromeSwitches = this.environmentVariables.getProperty(ThucydidesSystemProperty.CHROME_SWITCHES);
        options.addArguments(new String[]{"test-type"});
        if (StringUtils.isNotEmpty((CharSequence)chromeSwitches)) {
            List<String> arguments = new OptionsSplitter().split(chromeSwitches);
            options.addArguments(arguments);
        }
        if (ThucydidesSystemProperty.HEADLESS_MODE.isDefinedIn(this.environmentVariables) && ThucydidesSystemProperty.HEADLESS_MODE.booleanFrom(this.environmentVariables, false).booleanValue()) {
            options.addArguments(new String[]{"--headless"});
        }
    }

    private void addRuntimeOptionsTo(ChromeOptions options) {
        options.addArguments(new String[]{"test-type"});
        if (StringUtils.isNotEmpty((CharSequence)this.driverOptions)) {
            List<String> arguments = new OptionsSplitter().split(this.driverOptions);
            options.addArguments(arguments);
        }
        options.setAcceptInsecureCerts(ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, false).booleanValue());
    }

    private void addPreferencesTo(ChromeOptions options) {
        Map<String, Object> chromePreferences = ChromePreferences.startingWith("chrome_preferences.").from(this.environmentVariables);
        if (!chromePreferences.isEmpty()) {
            options.setExperimentalOption("prefs", chromePreferences);
        }
    }

    private void updateChromeBinaryIfSpecified(ChromeOptions options) {
        String chromeBinary = this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_CHROME_BINARY);
        if (StringUtils.isNotEmpty((CharSequence)chromeBinary)) {
            options.setBinary(chromeBinary);
        }
    }
}

