/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.webdriver.driverproviders;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import net.serenitybdd.core.webdriver.driverproviders.AppiumDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.DriverCapabilitiesProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.ProvidedDriverCapabilities;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityEnhancer;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

public class DriverCapabilities {
    public static final DriverCapabilitiesProvider DEFAULT_CAPABILITIES = DesiredCapabilities::firefox;
    private final EnvironmentVariables environmentVariables;
    private final CapabilityEnhancer enhancer;
    private final Integer EXTRA_TIME_TO_TAKE_SCREENSHOTS = 180;

    public DriverCapabilities(EnvironmentVariables environmentVariables, CapabilityEnhancer enhancer) {
        this.environmentVariables = environmentVariables;
        this.enhancer = enhancer;
    }

    public DesiredCapabilities forDriver(String driverName, String options) {
        if (driverName == null) {
            driverName = "remote";
        }
        SupportedWebDriver driverType = this.driverTypeFor(this.driverComponentof(driverName));
        Preconditions.checkNotNull((Object)((Object)driverType), (Object)("Unsupported remote driver type: " + driverName));
        if (this.shouldUseARemoteDriver()) {
            return this.enhancer.enhanced(this.remoteCapabilities(options), driverType);
        }
        return this.enhancer.enhanced(this.realBrowserCapabilities(driverType, options), driverType);
    }

    private String driverComponentof(String driverName) {
        return driverName.contains(":") ? driverName.split(":")[0] : driverName;
    }

    private SupportedWebDriver driverTypeFor(String driver) {
        String normalizedDriverName = this.driverComponentof(driver).toUpperCase();
        if (!SupportedWebDriver.listOfSupportedDrivers().contains(normalizedDriverName)) {
            SupportedWebDriver closestDriver = SupportedWebDriver.getClosestDriverValueTo(normalizedDriverName);
            throw new AssertionError((Object)("Unsupported driver for webdriver.driver or webdriver.remote.driver: " + driver + ". Did you mean " + closestDriver.toString().toLowerCase() + "?"));
        }
        return SupportedWebDriver.valueOrSynonymOf(normalizedDriverName);
    }

    private Map<SupportedWebDriver, DriverCapabilitiesProvider> driverCapabilitiesSelector(String options) {
        HashMap<SupportedWebDriver, DriverCapabilitiesProvider> selectors = new HashMap<SupportedWebDriver, DriverCapabilitiesProvider>();
        selectors.put(SupportedWebDriver.CHROME, new ChromeDriverCapabilities(this.environmentVariables, options));
        selectors.put(SupportedWebDriver.FIREFOX, new FirefoxDriverCapabilities(this.environmentVariables));
        selectors.put(SupportedWebDriver.APPIUM, new AppiumDriverCapabilities(this.environmentVariables, options));
        selectors.put(SupportedWebDriver.PROVIDED, new ProvidedDriverCapabilities(this.environmentVariables));
        selectors.put(SupportedWebDriver.SAFARI, DesiredCapabilities::safari);
        selectors.put(SupportedWebDriver.HTMLUNIT, DesiredCapabilities::htmlUnit);
        selectors.put(SupportedWebDriver.OPERA, DesiredCapabilities::operaBlink);
        selectors.put(SupportedWebDriver.IEXPLORER, DesiredCapabilities::internetExplorer);
        selectors.put(SupportedWebDriver.EDGE, DesiredCapabilities::edge);
        selectors.put(SupportedWebDriver.PHANTOMJS, DesiredCapabilities::phantomjs);
        selectors.put(SupportedWebDriver.IPHONE, DesiredCapabilities::iphone);
        selectors.put(SupportedWebDriver.ANDROID, DesiredCapabilities::android);
        return selectors;
    }

    public DesiredCapabilities realBrowserCapabilities(SupportedWebDriver driverType, String options) {
        return this.enhancer.enhanced(this.driverCapabilitiesSelector(options).getOrDefault((Object)driverType, DEFAULT_CAPABILITIES).getCapabilities(), driverType);
    }

    private DesiredCapabilities remoteCapabilities(String options) {
        String remoteBrowser = ThucydidesSystemProperty.WEBDRIVER_REMOTE_DRIVER.from(this.environmentVariables, WebDriverFactory.getDriverFrom(this.environmentVariables));
        if (remoteBrowser == null) {
            remoteBrowser = "firefox";
        }
        DesiredCapabilities capabilities = this.realBrowserCapabilities(this.driverTypeFor(remoteBrowser), options);
        capabilities.setCapability("idle-timeout", (Object)this.EXTRA_TIME_TO_TAKE_SCREENSHOTS);
        Boolean recordScreenshotsInSaucelabs = ThucydidesSystemProperty.SAUCELABS_RECORD_SCREENSHOTS.booleanFrom(this.environmentVariables);
        capabilities.setCapability("record-screenshots", (Object)recordScreenshotsInSaucelabs);
        if (this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS) != null) {
            capabilities.setCapability("platform", Platform.valueOf((String)this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_OS)));
        }
        if (this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION) != null) {
            capabilities.setCapability("version", this.environmentVariables.getProperty(ThucydidesSystemProperty.WEBDRIVER_REMOTE_BROWSER_VERSION));
        }
        return capabilities;
    }

    private boolean shouldUseARemoteDriver() {
        return ThucydidesSystemProperty.WEBDRIVER_REMOTE_URL.isDefinedIn(this.environmentVariables);
    }
}

