/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class RootDirectory {
    private final EnvironmentVariables environmentVariables;
    private final String rootDirectoryPath;
    private static final String DEFAULT_FEATURES_ROOT_DIRECTORY = "features";
    private static final String DEFAULT_STORIES_ROOT_DIRECTORY = "stories";
    private final String featureDirectoryName;
    private final String storyDirectoryName;
    private Set<String> configuredRelativeRootDirectories;
    private static final Pattern WINDOWS_PATH = Pattern.compile("([a-zA-Z]:)?(\\\\[a-zA-Z0-9_-]+)+\\\\?");

    RootDirectory(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this.environmentVariables = environmentVariables;
        this.rootDirectoryPath = rootDirectoryPath;
        this.featureDirectoryName = ThucydidesSystemProperty.SERENITY_FEATURES_DIRECTORY.from(environmentVariables, DEFAULT_FEATURES_ROOT_DIRECTORY);
        this.storyDirectoryName = ThucydidesSystemProperty.SERENITY_STORIES_DIRECTORY.from(environmentVariables, DEFAULT_STORIES_ROOT_DIRECTORY);
    }

    public static RootDirectory definedIn(EnvironmentVariables environmentVariables) {
        return new RootDirectory(environmentVariables, ".");
    }

    public Set<String> getRootDirectoryPaths() {
        try {
            if (ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.isDefinedIn(this.environmentVariables)) {
                return this.getRootDirectoryFromRequirementsBaseDir();
            }
            return this.firstDefinedOf(this.getRootDirectoryFromClasspath(), this.getFileSystemDefinedDirectory(), this.getRootDirectoryFromWorkingDirectory());
        }
        catch (IOException e) {
            return new HashSet<String>();
        }
    }

    public String featureDirectoryName() {
        return this.featureDirectoryName;
    }

    public String storyDirectoryName() {
        return this.storyDirectoryName;
    }

    @SafeVarargs
    private final Set<String> firstDefinedOf(Set<String> ... paths) {
        for (Set<String> path : paths) {
            if (path.isEmpty()) continue;
            return path;
        }
        return new HashSet<String>();
    }

    private Set<String> getRootDirectoryFromClasspath() throws IOException {
        ArrayList<URL> resourceRoots;
        try {
            Enumeration<URL> requirementResources = this.getDirectoriesFrom(this.rootDirectoryPath);
            resourceRoots = Collections.list(requirementResources);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return this.restoreSpacesIn(resourceRoots);
    }

    private Set<String> restoreSpacesIn(List<URL> resourceRoots) {
        HashSet<String> urlsWithRestoredSpaces = new HashSet<String>();
        for (URL resourceRoot : resourceRoots) {
            urlsWithRestoredSpaces.add(this.withRestoredSpaces(resourceRoot.getPath()));
        }
        return urlsWithRestoredSpaces;
    }

    private String withRestoredSpaces(String path) {
        try {
            return URLDecoder.decode(path, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return StringUtils.replace((String)path, (String)"%20", (String)" ");
        }
    }

    private Set<String> getFileSystemDefinedDirectory() {
        if (Paths.get(this.rootDirectoryPath, new String[0]).toAbsolutePath().toFile().exists()) {
            HashSet<String> directory = new HashSet<String>();
            directory.add(Paths.get(this.rootDirectoryPath, new String[0]).toAbsolutePath().toString());
            return directory;
        }
        return new HashSet<String>();
    }

    private Set<String> getRootDirectoryFromWorkingDirectory() {
        String workingDirectory = System.getProperty("user.dir");
        String mavenBuildDir = System.getProperty("project.build.directory");
        String resultDir = !StringUtils.isEmpty((CharSequence)mavenBuildDir) ? mavenBuildDir : workingDirectory;
        return this.getRootDirectoryFromParentDir(resultDir);
    }

    private Set<String> getRootDirectoryFromRequirementsBaseDir() {
        if (this.configuredRelativeRootDirectories == null) {
            this.configuredRelativeRootDirectories = this.getRootDirectoryFromParentDir(ThucydidesSystemProperty.SERENITY_TEST_REQUIREMENTS_BASEDIR.from(this.environmentVariables, ""));
        }
        return this.configuredRelativeRootDirectories;
    }

    private Set<String> getRootDirectoryFromParentDir(String parentDir) {
        List<File> resourceDirectories = RootDirectory.getResourceDirectories(Paths.get(parentDir, new String[0]), this.environmentVariables);
        HashSet<String> directoryPaths = new HashSet<String>();
        for (File resourceDirectory : resourceDirectories) {
            if (new File(resourceDirectory, this.rootDirectoryPath).exists()) {
                directoryPaths.add(new File(resourceDirectory, this.rootDirectoryPath).getAbsolutePath());
            }
            if (new File(resourceDirectory, this.featureDirectoryName).exists()) {
                directoryPaths.add(new File(resourceDirectory, this.featureDirectoryName).getAbsolutePath());
            }
            if (!new File(resourceDirectory, this.storyDirectoryName).exists()) continue;
            directoryPaths.add(new File(resourceDirectory, this.storyDirectoryName).getAbsolutePath());
        }
        return directoryPaths;
    }

    private Enumeration<URL> getDirectoriesFrom(String root) throws IOException, URISyntaxException {
        String rootWithEscapedSpaces = root.replaceAll(" ", "%20");
        URI rootUri = this.isWindowsPath(rootWithEscapedSpaces) ? new File(root).toPath().toUri() : new URI(rootWithEscapedSpaces);
        return this.getClass().getClassLoader().getResources(rootUri.getPath());
    }

    private boolean isWindowsPath(String rootWithEscapedSpaces) {
        return WINDOWS_PATH.matcher(rootWithEscapedSpaces).find();
    }

    public Optional<Path> featuresOrStoriesRootDirectory() {
        String relativeRoot;
        String string = relativeRoot = this.rootDirectoryPath.equals(".") ? "" : this.rootDirectoryPath;
        if (ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.isDefinedIn(this.environmentVariables)) {
            return Optional.of(Paths.get(ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.from(this.environmentVariables), new String[0]));
        }
        List<File> resourceDirectories = RootDirectory.getResourceDirectories(Paths.get(relativeRoot, new String[0]), this.environmentVariables);
        for (File resourceDir : resourceDirectories) {
            if (new File(resourceDir, this.storyDirectoryName).exists()) {
                return Optional.of(resourceDir.toPath().resolve(this.storyDirectoryName));
            }
            if (!new File(resourceDir, this.featureDirectoryName).exists()) continue;
            return Optional.of(resourceDir.toPath().resolve(this.featureDirectoryName));
        }
        return Optional.empty();
    }

    private static List<File> getResourceDirectories(Path root, EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.SERENITY_REQUIREMENTS_DIR.isDefinedIn(environmentVariables)) {
            return new ArrayList<File>();
        }
        return RootDirectory.listDirectories(root).stream().filter(path -> path.endsWith("src/test/resources")).map(Path::toFile).collect(Collectors.toList());
    }

    private static List<Path> listDirectories(Path path) {
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
            for (Path entry : stream) {
                if (!Files.isDirectory(entry, new LinkOption[0])) continue;
                files.add(entry);
                files.addAll(RootDirectory.listDirectories(entry));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return files;
    }
}

