/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.opera.core.systems.OperaDriver;
import io.appium.java_client.AppiumDriver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.serenitybdd.core.collect.NewList;
import net.serenitybdd.core.strings.Joiner;
import net.thucydides.core.webdriver.ProvidedDriver;
import net.thucydides.core.webdriver.UnsupportedDriverException;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.safari.SafariDriver;

public enum SupportedWebDriver {
    FIREFOX(FirefoxDriver.class),
    CHROME(ChromeDriver.class),
    OPERA(OperaDriver.class),
    HTMLUNIT(HtmlUnitDriver.class),
    PHANTOMJS(PhantomJSDriver.class),
    REMOTE(RemoteWebDriver.class),
    IPHONE(RemoteWebDriver.class),
    ANDROID(RemoteWebDriver.class),
    IEXPLORER(InternetExplorerDriver.class, false, NewList.of("IE")),
    EDGE(EdgeDriver.class, false),
    SAFARI(SafariDriver.class),
    APPIUM(AppiumDriver.class),
    PROVIDED(ProvidedDriver.class);

    private final Class<? extends WebDriver> webdriverClass;
    private final boolean supportsJavascriptInjection;
    private final List<String> synonyms;

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass, boolean supportsJavascriptInjection, List<String> synonyms) {
        this.webdriverClass = webdriverClass;
        this.supportsJavascriptInjection = supportsJavascriptInjection;
        this.synonyms = NewList.copyOf(synonyms);
    }

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass, boolean supportsJavascriptInjection) {
        this(webdriverClass, supportsJavascriptInjection, new ArrayList<String>());
    }

    private SupportedWebDriver(Class<? extends WebDriver> webdriverClass) {
        this(webdriverClass, true, new ArrayList<String>());
    }

    public static SupportedWebDriver valueOrSynonymOf(String driverName) {
        for (SupportedWebDriver supportedWebDriver : SupportedWebDriver.values()) {
            if (driverName.trim().equalsIgnoreCase(supportedWebDriver.name())) {
                return supportedWebDriver;
            }
            if (!supportedWebDriver.synonyms.contains(driverName.trim())) continue;
            return supportedWebDriver;
        }
        throw new IllegalArgumentException("Unsupported driver type: " + driverName);
    }

    public Class<? extends WebDriver> getWebdriverClass() {
        return this.webdriverClass;
    }

    public static String listOfSupportedDrivers() {
        String enumValues = Joiner.on(", ").join(Arrays.stream(SupportedWebDriver.values()).map(Enum::toString).collect(Collectors.toList()));
        return Joiner.on(", ").join(SupportedWebDriver.getSynonymes(), enumValues);
    }

    private static String getSynonymes() {
        ArrayList<String> synonymeValues = new ArrayList<String>();
        for (SupportedWebDriver supportedWebDriver : SupportedWebDriver.values()) {
            synonymeValues.addAll(supportedWebDriver.synonyms);
        }
        return Joiner.on(", ").join((List<String>)synonymeValues);
    }

    public static SupportedWebDriver getClosestDriverValueTo(String value) {
        SupportedWebDriver closestDriver = null;
        int closestDriverDistance = Integer.MAX_VALUE;
        for (SupportedWebDriver supportedDriver : SupportedWebDriver.values()) {
            int distance = StringUtils.getLevenshteinDistance((CharSequence)supportedDriver.toString(), (CharSequence)value);
            if (distance >= closestDriverDistance) continue;
            closestDriverDistance = distance;
            closestDriver = supportedDriver;
        }
        return closestDriver;
    }

    public static SupportedWebDriver getDriverTypeFor(String value) throws UnsupportedDriverException {
        try {
            return SupportedWebDriver.valueOrSynonymOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SupportedWebDriver closestMatchingDriver = SupportedWebDriver.getClosestDriverValueTo(value);
            throw new UnsupportedDriverException("Unsupported browser type: " + value + ". Did you mean " + closestMatchingDriver.toString().toLowerCase() + "?", e);
        }
    }

    public static SupportedWebDriver forClass(Class<?> driverClass) {
        for (SupportedWebDriver supportedWebDriver : SupportedWebDriver.values()) {
            if (!driverClass.isAssignableFrom(supportedWebDriver.getWebdriverClass())) continue;
            return supportedWebDriver;
        }
        throw new IllegalArgumentException("Driver not supported: " + driverClass);
    }

    public boolean supportsJavascriptInjection() {
        return this.supportsJavascriptInjection;
    }
}

