/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.photography;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.serenitybdd.core.photography.Darkroom;
import net.serenitybdd.core.photography.DarkroomFileSystem;
import net.serenitybdd.core.photography.ScreenshotDigest;
import net.serenitybdd.core.photography.ScreenshotNegative;
import net.serenitybdd.core.photography.ScreenshotPhoto;
import net.serenitybdd.core.photography.ScreenshotReceipt;
import net.thucydides.core.screenshots.BlurLevel;
import net.thucydides.core.webdriver.WebDriverFactory;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhotoSession {
    private final WebDriver driver;
    private final Path outputDirectory;
    private final Darkroom darkroom;
    private BlurLevel blurLevel;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static ThreadLocal<ScreenshotPhoto> previousScreenshot = new ThreadLocal();
    private static ThreadLocal<Long> previousScreenshotTimestamp = ThreadLocal.withInitial(() -> 0L);
    private static final String BLANK_SCREEN = "c118a2e3019c996cb56584ec6f8cd0b2be4c056ce4ae6b83de3c32c2e364cc61.png";

    public PhotoSession(WebDriver driver, Darkroom darkroom, Path outputDirectory, BlurLevel blurLevel) {
        this.driver = driver;
        this.outputDirectory = outputDirectory;
        this.blurLevel = blurLevel;
        this.darkroom = darkroom;
        darkroom.isOpenForBusiness();
    }

    public ScreenshotPhoto takeScreenshot() {
        if (this.tooSoonForNewPhoto() && previousScreenshot.get() != null) {
            return previousScreenshot.get();
        }
        byte[] screenshotData = null;
        if (WebDriverFactory.isAlive(this.driver) && this.driver instanceof TakesScreenshot) {
            try {
                screenshotData = (byte[])((TakesScreenshot)this.driver).getScreenshotAs(OutputType.BYTES);
            }
            catch (Exception e) {
                this.LOGGER.warn("Failed to take screenshot", (Throwable)e);
                return ScreenshotPhoto.None;
            }
        }
        if (this.shouldIgnore(screenshotData)) {
            return ScreenshotPhoto.None;
        }
        ScreenshotPhoto photo = this.storedScreenshot(screenshotData);
        previousScreenshot.set(photo);
        previousScreenshotTimestamp.set(System.currentTimeMillis());
        return photo;
    }

    private boolean shouldIgnore(byte[] screenshotData) {
        if (screenshotData == null || screenshotData.length == 0) {
            return true;
        }
        return this.filenameFor(screenshotData).equals(BLANK_SCREEN);
    }

    private boolean tooSoonForNewPhoto() {
        long previousPhotoTaken = previousScreenshotTimestamp.get();
        return System.currentTimeMillis() - previousPhotoTaken < 50L;
    }

    private ScreenshotPhoto storedScreenshot(byte[] screenshotData) {
        try {
            Path screenshotPath = this.screenshotPathFor(screenshotData);
            ScreenshotReceipt screenshotReceipt = this.storeScreenshot(screenshotData, screenshotPath);
            this.LOGGER.debug("Screenshot scheduled to be saved to {}", (Object)screenshotPath);
            return ScreenshotPhoto.forScreenshotAt(screenshotReceipt.getDestinationPath());
        }
        catch (IOException e) {
            this.LOGGER.warn("Failed to save screenshot", (Throwable)e);
            return ScreenshotPhoto.None;
        }
    }

    private ScreenshotReceipt storeScreenshot(byte[] screenshotData, Path screenshotPath) throws IOException {
        Path screenshotsDirectory = DarkroomFileSystem.get().getPath("/var/screenshots", new String[0]);
        Files.createDirectories(screenshotsDirectory, new FileAttribute[0]);
        ScreenshotNegative screenshotNegative = ScreenshotNegative.prepareNegativeIn(screenshotsDirectory).withScreenshotData(screenshotData).andBlurringOf(this.blurLevel).andTargetPathOf(screenshotPath);
        return this.darkroom.sendNegative(screenshotNegative);
    }

    private String filenameFor(byte[] screenshotData) {
        return ScreenshotDigest.forScreenshotData(screenshotData);
    }

    private Path screenshotPathFor(byte[] screenshotData) {
        return this.outputDirectory.resolve(this.filenameFor(screenshotData));
    }
}

