/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import io.appium.java_client.AppiumDriver;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.di.WebDriverInjectors;
import net.serenitybdd.core.exceptions.SerenityManagedException;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.serenitybdd.core.webdriver.driverproviders.AppiumDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ChromeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.DriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.EdgeDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.FirefoxDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.HtmlDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.InternetExplorerDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.PhantomJSDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.ProvidedDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.RemoteDriverProvider;
import net.serenitybdd.core.webdriver.driverproviders.SafariDriverProvider;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureException;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CloseBrowser;
import net.thucydides.core.webdriver.DriverConfigurationError;
import net.thucydides.core.webdriver.DriverStrategySelector;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.TimeoutStack;
import net.thucydides.core.webdriver.WebDriverFacade;
import net.thucydides.core.webdriver.capabilities.SaucelabsRemoteDriverCapabilities;
import net.thucydides.core.webdriver.redimension.RedimensionBrowser;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;

public class WebDriverFactory {
    public static final String DEFAULT_DRIVER = "firefox";
    public static final String REMOTE_DRIVER = "remote";
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;
    private final SaucelabsRemoteDriverCapabilities sauceRemoteDriverCapabilities;
    private final CloseBrowser closeBrowser;
    private Map<SupportedWebDriver, DriverProvider> driverProvidersByDriverType;
    private final TimeoutStack timeoutStack;

    public WebDriverFactory() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables) {
        this(environmentVariables, (FixtureProviderService)WebDriverInjectors.getInjector().getInstance(FixtureProviderService.class));
    }

    public WebDriverFactory(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
        this.sauceRemoteDriverCapabilities = new SaucelabsRemoteDriverCapabilities(environmentVariables);
        this.timeoutStack = new TimeoutStack();
        this.closeBrowser = (CloseBrowser)WebDriverInjectors.getInjector().getInstance(CloseBrowser.class);
    }

    public WebDriver newInstanceOf(SupportedWebDriver driverType) {
        if (driverType == null) {
            throw new IllegalArgumentException("Driver type cannot be null");
        }
        return this.newWebdriverInstance(driverType.getWebdriverClass());
    }

    public Class<? extends WebDriver> getClassFor(SupportedWebDriver driverType) {
        if (this.usesSauceLabs() && driverType != SupportedWebDriver.HTMLUNIT) {
            return RemoteWebDriver.class;
        }
        return driverType.getWebdriverClass();
    }

    public boolean usesSauceLabs() {
        return StringUtils.isNotEmpty((CharSequence)this.sauceRemoteDriverCapabilities.getUrl());
    }

    private Map<SupportedWebDriver, DriverProvider> driverProviders() {
        if (this.driverProvidersByDriverType == null) {
            this.driverProvidersByDriverType = new HashMap<SupportedWebDriver, DriverProvider>();
            this.driverProvidersByDriverType.put(SupportedWebDriver.APPIUM, new AppiumDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.REMOTE, new RemoteDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.FIREFOX, new FirefoxDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.HTMLUNIT, new HtmlDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.PHANTOMJS, new PhantomJSDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.CHROME, new ChromeDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.SAFARI, new SafariDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.IEXPLORER, new InternetExplorerDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.EDGE, new EdgeDriverProvider(this.fixtureProviderService));
            this.driverProvidersByDriverType.put(SupportedWebDriver.PROVIDED, new ProvidedDriverProvider());
        }
        return this.driverProvidersByDriverType;
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass) {
        return this.newWebdriverInstance(driverClass, "");
    }

    private synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass, String options) {
        return this.newWebdriverInstance(driverClass, options, this.environmentVariables);
    }

    protected synchronized WebDriver newWebdriverInstance(Class<? extends WebDriver> driverClass, String options, EnvironmentVariables environmentVariables) {
        RedimensionBrowser redimensionBrowser = new RedimensionBrowser(environmentVariables);
        try {
            SupportedWebDriver supportedDriverType = DriverStrategySelector.inEnvironment(environmentVariables).forDriverClass(driverClass);
            WebDriver driver = this.driverProviders().get((Object)supportedDriverType).newInstance(options, environmentVariables);
            this.setImplicitTimeoutsIfSpecified(driver);
            redimensionBrowser.withDriver(driver);
            this.closeBrowser.closeWhenTheTestsAreFinished(driver);
            return driver;
        }
        catch (SerenityManagedException toPassThrough) {
            throw toPassThrough;
        }
        catch (Exception cause) {
            throw new DriverConfigurationError("Could not instantiate new WebDriver instance of type " + driverClass + " (" + cause.getMessage() + "). See below for more details.", cause);
        }
    }

    private void setImplicitTimeoutsIfSpecified(WebDriver driver) {
        if (ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.isDefinedIn(this.environmentVariables)) {
            int timeout = this.environmentVariables.getPropertyAsInteger(ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.getPropertyName(), Integer.valueOf(0));
            driver.manage().timeouts().implicitlyWait((long)timeout, TimeUnit.MILLISECONDS);
        }
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables, String defaultDriver) {
        String driver = WebDriverFactory.getDriverFrom(environmentVariables);
        return driver != null ? driver : defaultDriver;
    }

    public static String getDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.WEBDRIVER_DRIVER.from(environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.DRIVER.from(environmentVariables);
        }
        return driver;
    }

    public static String getBrowserStackDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.BROWSERSTACK_BROWSER.from(environmentVariables);
        if (driver == null) {
            driver = ThucydidesSystemProperty.BROWSERSTACK_BROWSERNAME.from(environmentVariables);
        }
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(environmentVariables);
        }
        return driver;
    }

    public static String getSaucelabsDriverFrom(EnvironmentVariables environmentVariables) {
        String driver = ThucydidesSystemProperty.SAUCELABS_BROWSERNAME.from(environmentVariables);
        if (driver == null) {
            driver = WebDriverFactory.getDriverFrom(environmentVariables);
        }
        return driver;
    }

    public void setupFixtureServices() throws FixtureException {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.setup();
        }
    }

    public void shutdownFixtureServices() {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.shutdown();
        }
    }

    private boolean isNotAMocked(WebDriver driver) {
        return !driver.getClass().getName().contains("Mock") && !driver.toString().contains("Mock for");
    }

    public void setTimeouts(WebDriver proxiedDriver, Duration implicitTimeout) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        this.timeoutStack.pushTimeoutFor(proxiedDriver, implicitTimeout);
        if (implicitTimeout != currentTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(implicitTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public Duration currentTimeoutFor(WebDriver proxiedDriver) {
        Optional<Duration> storedTimeoutValue = this.timeoutStack.currentTimeoutValueFor(proxiedDriver);
        return storedTimeoutValue.orElse(this.getDefaultImplicitTimeout());
    }

    public Duration resetTimeouts(WebDriver proxiedDriver) {
        Duration currentTimeout = this.currentTimeoutFor(proxiedDriver);
        if (!this.timeoutStack.containsTimeoutFor(proxiedDriver).booleanValue()) {
            return currentTimeout;
        }
        this.timeoutStack.popTimeoutFor(proxiedDriver);
        Duration previousTimeout = this.currentTimeoutFor(proxiedDriver);
        if (currentTimeout != previousTimeout && this.isNotAMocked(proxiedDriver)) {
            proxiedDriver.manage().timeouts().implicitlyWait(previousTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        return previousTimeout;
    }

    public Duration getDefaultImplicitTimeout() {
        String configuredTimeoutValue = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.from(this.environmentVariables);
        return configuredTimeoutValue != null ? Duration.ofMillis(Integer.parseInt(configuredTimeoutValue)) : DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    public static boolean isAlive(WebDriver driver) {
        try {
            WebDriver local = driver;
            if (driver instanceof WebDriverFacade) {
                local = ((WebDriverFacade)driver).getDriverInstance();
            }
            if (!(local instanceof AppiumDriver)) {
                local.getCurrentUrl();
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isNotAlive(WebDriver driver) {
        return !WebDriverFactory.isAlive(driver);
    }

    public void releaseTimoutFor(WebDriver driverInstance) {
        this.timeoutStack.releaseTimeoutFor(driverInstance);
    }
}

