/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Map;
import java.util.Optional;
import net.serenitybdd.core.webdriver.driverproviders.AddCustomDriverCapabilities;
import net.serenitybdd.core.webdriver.driverproviders.AddEnvironmentSpecifiedDriverCapabilities;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.fixtureservices.FixtureProviderService;
import net.thucydides.core.fixtureservices.FixtureService;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilitySet;
import net.thucydides.core.webdriver.SupportedWebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilityEnhancer {
    private final EnvironmentVariables environmentVariables;
    private final FixtureProviderService fixtureProviderService;

    public CapabilityEnhancer(EnvironmentVariables environmentVariables, FixtureProviderService fixtureProviderService) {
        this.environmentVariables = environmentVariables;
        this.fixtureProviderService = fixtureProviderService;
    }

    public DesiredCapabilities enhanced(DesiredCapabilities capabilities, SupportedWebDriver driver) {
        CapabilitySet capabilitySet = new CapabilitySet(this.environmentVariables);
        this.addExtraCapabiities(capabilities, capabilitySet);
        if (ThucydidesSystemProperty.ACCEPT_INSECURE_CERTIFICATES.booleanFrom(this.environmentVariables, Boolean.valueOf(false)).booleanValue()) {
            capabilities.acceptInsecureCerts();
        }
        this.addCapabilitiesFromFixtureServicesTo(capabilities);
        AddEnvironmentSpecifiedDriverCapabilities.from(this.environmentVariables).forDriver(driver).to(capabilities);
        if (StepEventBus.getEventBus() != null && StepEventBus.getEventBus().isBaseStepListenerRegistered()) {
            Optional<TestOutcome> currentTestOutcome = StepEventBus.getEventBus().getBaseStepListener().latestTestOutcome();
            TestOutcome outcome = currentTestOutcome == null ? null : (TestOutcome)currentTestOutcome.orElse(null);
            AddCustomDriverCapabilities.from(this.environmentVariables).withTestDetails(driver, outcome).to(capabilities);
        }
        return capabilities;
    }

    private void addExtraCapabiities(DesiredCapabilities capabilities, CapabilitySet capabilitySet) {
        Map<String, Object> extraCapabilities = capabilitySet.getCapabilities();
        for (String capabilityName : extraCapabilities.keySet()) {
            capabilities.setCapability(capabilityName, extraCapabilities.get(capabilityName));
        }
    }

    private void addCapabilitiesFromFixtureServicesTo(DesiredCapabilities capabilities) {
        for (FixtureService fixtureService : this.fixtureProviderService.getFixtureServices()) {
            fixtureService.addCapabilitiesTo(capabilities);
        }
    }
}

