/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class ChromePreferences {
    private final String prefix;

    private ChromePreferences(String prefix) {
        this.prefix = prefix;
    }

    public static ChromePreferences startingWith(String prefix) {
        return new ChromePreferences(prefix);
    }

    public Map<String, Object> from(EnvironmentVariables environmentVariables) {
        List propertiesWithPrefix = environmentVariables.getKeys().stream().filter(key -> key.startsWith(this.prefix)).collect(Collectors.toList());
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        for (String propertyKey : propertiesWithPrefix) {
            String preparedPropertyKey = this.getPreparedPropertyKey(propertyKey);
            String propertyValue = environmentVariables.getProperty(propertyKey);
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            preferences.put(preparedPropertyKey, this.asObject(propertyValue));
        }
        return preferences;
    }

    private Object asObject(String propertyValue) {
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException numberFormatException) {
            if (propertyValue.equalsIgnoreCase("true") || propertyValue.equalsIgnoreCase("false")) {
                return Boolean.parseBoolean(propertyValue);
            }
            return propertyValue;
        }
    }

    private String getPreparedPropertyKey(String propertyKey) {
        return propertyKey.replace(this.prefix, "");
    }
}

