/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

class CapabilitySet {
    private final EnvironmentVariables environmentVariables;
    private static final CharMatcher CAPABILITY_SEPARATOR = CharMatcher.anyOf((CharSequence)";");

    CapabilitySet(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables.copy();
    }

    public Map<String, Object> getCapabilities() {
        Map<String, Object> capabilitiesMap = new HashMap<String, Object>();
        String specifiedCapabilities = ThucydidesSystemProperty.SERENITY_DRIVER_CAPABILITIES.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)specifiedCapabilities)) {
            Iterable capabilityValues = Splitter.on((CharMatcher)CAPABILITY_SEPARATOR).trimResults().split((CharSequence)specifiedCapabilities);
            capabilitiesMap = this.addCapabilityMapValues(capabilityValues);
        }
        return capabilitiesMap;
    }

    private Map<String, Object> addCapabilityMapValues(Iterable<String> capabilityValues) {
        HashMap<String, Object> capabilitiesMap = new HashMap<String, Object>();
        for (String capability : capabilityValues) {
            CapabilityToken token = new CapabilityToken(capability);
            if (!token.isDefined()) continue;
            capabilitiesMap.put(token.getName(), this.asObject(token.getValue()));
        }
        return capabilitiesMap;
    }

    private Object asObject(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.parseBoolean(value);
        }
        if (this.isAList(value)) {
            return this.asList(value);
        }
        return value;
    }

    private List<Object> asList(String value) {
        String listContents = StringUtils.removeEnd((String)StringUtils.removeStart((String)value, (String)"["), (String)"]");
        List items = Splitter.on((String)",").trimResults().splitToList((CharSequence)listContents);
        return items.stream().map(this::asObject).collect(Collectors.toList());
    }

    private boolean isAList(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    private static class CapabilityToken {
        private final String name;
        private final String value;

        private CapabilityToken(String capability) {
            int colonIndex = capability.lastIndexOf(":");
            if (colonIndex >= 0) {
                boolean colonIndexFound = false;
                int lastIndex = capability.length();
                while (!colonIndexFound) {
                    int lastColonIndex = capability.lastIndexOf(":", lastIndex);
                    if (lastColonIndex > 0) {
                        colonIndex = lastColonIndex;
                        if (capability.length() >= colonIndex + 1 && this.isFollowedByPathSeparator(capability, colonIndex)) {
                            if (lastIndex == colonIndex - 1) {
                                colonIndexFound = true;
                                break;
                            }
                            lastIndex = colonIndex - 1;
                            continue;
                        }
                        colonIndexFound = true;
                        continue;
                    }
                    colonIndexFound = true;
                }
                this.name = capability.substring(0, colonIndex);
                this.value = capability.substring(colonIndex + 1);
            } else {
                this.name = capability;
                this.value = null;
            }
        }

        private boolean isFollowedByPathSeparator(String capability, int colonIndex) {
            return capability.charAt(colonIndex + 1) == '\\' || capability.charAt(colonIndex + 1) == '/';
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isDefined() {
            return StringUtils.isNotEmpty((CharSequence)this.name) && StringUtils.isNotEmpty((CharSequence)this.value);
        }
    }
}

