/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CapabilityValue {
    public static Object asObject(String value) {
        if (StringUtils.isNumeric((CharSequence)value)) {
            return Integer.parseInt(value);
        }
        if (value.toLowerCase().equals("true") || value.toLowerCase().equals("false")) {
            return Boolean.parseBoolean(value);
        }
        if (CapabilityValue.isAList(value)) {
            return CapabilityValue.asList(value);
        }
        return value;
    }

    private static boolean isAList(String value) {
        return value.startsWith("[") && value.endsWith("]");
    }

    private static List<Object> asList(String value) {
        String listContents = StringUtils.removeEnd((String)StringUtils.removeStart((String)value, (String)"["), (String)"]");
        List items = Splitter.on((String)",").trimResults().splitToList((CharSequence)listContents);
        return items.stream().map(CapabilityValue::asObject).collect(Collectors.toList());
    }
}

