/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver.capabilities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.serenitybdd.core.environment.EnvironmentSpecificConfiguration;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.CapabilityValue;
import org.apache.commons.lang3.StringUtils;

public class ChromePreferences {
    private final String prefix;

    private ChromePreferences(String prefix) {
        this.prefix = prefix;
    }

    public static ChromePreferences startingWith(String prefix) {
        return new ChromePreferences(prefix);
    }

    public Map<String, Object> from(EnvironmentVariables environmentVariables) {
        List propertiesWithPrefix = environmentVariables.getKeys().stream().filter(key -> key.startsWith(this.prefix)).collect(Collectors.toList());
        HashMap<String, Object> preferences = new HashMap<String, Object>();
        for (String propertyKey : propertiesWithPrefix) {
            String preparedPropertyKey = this.getPreparedPropertyKey(propertyKey);
            String propertyValue = EnvironmentSpecificConfiguration.from((EnvironmentVariables)environmentVariables).getOptionalProperty(new String[]{propertyKey}).orElse(null);
            if (!StringUtils.isNotEmpty((CharSequence)propertyValue)) continue;
            preferences.put(preparedPropertyKey, CapabilityValue.asObject(propertyValue));
        }
        return preferences;
    }

    private String getPreparedPropertyKey(String propertyKey) {
        return propertyKey.replace(this.prefix, "");
    }
}

