/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.steps;

import net.serenitybdd.core.time.SystemClock;

public class WaitForBuilder<T> {
    private final int duration;
    private final T parent;
    private final SystemClock clock;
    private static final int MILLISECONDS_IN_A_SECOND = 1000;
    private static final int MILLISECONDS_IN_A_MINUTE = 60000;
    private static final int MILLISECONDS_IN_AN_HOUR = 3600000;

    public WaitForBuilder(int duration, T parent, SystemClock clock) {
        this.clock = clock;
        this.duration = duration;
        this.parent = parent;
    }

    public T millisecond() {
        this.clock.pauseFor((long)this.duration);
        return this.parent;
    }

    public T milliseconds() {
        this.clock.pauseFor((long)this.duration);
        return this.parent;
    }

    public T second() {
        this.clock.pauseFor((long)(this.duration * 1000));
        return this.parent;
    }

    public T seconds() {
        this.clock.pauseFor((long)(this.duration * 1000));
        return this.parent;
    }

    public T minute() {
        this.clock.pauseFor((long)(this.duration * 60000));
        return this.parent;
    }

    public T minutes() {
        this.clock.pauseFor((long)(this.duration * 60000));
        return this.parent;
    }

    public T hour() {
        this.clock.pauseFor((long)(this.duration * 3600000));
        return this.parent;
    }

    public T hours() {
        this.clock.pauseFor((long)(this.duration * 3600000));
        return this.parent;
    }
}

